/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.modeling.odstyle;

import com.scenari.s.co.transform.oo.OdFile;
import com.scenari.src.ISrcContent;
import com.scenari.src.helpers.util.SrcNodeOneShot;
import com.scenari.xerces.serialize.OutputFormat;
import com.scenari.xerces.serialize.Serializer;
import com.scenari.xerces.serialize.SerializerFactory;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import eu.scenari.modeling.odstyle.OdStyle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdStyleMerger {
    protected OdStyle fNewStruct = null;
    protected Map<String, StyleEntry> fStylesNewStruct = new HashMap<String, StyleEntry>(256);
    protected Map<String, StyleEntry> fStylesContentNewStruct = new HashMap<String, StyleEntry>(32);
    protected Map<String, Element> fMasterPagesNewStruct = new HashMap<String, Element>(12);
    protected OdStyle fOldStyles = null;
    protected Map<String, StyleEntry> fStylesOldStyles = new HashMap<String, StyleEntry>(256);
    protected Map<String, StyleEntry> fStylesContentOldStyles = new HashMap<String, StyleEntry>(32);
    protected Map<String, Element> fMasterPagesOldStyles = new HashMap<String, Element>(12);
    protected Map<String, Element> fFontFaces = new HashMap<String, Element>(12);
    protected Set<String> fReservedStyleNames = new HashSet<String>();
    protected Set<String> fResultFontFaceInStyles = new HashSet<String>();
    protected Map<String, PictureEntry> fPicturesNewStruct = new HashMap<String, PictureEntry>();
    protected Map<String, PictureEntry> fPicturesOldStyles = new HashMap<String, PictureEntry>();
    protected Set<String> fReservedPicturesPaths = new HashSet<String>();
    protected Element fFontFaceDeclsNewStruct = null;
    protected Element fRootStylesNewStruct = null;
    protected Element fRootAutomaticStylesNewStruct = null;
    protected Element fRootAutomaticStylesContentNewStruct = null;
    protected Set<String> fCoverMasterPage = new HashSet<String>();

    public OdStyle getNewStruct() {
        return this.fNewStruct;
    }

    public OdStyle getOldStyles() {
        return this.fOldStyles;
    }

    public OdStyle.Block getBlockInOldStyles(OdStyle.Block pNewStructBlock) throws Exception {
        OdStyle.Block vBlock = this.fOldStyles.getBlock(pNewStructBlock.getCode());
        if (vBlock != null && vBlock.getStructSgn().equals(pNewStructBlock.getStructSgn())) {
            return vBlock;
        }
        return null;
    }

    public void executeMerge(ISrcContent pNewStruct, ISrcContent pOldStyles, ISrcContent pTargetResult) throws Exception {
        try {
            OdFile vFileNewStruct = new OdFile();
            vFileNewStruct.initFromOdFile(pNewStruct);
            this.fNewStruct = new OdStyle();
            this.fNewStruct.initOdStyle(vFileNewStruct);
            OdFile vFileOldStyle = new OdFile();
            vFileOldStyle.initFromOdFile(pOldStyles);
            this.fOldStyles = new OdStyle();
            this.fOldStyles.initOdStyle(vFileOldStyle);
            this.xCreateStylesMap(this.fNewStruct.getContentDoc().getDocumentElement(), this.fStylesContentNewStruct);
            this.xCreateStylesMap(this.fNewStruct.getStyleDoc().getDocumentElement(), this.fStylesNewStruct);
            this.xCreateStylesMap(this.fOldStyles.getContentDoc().getDocumentElement(), this.fStylesContentOldStyles);
            this.xCreateStylesMap(this.fOldStyles.getStyleDoc().getDocumentElement(), this.fStylesOldStyles);
            this.xCreateMasterPagesMap(this.fNewStruct.getStyleDoc().getDocumentElement(), this.fMasterPagesNewStruct);
            this.xCreateMasterPagesMap(this.fOldStyles.getStyleDoc().getDocumentElement(), this.fMasterPagesOldStyles);
            this.xCreateFontFaceMap(this.fNewStruct.getStyleDoc().getDocumentElement(), true);
            this.xCreateFontFaceMap(this.fOldStyles.getStyleDoc().getDocumentElement(), false);
            for (OdStyle.Block block : this.fNewStruct.getBlocks().values()) {
                block.applyMergeRules(this);
            }
            for (String string : this.fNewStruct.getOdStyleStyles()) {
                this.addStyleInResult(string, null, null, true);
            }
            for (String string : this.fResultFontFaceInStyles) {
                this.appendChild(this.fFontFaceDeclsNewStruct, this.fFontFaces.get(string));
            }
            for (StyleEntry styleEntry : this.fStylesContentOldStyles.values()) {
                styleEntry.addInNewStructIfUsed(this);
            }
            for (StyleEntry styleEntry : this.fStylesContentNewStruct.values()) {
                styleEntry.addInNewStructIfUsed(this);
            }
            for (StyleEntry styleEntry : this.fStylesOldStyles.values()) {
                styleEntry.addInNewStructIfUsed(this);
            }
            for (Map.Entry entry : this.fStylesNewStruct.entrySet()) {
                if (((StyleEntry)entry.getValue()).isAutomaticStyle()) {
                    ((StyleEntry)entry.getValue()).addInNewStructIfUsed(this);
                    continue;
                }
                StyleEntry vOldStyleEntry = this.fStylesOldStyles.get(entry.getKey());
                if (vOldStyleEntry != null && vOldStyleEntry.isInUse()) continue;
                ((StyleEntry)entry.getValue()).addInNewStructIfUsed(this);
            }
            vFileNewStruct.removeFolder("Pictures/");
            for (PictureEntry pictureEntry : this.fPicturesNewStruct.values()) {
                vFileNewStruct.addFile(pictureEntry.getTargetPath(), pictureEntry.getSrcContent());
            }
            for (PictureEntry pictureEntry : this.fPicturesOldStyles.values()) {
                vFileNewStruct.addFile(pictureEntry.getTargetPath(), pictureEntry.getSrcContent());
            }
            Serializer vSerializer = SerializerFactory.getSerializerFactory("xml").makeSerializer(new OutputFormat("xml", "UTF-8", false));
            OutputStreamBlob outputStreamBlob = new OutputStreamBlob();
            vSerializer.setOutputByteStream(outputStreamBlob);
            vSerializer.asDOMSerializer().serialize(this.fNewStruct.getContentDoc());
            vFileNewStruct.addFile("content.xml", new SrcNodeOneShot(outputStreamBlob.getInputStream(true), outputStreamBlob.getLength(), -1L, "text/xml"));
            OutputStreamBlob vStyle = new OutputStreamBlob();
            vSerializer.setOutputByteStream(vStyle);
            vSerializer.asDOMSerializer().serialize(this.fNewStruct.getStyleDoc());
            vFileNewStruct.addFile("styles.xml", new SrcNodeOneShot(vStyle.getInputStream(true), vStyle.getLength(), -1L, "text/xml"));
            vFileNewStruct.export(pTargetResult);
        }
        catch (Exception e) {
            throw (Exception)LogMgr.addMessage((Throwable)e, "Merge odstyle failed.", new String[0]);
        }
        finally {
            if (this.fNewStruct != null) {
                this.fNewStruct.getOdFile().close();
            }
            if (this.fOldStyles != null) {
                this.fOldStyles.getOdFile().close();
            }
        }
    }

    public void addStyleInResult(String pName, Node pContext, Node pCallerToUpdate, boolean pOnlyInNewStruct) {
        String vNewName = pName;
        if (pName != null && pName.length() > 0) {
            StyleEntry vStyle = null;
            if (pContext != null && !this.isInStylesDoc(pContext)) {
                if (this.isInNewStruct(pContext)) {
                    vStyle = this.fStylesContentNewStruct.get(pName);
                } else if (!pOnlyInNewStruct) {
                    vStyle = this.fStylesContentOldStyles.get(pName);
                }
            }
            if (vStyle == null) {
                StyleEntry styleEntry = vStyle = pOnlyInNewStruct ? null : this.fStylesOldStyles.get(pName);
                if (vStyle == null) {
                    if (pContext == null || this.isInNewStruct(pContext)) {
                        vStyle = this.fStylesNewStruct.get(pName);
                    }
                } else if (vStyle.isAutomaticStyle() && pContext != null && this.isInNewStruct(pContext)) {
                    vStyle = this.fStylesNewStruct.get(pName);
                }
            }
            if (vStyle != null) {
                vNewName = vStyle.setAsUsed(this, pOnlyInNewStruct);
            }
        }
        if (pCallerToUpdate != null && vNewName != null && vNewName != pCallerToUpdate.getNodeValue()) {
            pCallerToUpdate.setNodeValue(vNewName);
        }
    }

    public void addPictureInResult(Element pImgEltFrom, Element pImgEltToUpdate) {
        String vOdPath;
        PictureEntry vPicture = null;
        String string = vOdPath = pImgEltFrom != null ? pImgEltFrom.getAttributeNS("http://www.w3.org/1999/xlink", "href") : null;
        if (vOdPath != null && vOdPath.length() > 0) {
            boolean vFromNewStruct = this.isInNewStruct(pImgEltFrom);
            PictureEntry pictureEntry = vPicture = vFromNewStruct ? this.fPicturesNewStruct.get(vOdPath) : this.fPicturesOldStyles.get(vOdPath);
            if (vPicture == null) {
                ISrcContent vContent;
                ISrcContent iSrcContent = vContent = vFromNewStruct ? this.fNewStruct.getOdFile().getSourceEntry(vOdPath) : this.fOldStyles.getOdFile().getSourceEntry(vOdPath);
                if (vContent != null) {
                    String vNewOdPath = vOdPath;
                    if (this.fReservedPicturesPaths.contains(vNewOdPath)) {
                        int vOffsetPoint = vNewOdPath.lastIndexOf(46);
                        String vPrefix = vOffsetPoint > 0 ? vNewOdPath.substring(0, vOffsetPoint) : vNewOdPath;
                        String vSuffix = vOffsetPoint > 0 ? vNewOdPath.substring(vOffsetPoint, vNewOdPath.length()) : "";
                        int vIdx = 2;
                        vNewOdPath = vPrefix + vIdx + vSuffix;
                        while (this.fReservedPicturesPaths.contains(vNewOdPath)) {
                            vNewOdPath = vPrefix + ++vIdx + vSuffix;
                        }
                    }
                    vPicture = new PictureEntry(vContent, vOdPath, vNewOdPath);
                    if (vFromNewStruct) {
                        this.fPicturesNewStruct.put(vOdPath, vPicture);
                    } else {
                        this.fPicturesOldStyles.put(vOdPath, vPicture);
                    }
                    this.fReservedPicturesPaths.add(vNewOdPath);
                }
            }
        }
        if (pImgEltToUpdate != null) {
            if (vPicture == null) {
                pImgEltToUpdate.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "");
            } else {
                pImgEltToUpdate.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", vPicture.getTargetPath());
            }
            if (pImgEltFrom != pImgEltToUpdate) {
                pImgEltToUpdate.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:type", pImgEltFrom.getAttributeNS("http://www.w3.org/1999/xlink", "type"));
                pImgEltToUpdate.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:show", pImgEltFrom.getAttributeNS("http://www.w3.org/1999/xlink", "show"));
                pImgEltToUpdate.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:actuate", pImgEltFrom.getAttributeNS("http://www.w3.org/1999/xlink", "actuate"));
            }
        }
    }

    public void addMasterPageInResult(String vMasterPageName, Attr pCallerToUpdate, boolean pOnlyInNewStruct) {
        Element vMasterPageNewStruct = this.fMasterPagesNewStruct.get(vMasterPageName);
        if (vMasterPageNewStruct != null) {
            if (!this.fCoverMasterPage.contains(vMasterPageName)) {
                Element vMasterPageOldStyles;
                this.fCoverMasterPage.add(vMasterPageName);
                Element element = vMasterPageOldStyles = pOnlyInNewStruct ? null : this.fMasterPagesOldStyles.get(vMasterPageName);
                if (vMasterPageOldStyles != null) {
                    String vLayoutStyle = vMasterPageOldStyles.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "page-layout-name");
                    Attr vPageLayoutNameNewStruct = vMasterPageNewStruct.getAttributeNodeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "page-layout-name");
                    if (vLayoutStyle != null) {
                        this.addStyleInResult(vLayoutStyle, vMasterPageOldStyles, vPageLayoutNameNewStruct, pOnlyInNewStruct);
                    } else if (vPageLayoutNameNewStruct != null) {
                        this.addStyleInResult(vPageLayoutNameNewStruct.getValue(), vMasterPageNewStruct, vPageLayoutNameNewStruct, pOnlyInNewStruct);
                    }
                    Attr vNextMasterStyleNewStruct = vMasterPageNewStruct.getAttributeNodeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "next-style-name");
                    String vNextStyleName = vMasterPageOldStyles.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "next-style-name");
                    if (vNextStyleName != null && vNextStyleName.length() > 0) {
                        if (vNextMasterStyleNewStruct == null) {
                            vNextMasterStyleNewStruct = this.getOrCreateAttr(vMasterPageNewStruct, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "next-style-name", "style:next-style-name");
                        }
                        this.addMasterPageInResult(vNextStyleName, vNextMasterStyleNewStruct, pOnlyInNewStruct);
                    } else if (vNextMasterStyleNewStruct != null) {
                        vMasterPageNewStruct.removeAttributeNode(vNextMasterStyleNewStruct);
                    }
                } else {
                    Attr vNextMasterStyle;
                    Attr vLayoutStyle = vMasterPageNewStruct.getAttributeNodeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "page-layout-name");
                    if (vLayoutStyle != null) {
                        this.addStyleInResult(vLayoutStyle.getValue(), vMasterPageNewStruct, vLayoutStyle, pOnlyInNewStruct);
                    }
                    if ((vNextMasterStyle = vMasterPageNewStruct.getAttributeNodeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "next-style-name")) != null && vNextMasterStyle.getValue().length() > 0) {
                        this.addMasterPageInResult(vNextMasterStyle.getValue(), vNextMasterStyle, pOnlyInNewStruct);
                    }
                }
            }
            if (pCallerToUpdate != null && !pCallerToUpdate.getValue().equals(vMasterPageName)) {
                pCallerToUpdate.setNodeValue(vMasterPageName);
            }
        } else if (pCallerToUpdate != null) {
            pCallerToUpdate.getOwnerElement().removeAttributeNode(pCallerToUpdate);
        }
    }

    protected void xCreateStylesMap(Element pElt, Map<String, StyleEntry> pStyleMap) throws Exception {
        String vName;
        StyleEntry vNewEntry;
        boolean vIsInNewStruct;
        boolean vSearchInChildren = false;
        boolean bl = vIsInNewStruct = pStyleMap == this.fStylesNewStruct || pStyleMap == this.fStylesContentNewStruct;
        if (pElt.getLocalName().equals("style") || pElt.getLocalName().equals("list-style") || pElt.getLocalName().equals("page-layout")) {
            vNewEntry = new StyleEntry(pElt);
            vName = vNewEntry.getOriginalName();
            if (vIsInNewStruct || !this.fNewStruct.getOdStyleStyles().contains(vName)) {
                pStyleMap.put(vName, vNewEntry);
                if (!vNewEntry.isAutomaticStyle()) {
                    this.fReservedStyleNames.add(vName);
                }
            }
            if (vIsInNewStruct) {
                pElt.getParentNode().removeChild(pElt);
            }
        } else if (pElt.getLocalName().equals("notes-configuration")) {
            vNewEntry = new StyleEntry(pElt, "notes-configuration:" + pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "note-class"));
            vName = vNewEntry.getOriginalName();
            pStyleMap.put(vName, vNewEntry);
        } else if (pElt.getLocalName().equals("linenumbering-configuration")) {
            vNewEntry = new StyleEntry(pElt, "linenumbering-configuration:");
            vName = vNewEntry.getOriginalName();
            pStyleMap.put(vName, vNewEntry);
        } else if (pElt.getLocalName().equals("outline-style")) {
            vNewEntry = new StyleEntry(pElt, "outline-style:" + pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name"));
            vName = vNewEntry.getOriginalName();
            pStyleMap.put(vName, vNewEntry);
        } else if (pElt.getLocalName().equals("styles")) {
            vSearchInChildren = true;
            if (vIsInNewStruct) {
                this.fRootStylesNewStruct = pElt;
            }
        } else if (pElt.getLocalName().equals("automatic-styles")) {
            vSearchInChildren = true;
            if (vIsInNewStruct) {
                if (pElt.getParentNode().getLocalName().equals("document-styles")) {
                    this.fRootAutomaticStylesNewStruct = pElt;
                } else {
                    this.fRootAutomaticStylesContentNewStruct = pElt;
                }
            }
        } else if (pElt.getLocalName().equals("document-styles") || pElt.getLocalName().equals("document-content")) {
            vSearchInChildren = true;
        }
        if (vSearchInChildren && pElt.hasChildNodes()) {
            Node vNode = pElt.getFirstChild();
            while (vNode != null) {
                Node vNextNode = vNode.getNextSibling();
                if (vNode.getNodeType() == 1) {
                    this.xCreateStylesMap((Element)vNode, pStyleMap);
                }
                vNode = vNextNode;
            }
        }
    }

    protected void xCreateMasterPagesMap(Element pElt, Map<String, Element> pMasterPageMap) throws Exception {
        boolean vSearchInChildren = false;
        if (pElt.getLocalName().equals("master-page")) {
            pMasterPageMap.put(pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name"), pElt);
        } else if (pElt.getLocalName().equals("document-styles") || pElt.getLocalName().equals("master-styles")) {
            vSearchInChildren = true;
        }
        if (vSearchInChildren) {
            for (Node vNode = pElt.getFirstChild(); vNode != null; vNode = vNode.getNextSibling()) {
                if (vNode.getNodeType() != 1) continue;
                this.xCreateMasterPagesMap((Element)vNode, pMasterPageMap);
            }
        }
    }

    protected void xCreateFontFaceMap(Element pElt, boolean pIsInNewStruct) throws Exception {
        boolean vSearchInChildren = false;
        if (pElt.getLocalName().equals("font-face")) {
            this.fFontFaces.put(pElt.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name"), pElt);
        } else if (pElt.getLocalName().equals("document-styles")) {
            vSearchInChildren = true;
        } else if (pElt.getLocalName().equals("font-face-decls")) {
            vSearchInChildren = true;
            if (pIsInNewStruct) {
                this.fFontFaceDeclsNewStruct = pElt;
            }
        }
        if (vSearchInChildren) {
            for (Node vNode = pElt.getFirstChild(); vNode != null; vNode = vNode.getNextSibling()) {
                if (vNode.getNodeType() != 1) continue;
                this.xCreateFontFaceMap((Element)vNode, pIsInNewStruct);
            }
        }
    }

    protected boolean isInNewStruct(Node pElt) {
        Document vDoc = pElt.getOwnerDocument();
        return vDoc == this.fNewStruct.getContentDoc() || vDoc == this.fNewStruct.getStyleDoc();
    }

    protected boolean isInStylesDoc(Node pElt) {
        Document vDoc = pElt.getOwnerDocument();
        return vDoc == this.fNewStruct.getStyleDoc() || vDoc == this.fOldStyles.getStyleDoc();
    }

    protected Attr getOrCreateAttr(Element pElt, String pNs, String pLocalName, String pFullName) {
        Attr vAttr = pElt.getAttributeNodeNS(pNs, pLocalName);
        if (vAttr == null) {
            pElt.setAttributeNS(pNs, pFullName, "");
            vAttr = pElt.getAttributeNodeNS(pNs, pLocalName);
        }
        return vAttr;
    }

    protected Node appendChild(Element pParent, Node pChild) throws Exception {
        if (pChild == null) {
            return null;
        }
        Node vChild = pChild;
        if (pParent.getOwnerDocument() != pChild.getOwnerDocument()) {
            vChild = pParent.getOwnerDocument().importNode(pChild, true);
        }
        pParent.appendChild(vChild);
        return vChild;
    }

    protected Node replaceNode(Node pNew, Node pOld) throws Exception {
        if (pNew == null) {
            return null;
        }
        Node vNew = pNew;
        if (pNew.getOwnerDocument() != pOld.getOwnerDocument()) {
            vNew = pOld.getOwnerDocument().importNode(pNew, true);
        }
        pOld.getParentNode().replaceChild(vNew, pOld);
        return vNew;
    }

    public static class PictureEntry {
        protected ISrcContent fSrcContent;
        protected String fPath;
        protected String fTargetPath;

        public PictureEntry(ISrcContent pSrcContent, String pPath, String pTargetPath) {
            this.fSrcContent = pSrcContent;
            this.fPath = pPath;
            this.fTargetPath = pTargetPath;
        }

        public ISrcContent getSrcContent() {
            return this.fSrcContent;
        }

        public String getPath() {
            return this.fPath;
        }

        public String getTargetPath() {
            return this.fTargetPath;
        }
    }

    public static class StyleEntry {
        protected Element fDef;
        protected String fOriginalName;
        protected boolean fIsAutomaticStyle;
        protected boolean fInUse = false;

        public StyleEntry(Element pDef) {
            this.fDef = pDef;
            this.fOriginalName = this.getName();
            this.fIsAutomaticStyle = pDef.getParentNode().getLocalName().equals("automatic-styles");
        }

        public StyleEntry(Element pDef, String pOriginalName) {
            this.fDef = pDef;
            this.fOriginalName = pOriginalName;
            this.fIsAutomaticStyle = pDef.getParentNode().getLocalName().equals("automatic-styles");
        }

        public String setAsUsed(OdStyleMerger pMerger, boolean pOnlyInNewStruct) {
            String vName = this.getName();
            if (!this.fInUse) {
                Attr vMasterPageName;
                String vStyle;
                String vParentStyle;
                this.fInUse = true;
                if (this.fIsAutomaticStyle && !pMerger.fReservedStyleNames.add(vName)) {
                    int vIdx = 2;
                    String vNewName = vName + vIdx;
                    while (!pMerger.fReservedStyleNames.add(vNewName)) {
                        vNewName = vName + ++vIdx;
                    }
                    vName = vNewName;
                    this.fDef.setAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style:name", vName);
                }
                if ((vParentStyle = this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "parent-style-name")) != null && vParentStyle.length() > 0) {
                    pMerger.addStyleInResult(vParentStyle, this.fDef, this.fDef, pOnlyInNewStruct);
                }
                if (this.fDef.getLocalName().equals("notes-configuration")) {
                    String vCitationBodyStyle;
                    String vCitationStyle = this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "citation-style-name");
                    if (vCitationStyle != null && vCitationStyle.length() > 0) {
                        pMerger.addStyleInResult(vCitationStyle, this.fDef, this.fDef, pOnlyInNewStruct);
                    }
                    if ((vCitationBodyStyle = this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "citation-body-style-name")) != null && vCitationBodyStyle.length() > 0) {
                        pMerger.addStyleInResult(vCitationBodyStyle, this.fDef, this.fDef, pOnlyInNewStruct);
                    }
                }
                if (this.fDef.getLocalName().equals("linenumbering-configuration") && (vStyle = this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name")) != null && vStyle.length() > 0) {
                    pMerger.addStyleInResult(vStyle, this.fDef, this.fDef, pOnlyInNewStruct);
                }
                if ((vMasterPageName = this.fDef.getAttributeNodeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "master-page-name")) != null && vMasterPageName.getValue().length() > 0) {
                    pMerger.addMasterPageInResult(vMasterPageName.getValue(), vMasterPageName, pOnlyInNewStruct);
                }
                this.xSetAsUsedInChildren(this.fDef, pMerger, pOnlyInNewStruct);
            }
            return vName;
        }

        protected void xSetAsUsedInChildren(Element pElt, OdStyleMerger pMerger, boolean pOnlyInNewStruct) {
            Attr vAttr = pElt.getAttributeNodeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name");
            if (vAttr != null) {
                pMerger.addStyleInResult(vAttr.getValue(), pElt, vAttr, pOnlyInNewStruct);
            }
            if (pElt.hasAttributeNS("http://www.w3.org/1999/xlink", "href")) {
                pMerger.addPictureInResult(pElt, pElt);
            }
            if ((vAttr = pElt.getAttributeNodeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "font-name")) != null && vAttr.getValue().length() > 0) {
                pMerger.fResultFontFaceInStyles.add(vAttr.getValue());
            }
            for (Node vNode = pElt.getFirstChild(); vNode != null; vNode = vNode.getNextSibling()) {
                if (vNode.getNodeType() != 1) continue;
                this.xSetAsUsedInChildren((Element)vNode, pMerger, pOnlyInNewStruct);
            }
        }

        public String getOriginalName() {
            return this.fOriginalName;
        }

        public String getName() {
            return this.fDef.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name");
        }

        public boolean isAutomaticStyle() {
            return this.fIsAutomaticStyle;
        }

        public boolean isInUse() {
            return this.fInUse;
        }

        public void addInNewStructIfUsed(OdStyleMerger pMerger) throws Exception {
            if (this.fInUse) {
                if (this.fIsAutomaticStyle) {
                    if (pMerger.isInStylesDoc(this.fDef)) {
                        pMerger.appendChild(pMerger.fRootAutomaticStylesNewStruct, this.fDef);
                    } else {
                        pMerger.appendChild(pMerger.fRootAutomaticStylesContentNewStruct, this.fDef);
                    }
                } else {
                    pMerger.appendChild(pMerger.fRootStylesNewStruct, this.fDef);
                }
            }
        }
    }
}

