/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.modeling.odstyle.ant;

import com.scenari.src.fs.mini.FsMiniFactory;
import com.scenari.src.fs.mini.FsMiniSrcContent;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.modeling.odstyle.OdStyleMerger;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class OdStyleMergeTask
extends Task {
    protected File fNewStyle = null;
    protected File fOldStyle = null;
    protected File fResultStyle = null;

    public void execute() {
        if (this.fNewStyle == null || !this.fNewStyle.exists()) {
            throw new BuildException("newStyle " + this.fNewStyle.toString() + " does not exist", this.getLocation());
        }
        if (this.fOldStyle == null || !this.fOldStyle.exists()) {
            throw new BuildException("oldStyle " + this.fOldStyle.toString() + " does not exist", this.getLocation());
        }
        if (this.fResultStyle == null || this.fResultStyle.exists()) {
            throw new BuildException("resultStyle " + this.fOldStyle.toString() + " already exist or isn't correctly specified", this.getLocation());
        }
        try {
            OdStyleMerger vMerger = new OdStyleMerger();
            FsMiniSrcContent vNewStruct = FsMiniFactory.newContentFromCanonicalFile(this.fNewStyle);
            FsMiniSrcContent vOldStyle = FsMiniFactory.newContentFromCanonicalFile(this.fOldStyle);
            FsMiniSrcContent vOdResult = FsMiniFactory.newContentFromCanonicalFile(this.fResultStyle);
            vMerger.executeMerge(vNewStruct, vOldStyle, vOdResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogMgr.addMessage((Throwable)e, "odStyleMerge failed :\n" + e.getMessage(), new String[0]);
            throw (BuildException)LogMgr.addMessage(new BuildException((Throwable)e, this.getLocation()), LogMgr.getMessage(e));
        }
    }

    public File getNewStyle() {
        return this.fNewStyle;
    }

    public File getOldStyle() {
        return this.fOldStyle;
    }

    public File getResultStyle() {
        return this.fResultStyle;
    }

    public void setNewStyle(File pNewStyle) {
        this.fNewStyle = pNewStyle;
    }

    public void setOldStyle(File pOldStyle) {
        this.fOldStyle = pOldStyle;
    }

    public void setResultStyle(File pResultStyle) {
        this.fResultStyle = pResultStyle;
    }
}

