/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.modeling.textprim;

import eu.scenari.fw.util.xml.DomHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.NodeIterator;

public class TableLayout {
    public static final String TAG_COL = "column";
    public static final String TAG_ROW = "row";
    public static final String TAG_CELL = "cell";
    public static final String ATT_ROWSPAN = "rowSpan";
    public static final String ATT_COLSPAN = "colSpan";
    protected List<Element> fMapRows = new ArrayList<Element>();
    protected Element[] fMapCells;
    protected int fCountColumns = 0;

    public TableLayout(NodeIterator pTable) {
        this((Element)pTable.nextNode());
    }

    public TableLayout(Element pTable) {
        Element vRow = DomHelper.getFirstElementChild(pTable, "http://www.utc.fr/ics/scenari/v3/core", TAG_ROW);
        while (vRow != null) {
            this.fMapRows.add(vRow);
            vRow = DomHelper.getNextElementSibling(vRow, "http://www.utc.fr/ics/scenari/v3/core", TAG_ROW);
        }
        this.fCountColumns = 0;
        Element vCol = DomHelper.getFirstElementChild(pTable, "http://www.utc.fr/ics/scenari/v3/core", TAG_COL);
        while (vCol != null) {
            ++this.fCountColumns;
            vCol = DomHelper.getNextElementSibling(vCol, "http://www.utc.fr/ics/scenari/v3/core", TAG_COL);
        }
        this.fMapCells = new Element[this.fMapRows.size() * this.fCountColumns];
        block2: for (int vRowIdx = 0; vRowIdx < this.fMapRows.size(); ++vRowIdx) {
            vRow = this.fMapRows.get(vRowIdx);
            int vStartRowIdx = vRowIdx * this.fCountColumns;
            int vEndRowIdx = vStartRowIdx + this.fCountColumns;
            int vOffset = vStartRowIdx;
            Element vCell = DomHelper.getFirstElementChild(vRow, "http://www.utc.fr/ics/scenari/v3/core", TAG_CELL);
            while (vCell != null) {
                int vRowSpan = this.getSpan(vCell, ATT_ROWSPAN);
                int vColSpan = this.getSpan(vCell, ATT_COLSPAN);
                while (this.fMapCells[vOffset] != null) {
                    if (++vOffset < vEndRowIdx) continue;
                    continue block2;
                }
                block5: for (int vRowOffset = 1; vRowOffset < vRowSpan && vRowOffset + vRowIdx < this.fMapRows.size(); ++vRowOffset) {
                    int vStartSubRow = (vRowOffset + vRowIdx) * this.fCountColumns;
                    int vEndSubRow = vStartSubRow + this.fCountColumns;
                    int vSubRowOffset = vStartSubRow + vOffset - vStartRowIdx;
                    for (int vColOffset = 0; vColOffset < vColSpan; ++vColOffset) {
                        this.fMapCells[vSubRowOffset++] = vCell;
                        if (vSubRowOffset >= vEndSubRow) continue block5;
                    }
                }
                for (int vColOffset = 0; vColOffset < vColSpan; ++vColOffset) {
                    this.fMapCells[vOffset++] = vCell;
                    if (vOffset >= vEndRowIdx) continue block2;
                }
                vCell = DomHelper.getNextElementSibling(vCell, "http://www.utc.fr/ics/scenari/v3/core", TAG_CELL);
            }
        }
    }

    public int getColumnIdx(Element pCell) {
        if (pCell != null) {
            for (int i = 0; i < this.fMapCells.length; ++i) {
                if (this.fMapCells[i] != pCell) continue;
                return i % this.fCountColumns;
            }
        }
        return -1;
    }

    public int getColumnIdx(NodeIterator pCell) {
        return this.getColumnIdx((Element)pCell.nextNode());
    }

    public int getRowIdx(Element pCell) {
        if (pCell != null) {
            for (int i = 0; i < this.fMapCells.length; ++i) {
                if (this.fMapCells[i] != pCell) continue;
                return i / this.fCountColumns;
            }
        }
        return -1;
    }

    public int getRowIdx(NodeIterator pCell) {
        return this.getRowIdx((Element)pCell.nextNode());
    }

    protected int getSpan(Element pCell, String pLocalName) {
        String vSpan = pCell.getAttribute(pLocalName);
        if (vSpan != null) {
            try {
                return Math.max(1, Integer.parseInt(vSpan));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 1;
    }
}

