/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.modeling.util;

import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;

public class Math {
    public static String coordsAdd(String pCoords, String pNumber) {
        return Math.coordsAdd(pCoords, pNumber, ",");
    }

    public static String coordsAdd(String pCoords, String pNumber, String pDelim) {
        if (pCoords == null || pCoords.length() == 0) {
            return "";
        }
        try {
            String[] vCoords = pCoords.split(pDelim);
            float vNumber = Float.valueOf(pNumber).floatValue();
            for (int i = 0; i < vCoords.length; ++i) {
                float vNewVal = Float.parseFloat(vCoords[i]) + vNumber;
                vCoords[i] = Float.toString(vNewVal);
            }
            return Math.arrayToString(vCoords, pDelim);
        }
        catch (IllegalArgumentException e) {
            LogMgr.publishTrace("Malformed coordinates list : %s", ILogMsg.LogType.Warning, pCoords);
            return "";
        }
    }

    public static String coordsRatio(String pCoords, String pRatio) {
        return Math.coordsRatio(pCoords, pRatio, ",");
    }

    public static String coordsRatio(String pCoords, String pRatio, String pDelim) {
        if (pCoords == null || pCoords.length() == 0) {
            return "";
        }
        try {
            String[] vCoords = pCoords.split(pDelim);
            float vRatio = Float.valueOf(pRatio).floatValue();
            for (int i = 0; i < vCoords.length; ++i) {
                float vNewVal = Float.parseFloat(vCoords[i]) * vRatio;
                vCoords[i] = Float.toString(vNewVal);
            }
            return Math.arrayToString(vCoords, pDelim);
        }
        catch (IllegalArgumentException e) {
            LogMgr.publishTrace("Malformed coordinates list : %s", ILogMsg.LogType.Warning, pCoords);
            return "";
        }
    }

    private static String arrayToString(String[] pStr, String pDelim) {
        StringBuffer vRes = new StringBuffer();
        if (pStr.length > 0) {
            vRes.append(pStr[0]);
            for (int i = 1; i < pStr.length; ++i) {
                vRes.append(pDelim);
                vRes.append(pStr[i]);
            }
        }
        return vRes.toString();
    }
}

