/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.src.impl.xslfilter;

import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.copymove.ICopyMoveAspect;
import com.scenari.src.feature.fields.IFieldsCollector;
import com.scenari.src.feature.fields.IFieldsProviderAspect;
import com.scenari.src.feature.fields.SrcFeatureFields;
import com.scenari.src.feature.refresh.IRefreshAspect;
import com.scenari.src.feature.refresh.SrcFeatureRefresh;
import com.scenari.src.feature.streams.IWriteFromInputAspect;
import com.scenari.src.feature.streams.SrcFeatureStreams;
import com.scenari.src.helpers.base.SrcNodeWrapper;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import eu.scenari.src.impl.xslfilter.XslFilterSrcSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XslFilterSrcNode
extends SrcNodeWrapper
implements IRefreshAspect,
IWriteFromInputAspect,
IFieldsProviderAspect {
    protected XslFilterSrcSystem fSystem;
    protected File fTmpSrc = null;
    protected long fLastModifMemorized = -1L;
    protected XslFilterSrcSystem.Binding fBinding = null;

    protected XslFilterSrcNode(XslFilterSrcSystem pSystem, ISrcContent pSubSource) {
        super(pSubSource);
        this.fSystem = pSystem;
        this.fBinding = this.fSystem.getBinding(this);
    }

    protected Object getAspectForThis(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == IRefreshAspect.TYPE) {
            return this;
        }
        if (pDefinition == IWriteFromInputAspect.TYPE) {
            return this;
        }
        if (pDefinition == SrcFeatureAlternateUrl.FILEPATH_ASPECT_TYPE) {
            return this.getAsFilePath();
        }
        if (pDefinition == IFieldsProviderAspect.TYPE) {
            return this;
        }
        return super.getAspectForThis(pDefinition);
    }

    protected boolean isAspectFromSubSourceAllowed(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ICopyMoveAspect.TYPE) {
            return true;
        }
        if (pDefinition.canReadContent() || pDefinition.canWriteContent()) {
            return false;
        }
        if (pDefinition.canReadProperties()) {
            return false;
        }
        return super.isAspectFromSubSourceAllowed(pDefinition);
    }

    protected ISrcNode xCreateSrcNode(ISrcNode pSubSource) throws Exception {
        return new XslFilterSrcNode(this.fSystem, pSubSource);
    }

    public synchronized boolean refresh() throws Exception {
        long vNewLastModif;
        ISrcNode vSubSrc = this.getSubSrcNode();
        if (!SrcFeatureRefresh.refresh(vSubSrc)) {
            return false;
        }
        if (this.fBinding != null && ((vNewLastModif = vSubSrc.getLastModifWithChildren()) == -1L || vNewLastModif != this.fLastModifMemorized)) {
            this.load(vNewLastModif);
        }
        return true;
    }

    public synchronized int getContentSize() throws Exception {
        this.check();
        return this.fTmpSrc != null ? (int)this.fTmpSrc.length() : this.getSubSrcNode().getContentSize();
    }

    public synchronized InputStream newInputStream(boolean pEnsureBuffered) throws Exception {
        this.check();
        if (this.fTmpSrc != null) {
            return pEnsureBuffered ? new BufferedInputStream(new FileInputStream(this.fTmpSrc)) : new FileInputStream(this.fTmpSrc);
        }
        return super.newInputStream(pEnsureBuffered);
    }

    public synchronized OutputStream newOutputStream(boolean pEnsureBuffered) throws Exception {
        this.check();
        if (this.fBinding == null || this.fBinding.getSc2ForeignXsl() == null) {
            return this.getSubSrcNode().newOutputStream(pEnsureBuffered);
        }
        return new SrcFeatureStreams.RedirectOutpuStreamToWriteFrom(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeFrom(InputStream pIn) throws Exception {
        try {
            this.check();
            this.fLastModifMemorized = -1L;
            if (this.fBinding != null && this.fBinding.getSc2ForeignXsl() != null) {
                OutputStreamBlob vBuff = new OutputStreamBlob();
                try {
                    Transformer vXslt = this.fBinding.getSc2ForeignXsl().newTransformer();
                    vXslt.transform(new StreamSource(pIn), new StreamResult(vBuff));
                }
                catch (Exception e) {
                    throw (Exception)LogMgr.addMessage((Throwable)e, "Translating Scenari to Foreign scheme failed : %s", this.getSrcUri());
                }
                SrcFeatureStreams.writeFrom(this.getSubSrcNode(), vBuff.getInputStream(false));
                vBuff.closeStream();
                return;
            }
            OutputStream vOut = this.getSubSrcNode().newOutputStream(false);
            try {
                StreamUtils.write(pIn, vOut);
            }
            finally {
                vOut.close();
            }
        }
        catch (Exception e) {
            pIn.close();
            throw e;
        }
    }

    protected void check() throws Exception {
        if (this.fLastModifMemorized == -1L) {
            this.load(this.getSubSrcNode().getLastModifWithChildren());
        }
    }

    public void fillFields(IFieldsCollector pFieldsToCollect) throws Exception {
        SrcFeatureAlternateUrl.fillFields(this, pFieldsToCollect);
        if (pFieldsToCollect.isDataUnfilled(SrcFeatureFields.DATAKEY_CONTENTSIZE)) {
            pFieldsToCollect.setData(SrcFeatureFields.DATAKEY_CONTENTSIZE, this.getContentSize());
        }
        SrcFeatureFields.fillFields(this.getSubSrcNode(), pFieldsToCollect);
    }

    protected void load(long pLastModifWithChildren) throws Exception {
        assert (Thread.holdsLock(this));
        ISrcNode vSubSrc = this.getSubSrcNode();
        this.fLastModifMemorized = pLastModifWithChildren;
        if (this.fBinding != null && vSubSrc.getContentStatus() == 1) {
            if (this.fTmpSrc == null) {
                this.fTmpSrc = this.fSystem.createTmpFile(this);
            }
            if (this.fBinding.getForeign2ScXsl() != null) {
                if (this.getSubSrcNode().getContentSize() > 0) {
                    Transformer vXslt = this.fBinding.getForeign2ScXsl().newTransformer();
                    BufferedOutputStream vOut = new BufferedOutputStream(new FileOutputStream(this.fTmpSrc));
                    InputStream vIn = null;
                    try {
                        vIn = vSubSrc.newInputStream(false);
                        vXslt.transform(new StreamSource(vIn), new StreamResult(vOut));
                        return;
                    }
                    catch (Exception e) {
                        ((OutputStream)vOut).close();
                        if (vIn != null) {
                            vIn.close();
                        }
                        LogMgr.publishException((Throwable)e, "Translating Foreign to Scenari scheme failed : %s", ILogMsg.LogType.Warning, this.getSrcUri());
                    }
                }
            } else {
                SrcFeatureStreams.writeTo(vSubSrc, new FileOutputStream(this.fTmpSrc), true);
                return;
            }
        }
        if (this.fTmpSrc != null) {
            this.fTmpSrc.delete();
            this.fTmpSrc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAsFilePath() throws Exception {
        switch (this.fSystem.fViewAsFilePath) {
            case foreign: {
                return SrcFeatureAlternateUrl.getFilePath(this.getSubSrcNode());
            }
            case sc: {
                XslFilterSrcNode xslFilterSrcNode = this;
                synchronized (xslFilterSrcNode) {
                    this.check();
                    return this.fTmpSrc.getCanonicalPath();
                }
            }
        }
        return null;
    }
}

