/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.src.impl.xslfilter;

import com.scenari.s.fw.util.xml.HXmlParserAttributes;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.system.ISrcSystem;
import com.scenari.src.system.SrcSystemWrapperBase;
import com.scenari.xsldom.xalan.processor.TransformerFactoryImpl;
import eu.scenari.src.impl.xslfilter.XslFilterSrcNode;
import eu.scenari.src.impl.xslfilter.XslFilterSrcSystemLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ContentHandler;

public class XslFilterSrcSystem
extends SrcSystemWrapperBase {
    protected List<Binding> fBindings = new ArrayList<Binding>();
    protected ViewAsFilePath fViewAsFilePath = ViewAsFilePath.none;

    public Binding createNewBinding() {
        Binding vBd = new Binding();
        this.fBindings.add(vBd);
        return vBd;
    }

    public void setViewAsFilePath(ViewAsFilePath pViewAsFilePath) {
        this.fViewAsFilePath = pViewAsFilePath;
    }

    public void setViewAsFilePath(String pViewAsFilePath) {
        this.fViewAsFilePath = pViewAsFilePath == null || pViewAsFilePath.length() == 0 ? ViewAsFilePath.none : ViewAsFilePath.valueOf(pViewAsFilePath);
    }

    public void publishDefinition(ContentHandler pHandler) throws Exception {
        HXmlParserAttributes vAtts = new HXmlParserAttributes(2);
        vAtts.hAdd("", "type", "type", XslFilterSrcSystemLoader.class.getName());
        if (this.fViewAsFilePath != ViewAsFilePath.none) {
            vAtts.hAdd("", "viewAsFilePath", "viewAsFilePath", this.fViewAsFilePath.name());
        }
        pHandler.startElement("", "source", "source", vAtts);
        for (Binding vBinding : this.fBindings) {
            vBinding.publishDefinition(pHandler, vAtts);
        }
        this.fSubSourceSystem.publishDefinition(pHandler);
        pHandler.endElement("", "source", "source");
    }

    public ISrcNode getStartSrcNode() throws Exception {
        return new XslFilterSrcNode(this, this.fSubSourceSystem.getStartSrcNode());
    }

    public Binding getBinding(XslFilterSrcNode pSrc) {
        for (Binding vBinding : this.fBindings) {
            if (!vBinding.isMatch(pSrc)) continue;
            return vBinding;
        }
        return null;
    }

    public File createTmpFile(XslFilterSrcNode pSrcNode) throws Exception {
        File vResult = File.createTempFile(pSrcNode.getSrcName(), null, null);
        vResult.deleteOnExit();
        return vResult;
    }

    public class Binding {
        protected List<UriMatching> fMatchRules = new ArrayList<UriMatching>();
        protected ISrcSystem fSc2ForeignSystem = null;
        protected String fSc2ForeignPath = null;
        protected ISrcSystem fForeign2ScSystem = null;
        protected String fForeign2ScPath = null;
        protected String fProcessor = null;
        protected Templates fSc2ForeignXsl = null;
        protected Templates fForeign2ScXsl = null;

        public boolean isMatch(ISrcNode pSrc) {
            for (UriMatching vUriMatching : this.fMatchRules) {
                if (!vUriMatching.isMatch(pSrc)) continue;
                return true;
            }
            return false;
        }

        public void addUriMatching(String pRegExp) {
            UriMatching vMatch = new UriMatching(Pattern.compile(pRegExp));
            this.fMatchRules.add(vMatch);
        }

        public void setProcessor(String pProcessor) {
            this.fProcessor = pProcessor;
        }

        public void setForeign2ScSrc(ISrcSystem pSrcSystem, String pPath) {
            this.fForeign2ScSystem = pSrcSystem;
            this.fForeign2ScPath = pPath;
        }

        public void setSc2ForeignSrc(ISrcSystem pSrcSystem, String pPath) {
            this.fSc2ForeignSystem = pSrcSystem;
            this.fSc2ForeignPath = pPath;
        }

        public Templates getForeign2ScXsl() throws Exception {
            if (this.fForeign2ScXsl == null && this.fForeign2ScSystem != null) {
                TransformerFactory vTransfFact = null;
                if (this.fProcessor != null && this.fProcessor.length() > 0) {
                    vTransfFact = (TransformerFactory)Class.forName(this.fProcessor).newInstance();
                }
                if (vTransfFact == null) {
                    vTransfFact = new TransformerFactoryImpl();
                }
                ISrcNode vXslSrc = SrcFeaturePaths.findNodeByPath(this.fForeign2ScSystem.getStartSrcNode(), this.fForeign2ScPath, false);
                vTransfFact.setURIResolver(SrcFeaturePaths.newSrcNodeResolver(vXslSrc, null));
                this.fForeign2ScXsl = vTransfFact.newTemplates(new StreamSource(vXslSrc.newInputStream(false), SrcFeaturePaths.getXmlSystemId(vXslSrc)));
            }
            return this.fForeign2ScXsl;
        }

        public Templates getSc2ForeignXsl() throws Exception {
            if (this.fSc2ForeignXsl == null && this.fSc2ForeignSystem != null) {
                TransformerFactory vTransfFact = null;
                if (this.fProcessor != null && this.fProcessor.length() > 0) {
                    vTransfFact = (TransformerFactory)Class.forName(this.fProcessor).newInstance();
                }
                if (vTransfFact == null) {
                    vTransfFact = new TransformerFactoryImpl();
                }
                ISrcNode vXslSrc = SrcFeaturePaths.findNodeByPath(this.fSc2ForeignSystem.getStartSrcNode(), this.fSc2ForeignPath, false);
                vTransfFact.setURIResolver(SrcFeaturePaths.newSrcNodeResolver(vXslSrc, null));
                this.fSc2ForeignXsl = vTransfFact.newTemplates(new StreamSource(vXslSrc.newInputStream(false), SrcFeaturePaths.getXmlSystemId(vXslSrc)));
            }
            return this.fSc2ForeignXsl;
        }

        public void publishDefinition(ContentHandler pHandler, HXmlParserAttributes pAtts) throws Exception {
            pAtts.hReset();
            pHandler.startElement("", "binding", "binding", pAtts);
            for (UriMatching vMatchRule : this.fMatchRules) {
                vMatchRule.publishDefinition(pHandler, pAtts);
            }
            if (this.fProcessor != null && this.fProcessor.length() > 0) {
                pAtts.hReset();
                pAtts.hAdd("", "processor", "processor", this.fProcessor);
                pHandler.startElement("", "xsltConfig", "xsltConfig", pAtts);
                pHandler.endElement("", "xsltConfig", "xsltConfig");
            }
            if (this.fForeign2ScSystem != null) {
                pAtts.hReset();
                pAtts.hAdd("", "path", "path", this.fForeign2ScPath);
                pHandler.startElement("", "xslForeign2Sc", "xslForeign2Sc", pAtts);
                this.fForeign2ScSystem.publishDefinition(pHandler);
                pHandler.endElement("", "xslForeign2Sc", "xslForeign2Sc");
            }
            if (this.fSc2ForeignSystem != null) {
                pAtts.hReset();
                pAtts.hAdd("", "path", "path", this.fSc2ForeignPath);
                pHandler.startElement("", "xslSc2Foreign", "xslSc2Foreign", pAtts);
                this.fSc2ForeignSystem.publishDefinition(pHandler);
                pHandler.endElement("", "xslSc2Foreign", "xslSc2Foreign");
            }
            pHandler.endElement("", "binding", "binding");
        }
    }

    public static class UriMatching {
        protected Pattern fRegExp = null;

        public UriMatching(Pattern pRegExp) {
            this.fRegExp = pRegExp;
        }

        public boolean isMatch(ISrcNode pSrc) {
            return this.fRegExp.matcher(pSrc.getSrcUri()).matches();
        }

        public void publishDefinition(ContentHandler pHandler, HXmlParserAttributes pAtts) throws Exception {
            pAtts.hReset();
            pAtts.hAdd("", "regexp", "regexp", this.fRegExp.pattern());
            pHandler.startElement("", "uriMatching", "uriMatching", pAtts);
            pHandler.endElement("", "uriMatching", "uriMatching");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewAsFilePath {
        foreign,
        sc,
        none;

    }
}

