/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.transform.util;

import eu.scenari.fw.log.LogMgr;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessPipeStream
implements Runnable {
    public static String sExecutorClass = null;
    public static int sSizePoolGenerators = -1;
    protected static ExecutorService sExecutor = null;
    protected InputStream fIn;
    protected Appendable fOut;
    protected String fCharset;

    protected static synchronized ExecutorService getExecutorService() {
        if (sExecutor == null) {
            if (sExecutorClass != null) {
                try {
                    sExecutor = (ExecutorService)Class.forName(sExecutorClass).newInstance();
                }
                catch (Exception e) {
                    LogMgr.publishException((Throwable)e, "Generators async executor : loading class '" + sExecutorClass + "' failed.", new String[0]);
                }
                if (sExecutor != null) {
                    return sExecutor;
                }
            }
            sExecutor = sSizePoolGenerators <= 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(sSizePoolGenerators);
        }
        return sExecutor;
    }

    public static Future<?> pipeStream(InputStream pIn) {
        return ProcessPipeStream.getExecutorService().submit(new ProcessPipeStream(pIn, null, null));
    }

    public static <T extends Appendable> Future<T> pipeStream(InputStream pIn, T pOut) {
        return ProcessPipeStream.getExecutorService().submit(new ProcessPipeStream(pIn, pOut, null), pOut);
    }

    public static <T extends Appendable> Future<T> pipeStream(InputStream pIn, T pOut, String pCharset) {
        return ProcessPipeStream.getExecutorService().submit(new ProcessPipeStream(pIn, pOut, pCharset), pOut);
    }

    protected ProcessPipeStream(InputStream pIn, Appendable pOut, String pCharset) {
        this.fIn = pIn;
        this.fOut = pOut;
        this.fCharset = pCharset;
    }

    @Override
    public void run() {
        try {
            if (this.fOut == null) {
                int vChar;
                while ((vChar = this.fIn.read()) >= 0) {
                    Thread.yield();
                }
            } else {
                int vChar;
                InputStreamReader r;
                InputStreamReader inputStreamReader = r = this.fCharset != null ? new InputStreamReader(this.fIn, this.fCharset) : new InputStreamReader(this.fIn);
                while ((vChar = r.read()) >= 0) {
                    this.fOut.append((char)vChar);
                    Thread.yield();
                }
            }
        }
        catch (Exception e) {
            LogMgr.publishException(e);
        }
    }
}

