/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.uimoz.services;

import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.bdp.item.fs.WspHandler;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.user.IUser;
import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.xerces.serialize.OutputFormat;
import com.scenari.xerces.serialize.Serializer;
import com.scenari.xerces.serialize.SerializerFactory;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import eu.scenari.uimoz.SenderHttpResponseBase;
import eu.scenari.wsp.provider.IWspDefinition;
import eu.scenari.wsp.provider.IWspProvider;
import eu.scenari.wsp.repos.IRepository;
import eu.scenari.wsp.repos.IWspHandler;
import eu.scenari.wsp.service.adminwsp.SvcAdminWspDialog;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SvcAdminWspSender
extends SenderHttpResponseBase {
    public static boolean sAllowAsynchWspLoading = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSendDialogResult(IHDialog pDialog, HttpServletRequest pReq, HttpServletResponse pResp) throws Exception {
        SvcAdminWspDialog vDialog = (SvcAdminWspDialog)pDialog;
        SvcAdminWspSender.hSetContentType(pResp, "text/xml; charset=UTF-8");
        IXmlWriter vWriter = SvcAdminWspSender.hGetXmlWriterUTF8(pResp, true);
        try {
            this.treatCdAction(vDialog, pReq, pResp, vWriter);
        }
        catch (Exception e) {
            pResp.setStatus(500);
            LogMgr.publishException(e);
        }
        finally {
            vWriter.close();
        }
    }

    protected void treatCdAction(SvcAdminWspDialog pDialog, HttpServletRequest pReq, HttpServletResponse pResp, IXmlWriter pWriter) throws Exception {
        String vCdAction = pDialog.hGetCdAction();
        if ("List".equals(vCdAction)) {
            IRepository vRepos = pDialog.getRepository();
            IWspProvider vWspProv = vRepos.getWspProvider();
            boolean vWithWspTypes = "true".equals(pReq.getParameter("withWspTypes"));
            pWriter.writeOpenTag("wspList");
            for (IWspDefinition vWspDef : vWspProv) {
                if (!vWspDef.controlAccess(pDialog.hGetUser(), IWspDefinition.PERM_CONTENT_READ)) continue;
                pWriter.writeStartTag("wsp");
                pWriter.writeAttribute("code", vWspDef.getWspCode());
                if (vWspDef.getWspTitle() != null) {
                    pWriter.writeAttribute("title", vWspDef.getWspTitle());
                }
                if (vWithWspTypes) {
                    WspTypeHandler vHandler = new WspTypeHandler();
                    vWspDef.readWspMeta(vHandler);
                    pWriter.writeAttribute("wspTypes", vHandler.fListWspTypes.toString());
                }
                pWriter.writeEndEmptyTag();
            }
            pWriter.writeCloseTag("wspList");
        } else if ("InfoWspProvider".equals(vCdAction)) {
            IRepository vRepos = pDialog.getRepository();
            pWriter.writeOpenTag("wspProviderInfo");
            Element vWspProvProps = vRepos.getWspProvider().getWspProviderProperties();
            if (vWspProvProps != null) {
                this.serializeElement(vWspProvProps, pWriter);
            }
            pWriter.writeCloseTag("wspProviderInfo");
        } else if ("InfoWsp".equals(vCdAction)) {
            this.writeInfoWsp(pDialog, pWriter);
        } else if ("CreateWsp".equals(vCdAction)) {
            this.writeInfoWsp(pDialog, pWriter);
        } else if ("IsMigrationNeeded".equals(vCdAction)) {
            this.writeIsMigrationNeeded(pDialog, pWriter);
        } else if ("UpdateWspType".equals(vCdAction)) {
            this.writeInfoWsp(pDialog, pWriter);
        } else if ("MigrateUpdateWspType".equals(vCdAction)) {
            this.writeInfoWsp(pDialog, pWriter);
        } else if ("ActivateModeLoadAllItems".equals(vCdAction) || "DectivateModeLoadAllItems".equals(vCdAction) || "StatusLoadedAllItems".equals(vCdAction)) {
            this.writeStatusAllItemsLoaded(pDialog, pWriter);
        } else if (pDialog.getMessageException() != null) {
            pResp.setStatus(500);
            pWriter.writeEmptyTag("error");
            LogMgr.publishMessage(pDialog.getMessageException());
        } else {
            pResp.setStatus(200);
            pWriter.writeEmptyTag("ok");
        }
    }

    protected void writeIsMigrationNeeded(SvcAdminWspDialog pDialog, IXmlWriter pWriter) throws Exception {
        IWspHandler.IWspTypeUpdater vUpdater = pDialog.getUpdater();
        if (vUpdater.isMigrationNeeeded()) {
            ILogMsg vMsg = vUpdater.getPreconditionsForMigration();
            if (vMsg != null) {
                pWriter.writeOpenTag("migrationNeeded");
                vMsg.writeAsXmlFormat(pWriter, false);
                pWriter.writeCloseTag("migrationNeeded");
            } else {
                pWriter.writeEmptyTag("migrationNeeded");
            }
        } else {
            pWriter.writeEmptyTag("noMigrationNeeded");
        }
    }

    protected void writeInfoWsp(SvcAdminWspDialog pDialog, IXmlWriter pWriter) throws Exception {
        try {
            Element vWspProvProps;
            Element vWspProps;
            IRepository vRepos = pDialog.getRepository();
            final WspHandler vWspHandler = (WspHandler)pDialog.getWspHanler();
            IWspProvider vWspProv = vRepos != null ? vRepos.getWspProvider() : null;
            IWspDefinition vWspDef = pDialog.getWspDefinition();
            IUser vUser = pDialog.hGetUser();
            if (vRepos == null || vWspDef == null) {
                pWriter.writeStartTag("infoWsp");
                pWriter.writeAttribute("code", pDialog.hGetParam());
                if (vRepos == null) {
                    pWriter.writeAttribute("status", "noRepository");
                    pWriter.writeEndEmptyTag();
                } else {
                    pWriter.writeAttribute("status", "noWsp");
                    pWriter.writeEndEmptyTag();
                }
                return;
            }
            boolean vRightRead = vWspDef.controlAccess(vUser, IWspDefinition.PERM_CONTENT_READ);
            boolean vRightWrite = vWspDef.controlAccess(vUser, IWspDefinition.PERM_CONTENT_WRITE);
            boolean vAdminWsp = vWspDef.controlAccess(vUser, IWspDefinition.PERM_ADMIN_PARAMS);
            boolean vAdminUsers = vWspDef.controlAccess(vUser, IWspDefinition.PERM_ADMIN_USERS);
            boolean vUpdateWspType = vWspDef.controlAccess(vUser, IWspDefinition.PERM_UPDATE_WSP_TYPE);
            boolean vAdminListWsp = vWspProv.controlAccess(vUser, IWspProvider.PERM_WSP_CREATE);
            if (!vRightRead) {
                pWriter.writeStartTag("infoWsp");
                pWriter.writeAttribute("code", vWspDef.getWspCode());
                if (vWspDef.getWspTitle() != null) {
                    pWriter.writeAttribute("title", vWspDef.getWspTitle());
                }
                pWriter.writeAttribute("status", "noAccess");
                pWriter.writeEndEmptyTag();
                return;
            }
            int vStatus = vWspHandler.getStatus();
            if (vStatus == 0) {
                if (sAllowAsynchWspLoading) {
                    new Thread(){
                        IWspHandler fWsp;
                        {
                            this.fWsp = vWspHandler;
                        }

                        public void run() {
                            this.fWsp.getWsp();
                        }
                    }.start();
                    vStatus = 1;
                } else {
                    vWspHandler.getWsp();
                    vStatus = vWspHandler.getStatus();
                }
            }
            if (vStatus == -1) {
                Element vWspProvProps2;
                pWriter.writeStartTag("infoWsp");
                pWriter.writeAttribute("code", vWspDef.getWspCode());
                if (vWspDef.getWspTitle() != null) {
                    pWriter.writeAttribute("title", vWspDef.getWspTitle());
                }
                pWriter.writeAttribute("status", "failed");
                pWriter.writeAttribute("isMigrationNeeded", Boolean.toString(vWspHandler.isMigrationNeeded()));
                if (vAdminWsp) {
                    if (!vRepos.isServerMode()) {
                        pWriter.writeAttribute("content", SrcFeatureAlternateUrl.getFilePath(vWspDef.getSrcRootContent()));
                        pWriter.writeAttribute("gen", SrcFeatureAlternateUrl.getFilePath(vWspDef.getSrcRootGen()));
                    }
                } else {
                    pWriter.writeAttribute("adminWsp", "false");
                }
                if (!vRightWrite) {
                    pWriter.writeAttribute("writeWsp", "false");
                }
                if (!vAdminUsers) {
                    pWriter.writeAttribute("adminUsers", "false");
                }
                if (!vUpdateWspType) {
                    pWriter.writeAttribute("updateWspType", "false");
                }
                if (vWspHandler.getWspType() == null) {
                    pWriter.writeAttribute("error", "Les sp\u00e9cifications de l'atelier n'ont pu \u00eatre charg\u00e9es.");
                    pWriter.writeEndOpenTag();
                } else {
                    if (vWspHandler.getExceptionOnLoad() != null) {
                        pWriter.writeAttribute("error", vWspHandler.getExceptionOnLoad().getMessage());
                    }
                    pWriter.writeEndOpenTag();
                    vWspHandler.getWspType().writeXml(pWriter);
                    this.writeDownloads(vWspHandler.getListDownloads(), pWriter);
                }
                Element vWspProps2 = vWspDef.getWspProperties();
                if (vWspProps2 != null) {
                    this.serializeElement(vWspProps2, pWriter);
                }
                if ((vWspProvProps2 = vWspDef.getWspProvider().getWspProviderProperties()) != null) {
                    this.serializeElement(vWspProvProps2, pWriter);
                }
                pWriter.writeCloseTag("infoWsp");
                return;
            }
            pWriter.writeStartTag("infoWsp");
            pWriter.writeAttribute("code", vWspDef.getWspCode());
            if (vWspDef.getWspTitle() != null) {
                pWriter.writeAttribute("title", vWspDef.getWspTitle());
            }
            pWriter.writeAttribute("isMigrationNeeded", Boolean.toString(vWspHandler.isMigrationNeeded()));
            if (!vAdminListWsp) {
                pWriter.writeAttribute("admin", "false");
            }
            if (vAdminWsp) {
                if (!vRepos.isServerMode()) {
                    pWriter.writeAttribute("content", SrcFeatureAlternateUrl.getFilePath(vWspDef.getSrcRootContent()));
                    pWriter.writeAttribute("gen", SrcFeatureAlternateUrl.getFilePath(vWspDef.getSrcRootGen()));
                }
            } else {
                pWriter.writeAttribute("adminWsp", "false");
            }
            if (!vRightWrite) {
                pWriter.writeAttribute("writeWsp", "false");
            }
            if (!vAdminUsers) {
                pWriter.writeAttribute("adminUsers", "false");
            }
            if (!vUpdateWspType) {
                pWriter.writeAttribute("updateWspType", "false");
            }
            if (vStatus == 1) {
                pWriter.writeAttribute("status", "init");
                pWriter.writeEndEmptyTag();
                return;
            }
            if (vStatus == 4) {
                pWriter.writeAttribute("status", "migrating");
                pWriter.writeEndEmptyTag();
                return;
            }
            if (vStatus == 2) {
                pWriter.writeAttribute("status", "downloadRes");
            } else if (vStatus == 3) {
                pWriter.writeAttribute("status", "ok");
                int vAllItemsLoaded = vWspHandler.getWsp().hGetStatusItemLoaded();
                if (vAllItemsLoaded == HWorkspaceFs.STATUS_ALL_ITEM_LOADED_NO) {
                    pWriter.writeAttribute("statusLoadedAllItems", "no");
                } else if (vAllItemsLoaded == HWorkspaceFs.STATUS_ALL_ITEM_LOADED_WORKING) {
                    pWriter.writeAttribute("statusLoadedAllItems", "working");
                } else {
                    pWriter.writeAttribute("statusLoadedAllItems", "ok");
                }
            } else {
                pWriter.writeAttribute("status", "unknown");
            }
            pWriter.writeEndOpenTag();
            if (vWspHandler.getWspType() != null) {
                vWspHandler.getWspType().writeXml(pWriter);
                this.writeDownloads(vWspHandler.getListDownloads(), pWriter);
            }
            if ((vWspProps = vWspDef.getWspProperties()) != null) {
                this.serializeElement(vWspProps, pWriter);
            }
            if ((vWspProvProps = vWspDef.getWspProvider().getWspProviderProperties()) != null) {
                this.serializeElement(vWspProvProps, pWriter);
            }
            pWriter.writeCloseTag("infoWsp");
        }
        catch (Throwable e) {
            LogMgr.publishException(e);
        }
    }

    protected void serializeElement(Element pElement, IXmlWriter pWriter) throws IOException, Exception {
        OutputFormat vFormat = new OutputFormat("xml", "UTF-8", false);
        vFormat.setOmitXMLDeclaration(true);
        Serializer vSer = SerializerFactory.getSerializerFactory("xml").makeSerializer(vFormat);
        StringWriter vStringWriter = new StringWriter();
        vSer.setOutputCharStream(vStringWriter);
        vSer.asDOMSerializer().serialize(pElement);
        pWriter.writeXmlFragment(vStringWriter.getBuffer());
    }

    protected void writeDownloads(List pListDownloads, IXmlWriter pWriter) throws Exception {
        if (pListDownloads != null) {
            throw new Exception("TODO write downloads...");
        }
    }

    protected void writeStatusAllItemsLoaded(SvcAdminWspDialog pDialog, IXmlWriter pWriter) throws Exception {
        pWriter.writeStartTag("allItemsLoaded");
        IWspHandler vWsp = pDialog.getWspHanler();
        int vStatus = ((HWorkspaceFs)vWsp.getWsp()).hGetStatusItemLoaded();
        if (vStatus == HWorkspaceFs.STATUS_ALL_ITEM_LOADED_NO) {
            pWriter.writeAttribute("status", "no");
        } else if (vStatus == HWorkspaceFs.STATUS_ALL_ITEM_LOADED_WORKING) {
            pWriter.writeAttribute("status", "working");
        } else if (vStatus == HWorkspaceFs.STATUS_ALL_ITEM_LOADED_OK) {
            pWriter.writeAttribute("status", "ok");
        }
        pWriter.writeEndEmptyTag();
    }

    protected class WspTypeHandler
    extends FragmentSaxHandlerBase {
        protected StringBuilder fListWspTypes = new StringBuilder();

        protected WspTypeHandler() {
        }

        protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
            if (pLocalName == "wspType") {
                this.fListWspTypes.append(pAttributes.getValue("key"));
                this.fListWspTypes.append(" ");
            } else if (pLocalName == "wspOption") {
                this.fListWspTypes.append(pAttributes.getValue("key"));
                this.fListWspTypes.append(" ");
            }
            return true;
        }
    }
}

