/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.uimoz.services;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.fields.FieldsCollectorBuilder;
import com.scenari.src.feature.fields.IFieldsCollector;
import com.scenari.src.feature.fields.SrcFeatureFields;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.syntax.json.JsonSerializer;
import eu.scenari.uimoz.SenderHttpResponseBase;
import eu.scenari.wsp.service.history.SvcHistoryDialog;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SvcHistorySender
extends SenderHttpResponseBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSendDialogResult(IHDialog pDialog, HttpServletRequest pReq, HttpServletResponse pResp) throws Exception {
        SvcHistoryDialog vDialog = (SvcHistoryDialog)pDialog;
        if (vDialog.getError() != null) {
            this.sendError(vDialog, pReq, pResp);
            return;
        }
        ISrcNode vSrcLive = vDialog.getSrcNodeLive();
        List<ISrcNode> vSrcTrashed = vDialog.getSrcNodes();
        if (vSrcLive == null || vSrcTrashed == null) {
            this.sendError(vDialog, pReq, pResp);
            return;
        }
        SvcHistorySender.hSetContentType(pResp, "text/plain; charset=UTF-8");
        Writer vWriter = SvcHistorySender.hGetWriterUTF8(pResp);
        JsonSerializer vJsonWriter = new JsonSerializer(vWriter);
        try {
            String vFieldKeys = pReq.getParameter("fields");
            IFieldsCollector vFields = FieldsCollectorBuilder.newFieldsCollector(vFieldKeys);
            vJsonWriter.startObject();
            vJsonWriter.key("liveNode");
            vFields.resetDatas();
            SrcFeatureFields.fillFields(vSrcLive, vFields);
            this.fillFields(vFields, vJsonWriter);
            if (vDialog.hGetCdAction().equals("RestoreFromTrash")) {
                ISrcNode vSrcRestored = vDialog.getSrcNodeRestored();
                vJsonWriter.key("restoredNode");
                if (vSrcRestored != null) {
                    vFields.resetDatas();
                    SrcFeatureFields.fillFields(vSrcRestored, vFields);
                    this.fillFields(vFields, vJsonWriter);
                } else {
                    vJsonWriter.valNull();
                }
            }
            vJsonWriter.key("trashNodes");
            vJsonWriter.startArray();
            for (int i = 0; i < vSrcTrashed.size(); ++i) {
                ISrcNode vSrcNode = vSrcTrashed.get(i);
                vFields.resetDatas();
                SrcFeatureFields.fillFields(vSrcNode, vFields);
                this.fillFields(vFields, vJsonWriter);
            }
            vJsonWriter.endArray();
            vJsonWriter.endObject();
        }
        finally {
            vWriter.close();
        }
    }

    protected void fillFields(IFieldsCollector pFields, JsonSerializer pJsonWriter) throws Exception {
        pJsonWriter.startObject();
        pFields.startIterate();
        String vKey = pFields.nextDataKey();
        while (vKey != null) {
            Object vValue = pFields.getData(vKey);
            if (vValue != null) {
                pJsonWriter.key(vKey);
                pJsonWriter.val(vValue);
            }
            vKey = pFields.nextDataKey();
        }
        pJsonWriter.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(SvcHistoryDialog pDialog, HttpServletRequest pReq, HttpServletResponse pResp) throws Exception {
        pResp.setStatus(500);
        if (pDialog.getError() != null) {
            LogMgr.publishMessage(pDialog.getError());
            IXmlWriter vXmlWriter = SvcHistorySender.hGetXmlWriterUTF8(pResp, true);
            try {
                pDialog.getError().writeAsXmlFormat(vXmlWriter, true);
            }
            finally {
                vXmlWriter.close();
            }
        }
    }
}

