/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.uimoz.services;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.src.search.ISearchRequest;
import com.scenari.src.search.ISearchResultRow;
import eu.scenari.fw.syntax.json.JsonSerializer;
import eu.scenari.uimoz.SenderHttpResponseBase;
import eu.scenari.wsp.service.search.SvcSearchDialog;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvcSearchSender
extends SenderHttpResponseBase {
    public static final String PARAM_FORMAT = "format";
    public static final String FORMAT_JSONARRAYURIS = "jsonArrayUris";
    public static final String FORMAT_JSONARRAYCOLUMNS = "jsonArrayColumns";
    public static final String FORMAT_COUNT = "count";

    @Override
    public void xSendDialogResult(IHDialog pDialog, HttpServletRequest pReq, HttpServletResponse pResp) throws Exception {
        SvcSearchDialog vDialog = (SvcSearchDialog)pDialog;
        String vCdAction = pDialog.hGetCdAction();
        if ("Search".equals(vCdAction)) {
            SvcSearchSender.hSetContentType(pResp, "text/plain; charset=UTF-8");
            Iterator<ISearchResultRow> vResults = vDialog.getResults();
            String vFormat = pReq.getParameter(PARAM_FORMAT);
            if (vFormat == null || vFormat.length() == 0) {
                String string = vFormat = vDialog.getRequest().getResultType() == ISearchRequest.ResultType.count ? FORMAT_COUNT : FORMAT_JSONARRAYCOLUMNS;
            }
            if (vFormat.equals(FORMAT_JSONARRAYURIS)) {
                this.builJsonArrayUri(pResp, vResults);
            } else if (vFormat.equals(FORMAT_JSONARRAYCOLUMNS)) {
                this.builJsonArrayColumns(pResp, vResults, vDialog);
            } else if (vFormat.equals(FORMAT_COUNT)) {
                this.builCount(pResp, vResults);
            } else {
                throw new Exception("Format unknown : " + vFormat);
            }
        }
    }

    protected void builJsonArrayUri(HttpServletResponse pResp, Iterator<ISearchResultRow> vResults) throws Exception {
        JsonSerializer vJson = new JsonSerializer(SvcSearchSender.hGetWriterUTF8(pResp));
        vJson.startObject();
        vJson.key("results");
        vJson.startArray();
        while (vResults.hasNext()) {
            ISearchResultRow vRow = vResults.next();
            vJson.valString(vRow.getRowUri());
        }
        vJson.endArray();
        vJson.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void builJsonArrayColumns(HttpServletResponse pResp, Iterator<ISearchResultRow> vResults, SvcSearchDialog pDialog) throws Exception {
        List<String> vColumns = pDialog.getRequest().getColumnNames();
        int vCountCol = vColumns.size();
        OutputStreamWriter vWriter = new OutputStreamWriter((OutputStream)pResp.getOutputStream(), "UTF-8");
        try {
            JsonSerializer vJson = new JsonSerializer(vWriter);
            vJson.startObject();
            vJson.key("columns");
            vJson.startArray();
            for (String vString : vColumns) {
                vJson.valString(vString);
            }
            vJson.endArray();
            vJson.key("results");
            vJson.startArray();
            while (vResults.hasNext()) {
                ISearchResultRow vRow = vResults.next();
                vJson.startArray();
                for (int i = 0; i < vCountCol; ++i) {
                    vJson.val(vRow.getColumnValue(i));
                }
                vJson.endArray();
            }
            vJson.endArray();
            vJson.endObject();
        }
        finally {
            ((Writer)vWriter).close();
        }
    }

    protected void builCount(HttpServletResponse pResp, Iterator<ISearchResultRow> vResults) throws Exception {
        ISearchResultRow vRow = vResults.next();
        Object vResult = vRow.getColumnValue("#count");
        pResp.getOutputStream().write(vResult.toString().getBytes());
    }
}

