/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.uimoz.services;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.dialog.webdav.WResultatGet;
import com.scenari.s.co.transform.HTransformParams;
import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.fields.FieldsCollectorBuilder;
import com.scenari.src.feature.fields.IFieldsCollector;
import com.scenari.src.feature.fields.SrcFeatureFields;
import com.scenari.src.feature.streams.SrcFeatureStreams;
import com.scenari.src.feature.transform.SrcFeatureTransform;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.mime.MimeMgr;
import eu.scenari.fw.stream.bytes.IBlob;
import eu.scenari.fw.syntax.json.JsonSerializer;
import eu.scenari.uimoz.SenderHttpResponseBase;
import eu.scenari.wsp.service.wspsrc.SvcWspSrcDialog;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SvcWspSrcSender
extends SenderHttpResponseBase {
    public static String sDefaultFieldKeys = "basis*item";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xSendDialogResult(IHDialog pDialog, HttpServletRequest pReq, HttpServletResponse pResp) throws Exception {
        SvcWspSrcDialog vDialog = (SvcWspSrcDialog)pDialog;
        String vCdAction = vDialog.hGetCdAction();
        if (vCdAction.equals("GetSrc")) {
            ISrcNode vSrcNode = vDialog.getSrcNode();
            String vFormat = pReq.getParameter("format");
            if (vFormat == null || vFormat.equals("JSON")) {
                SvcWspSrcSender.hSetContentType(pResp, "text/plain; charset=UTF-8");
                Writer vWriter = SvcWspSrcSender.hGetWriterUTF8(pResp);
                JsonSerializer vJsonWriter = new JsonSerializer(vWriter);
                try {
                    String vFieldKeys = pReq.getParameter("fields");
                    if (vFieldKeys == null) {
                        vFieldKeys = sDefaultFieldKeys;
                    }
                    IFieldsCollector vFields = FieldsCollectorBuilder.newFieldsCollector(vFieldKeys);
                    if (vSrcNode == null) {
                        List<ISrcNode> vSrcNodes = vDialog.getSrcNodes();
                        if (vSrcNodes == null) {
                            this.sendError(vDialog, pReq, pResp);
                            return;
                        }
                        List<String> vRefUris = vDialog.getParamRefUris();
                        vJsonWriter.startArray();
                        for (int i = 0; i < vRefUris.size(); ++i) {
                            vSrcNode = vSrcNodes.get(i);
                            if (vSrcNode != null) {
                                vFields.resetDatas();
                                SrcFeatureFields.fillFields(vSrcNode, vFields);
                                this.fillFields(vFields, vJsonWriter);
                                continue;
                            }
                            vJsonWriter.valNull();
                        }
                        vJsonWriter.endArray();
                    }
                    SrcFeatureFields.fillFields(vSrcNode, vFields);
                    this.fillFields(vFields, vJsonWriter);
                }
                finally {
                    vWriter.close();
                }
            } else if (vFormat.equals("stream") || vFormat.equals("download")) {
                String vContentType;
                IBlob vBlob;
                if (vSrcNode == null) {
                    this.sendError(vDialog, pReq, pResp);
                    return;
                }
                String vTransform = pReq.getParameter("transform");
                if (vTransform != null) {
                    HTransformParams vParams = HTransformParams.hNewParamsTransformByQueryString(vTransform, "UTF-8");
                    vBlob = SrcFeatureTransform.transformContent(vSrcNode, vParams).transformAsBlob();
                    vContentType = vBlob.getContentType();
                } else {
                    vBlob = SrcFeatureStreams.wrapSrcAsBlob(vSrcNode);
                    vContentType = vBlob.getContentType();
                    if (vContentType == null) {
                        vContentType = MimeMgr.getDefaultMimeMgr().searchMimeFromUrl(vSrcNode.getSrcUri());
                    }
                }
                WResultatGet vResult = new WResultatGet();
                vResult.hSetStream(vBlob);
                vResult.hSetContentType(vContentType);
                vResult.hSetLength(vBlob.getLength());
                vResult.hSetLastModifDate(vSrcNode.getLastModifWithChildren());
                if (vFormat.equals("download")) {
                    int vLastPoint;
                    String vExt;
                    String vName = vSrcNode.getSrcName();
                    if (vTransform != null && vBlob.getContentType() != null && (vExt = MimeMgr.getDefaultMimeMgr().searchExtFromContentType(vBlob.getContentType())) != null && (vLastPoint = vName.lastIndexOf(46)) > 0) {
                        vName = vName.substring(0, vLastPoint + 1).concat(vExt);
                    }
                    vResult.hSetDownloadNameFile(vName);
                }
                vResult.sendDialogResult(vDialog, pReq, pResp);
            } else if (vFormat.equals("filePath")) {
                if (vSrcNode == null) {
                    this.sendError(vDialog, pReq, pResp);
                    return;
                }
                if (vDialog.getWorkspace().hGetRepository().isServerMode()) {
                    pResp.setStatus(403);
                } else {
                    String vFilePath = SrcFeatureAlternateUrl.getFilePath(vSrcNode);
                    if (vFilePath == null) {
                        pResp.setStatus(404);
                    } else {
                        SvcWspSrcSender.hSetContentType(pResp, "text/plain; charset=UTF-8");
                        Writer vWriter = SvcWspSrcSender.hGetWriterUTF8(pResp);
                        try {
                            vWriter.write(vFilePath);
                        }
                        finally {
                            vWriter.close();
                        }
                    }
                }
            } else {
                LogMgr.publishException("Format unknown : " + vFormat, ILogMsg.LogType.Warning, new String[0]);
                this.sendError(vDialog, pReq, pResp);
            }
        } else if (vCdAction.equals("PutSrc")) {
            if (vDialog.getError() != null) {
                this.sendError(vDialog, pReq, pResp);
            } else {
                pResp.setContentType("text/plain");
                pResp.setContentLength(0);
            }
        }
    }

    protected void fillFields(IFieldsCollector pFields, JsonSerializer pJsonWriter) throws Exception {
        pJsonWriter.startObject();
        pFields.startIterate();
        String vKey = pFields.nextDataKey();
        while (vKey != null) {
            Object vValue = pFields.getData(vKey);
            if (vValue != null) {
                pJsonWriter.key(vKey);
                pJsonWriter.val(vValue);
            }
            vKey = pFields.nextDataKey();
        }
        pJsonWriter.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(SvcWspSrcDialog pDialog, HttpServletRequest pReq, HttpServletResponse pResp) throws Exception {
        pResp.setStatus(500);
        if (pDialog.getError() != null) {
            LogMgr.publishMessage(pDialog.getError());
            IXmlWriter vXmlWriter = SvcWspSrcSender.hGetXmlWriterUTF8(pResp, true);
            try {
                pDialog.getError().writeAsXmlFormat(vXmlWriter, true);
            }
            finally {
                vXmlWriter.close();
            }
        }
    }
}

