/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.universe.execframe.httpservlet;

import com.scenari.m.co.agent.IWADialog;
import com.scenari.m.co.agent.IWAgent;
import com.scenari.m.co.service.IWService;
import com.scenari.m.co.univers.IWUnivers;
import eu.scenari.fw.pools.PoolBuffers;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import eu.scenari.universe.execframe.ExecFrameBase;
import eu.scenari.universe.execframe.httpservlet.IAuthConnector;
import eu.scenari.universe.execframe.httpservlet.IExecFrameHttpServlet;
import eu.scenari.universe.execframe.httpservlet.IHttpRequestConnector;
import java.util.List;

public class ExecFrameHttpServlet
extends ExecFrameBase
implements IExecFrameHttpServlet {
    protected String fDomainUrl = null;
    protected String fWebAppPath = null;
    protected String fServletAgentPath = null;
    protected String fServletServicePath = null;
    protected IHttpRequestConnector fHttpRequestConnector = null;
    protected IAuthConnector fAuthConnector = null;

    public ExecFrameHttpServlet(IWUnivers pUniverse, String pCode) {
        super(pUniverse, pCode == null ? "UiMoz" : pCode);
    }

    public String buildUrlAgent(IWAgent pAgent, IWADialog pDialog) throws Exception {
        StringBuilder vBuf = PoolBuffers.popStringBuilder();
        List vHier = pDialog.hGetHier();
        vBuf.append(this.fDomainUrl);
        vBuf.append(this.fWebAppPath);
        vBuf.append(this.fServletAgentPath);
        vBuf.append('/');
        vBuf.append(this.fUniverse.hGetCode());
        vBuf.append('/');
        vBuf.append(pAgent.hGetInstance().hGetID());
        for (int i = 0; i < vHier.size(); ++i) {
            vBuf.append('/');
            vBuf.append(((IWAgent)vHier.get(i)).hGetAgentPath());
        }
        vBuf.append('/');
        vBuf.append(pAgent.hGetAgentPath());
        return PoolBuffers.getStringAndFreeStringBuilder(vBuf);
    }

    public String buildUrlService(IWService pService) throws Exception {
        StringBuilder vBuf = PoolBuffers.popStringBuilder();
        vBuf.append(this.fDomainUrl);
        vBuf.append(this.fWebAppPath);
        vBuf.append(this.fServletServicePath);
        vBuf.append('/');
        vBuf.append(pService.hGetUnivers().hGetCode());
        vBuf.append(pService.hGetUrn());
        return PoolBuffers.getStringAndFreeStringBuilder(vBuf);
    }

    public IHttpRequestConnector getHttpRequestConnector() {
        return this.fHttpRequestConnector;
    }

    public IAuthConnector getAuthConnector() {
        return this.fAuthConnector;
    }

    public FragmentSaxHandlerBase injectParams() {
        return this.fHttpRequestConnector.injectParams();
    }

    public String getDomainUrl() {
        return this.fDomainUrl;
    }

    public String getServletAgentPath() {
        return this.fServletAgentPath;
    }

    public String getServletServicePath() {
        return this.fServletServicePath;
    }

    public String getWebAppPath() {
        return this.fWebAppPath;
    }

    public void setAuthConnector(IAuthConnector pAuthConnector) {
        this.fAuthConnector = pAuthConnector;
    }

    public void setHttpRequestConnector(IHttpRequestConnector pHttpRequestConnector) {
        this.fHttpRequestConnector = pHttpRequestConnector;
    }

    public void setDomainUrl(String newUrlDomaine) {
        this.fDomainUrl = newUrlDomaine;
    }

    public void setServletAgentPath(String newUrlServletAgent) {
        this.fServletAgentPath = newUrlServletAgent;
    }

    public void setServletServicePath(String newUrlServletService) {
        this.fServletServicePath = newUrlServletService;
    }

    public void setWebAppPath(String newUrlWebApp) {
        this.fWebAppPath = newUrlWebApp;
    }
}

