/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.universe.execframe.httpservlet.auth;

import com.scenari.m.co.user.IUser;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.universe.execframe.httpservlet.IAuthConnector;
import eu.scenari.universe.execframe.httpservlet.IExecFrameHttpServlet;
import eu.scenari.universe.execframe.httpservlet.auth.Base64Decoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthConnectorBasic
implements IAuthConnector {
    protected String fRealm = "Basic realm=\"SCENARI\"";

    public IUser openAuthenticatedSession(HttpServletRequest pRequest, HttpServletResponse pResponse, IExecFrameHttpServlet pExecFrame) throws Exception {
        int vOffs;
        String vAuthString;
        int vIdx;
        boolean vIsScAuth = false;
        String vNamePass = null;
        String vCookie = null;
        if (vCookie != null && (vIdx = vCookie.indexOf("scAuth=")) >= 0) {
            vIsScAuth = true;
            int vEnd = vCookie.indexOf(59, vIdx += "scAuth=".length());
            vNamePass = vEnd > 0 ? vCookie.substring(vIdx, vEnd) : vCookie.substring(vIdx);
            vNamePass = Base64Decoder.decode(vNamePass);
        }
        if (vNamePass == null && (vAuthString = pRequest.getHeader("Authorization")) != null && vAuthString.length() > 6) {
            vNamePass = Base64Decoder.decode(vAuthString.substring(6).trim());
        }
        if (vNamePass != null && (vOffs = vNamePass.indexOf(58)) > 0) {
            int vHostIdx;
            String vAccount = vNamePass.substring(0, vOffs);
            String vPassword = vNamePass.substring(vOffs + 1);
            String vUserAgent = pRequest.getHeader("user-agent");
            if (vUserAgent != null && vUserAgent.indexOf("microsoft-webdav-miniredir") >= 0 && (vHostIdx = vAccount.lastIndexOf("\\")) >= 0) {
                vAccount = vAccount.substring(vHostIdx + 1);
            }
            try {
                IUser vUser = pExecFrame.getUniverse().getUser(vAccount);
                if (vUser != null && vUser.checkPassword(vPassword)) {
                    return vUser;
                }
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
        if (vIsScAuth) {
            pResponse.setStatus(451);
        } else {
            pResponse.setStatus(401);
            pResponse.setHeader("WWW-Authenticate", this.fRealm);
        }
        return null;
    }

    public void closeAuthenticatedSession(IUser pUser, HttpServletRequest pRequest, HttpServletResponse pResponse, IExecFrameHttpServlet pExecFrame) throws Exception {
    }

    public void setRealm(String pRealm) {
        this.fRealm = "Basic realm=\"" + pRealm + "\"";
    }
}

