/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.universe.execframe.httpservlet.servlets;

import com.scenari.m.co.univers.HUniversMgr;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.m.co.user.IUser;
import com.scenari.m.co.user.ThreadUser;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.main.ServletBase;
import eu.scenari.universe.execframe.ThreadExecFrame;
import eu.scenari.universe.execframe.httpservlet.IAuthConnector;
import eu.scenari.universe.execframe.httpservlet.IExecFrameHttpServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractServlet
extends ServletBase {
    protected String fExecFrameCode = "UiMoz";
    protected String fEncodingUrl = "utf-8";

    protected IUser xOpenAuthSession(HttpServletRequest pRequest, HttpServletResponse pResponse, IExecFrameHttpServlet pExecFrame) throws Exception {
        IAuthConnector vAuthConnector = pExecFrame.getAuthConnector();
        IUser vUser = vAuthConnector == null ? pExecFrame.getUniverse().getUser("anonymous") : vAuthConnector.openAuthenticatedSession(pRequest, pResponse, pExecFrame);
        ThreadUser.setUser(vUser);
        return vUser;
    }

    protected void xCloseAuthSession(IUser pUser, HttpServletRequest pRequest, HttpServletResponse pResponse, IExecFrameHttpServlet pExecFrame) throws Exception {
        IAuthConnector vAuthConnector = pExecFrame.getAuthConnector();
        if (vAuthConnector != null) {
            vAuthConnector.closeAuthenticatedSession(pUser, pRequest, pResponse, pExecFrame);
        }
        ThreadUser.setUser(null);
    }

    protected IWUnivers xLookForUniverse(String pUniverseCode) throws Exception {
        IWUnivers vUniverse = HUniversMgr.hGetUnivers(pUniverseCode);
        if (vUniverse == null) {
            throw LogMgr.newException("Universe '%s' not found.", this.fExecFrameCode, pUniverseCode);
        }
        return vUniverse;
    }

    protected IExecFrameHttpServlet xLookForExecFrame(IWUnivers pUniverse) throws Exception {
        IExecFrameHttpServlet vExecFrame = (IExecFrameHttpServlet)pUniverse.getExecFrame(this.fExecFrameCode);
        if (vExecFrame == null) {
            throw LogMgr.newException("ExecFrame '%s' not found in '%s' universe.", this.fExecFrameCode, pUniverse.hGetCode());
        }
        ThreadExecFrame.setExecFrame(vExecFrame);
        return vExecFrame;
    }

    public void init(ServletConfig pConfig) throws ServletException {
        super.init(pConfig);
        String vExecFrameCode = pConfig.getInitParameter("ExecFrameCode");
        if (vExecFrameCode != null) {
            this.fExecFrameCode = vExecFrameCode;
        }
    }
}

