/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.pack.impl;

import eu.scenari.fw.initapp.ScFramework;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.fw.syntax.json.JsonSerializer;
import eu.scenari.wsp.pack.IPack;
import eu.scenari.wsp.pack.IWspTypeDef;
import eu.scenari.wsp.pack.impl.PackMgr;
import eu.scenari.wsp.res.IRes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pack
implements IPack {
    protected PackMgr fPackMgr;
    protected String fId;
    protected IPack.InstallStatus fInstallStatus;
    protected IPack.ErrorPack fError = IPack.ErrorPack.noError;
    protected long fInstallDate = -1L;
    protected String fTitlePack = null;
    protected List<IRes> fResList = new ArrayList<IRes>(12);
    protected IdentityHashMap<IRes, String> fSourceUrlRes = new IdentityHashMap(12);
    protected List<IWspTypeDef> fWspTypeDefList = new ArrayList<IWspTypeDef>(3);
    protected ScVersion fFrameworkOptimalVersion;
    protected ScVersion fFrameworkMinVersion;
    protected ScVersion fFrameworkMaxVersion;

    public Pack(String pId, PackMgr pPackMgr, IPack.InstallStatus pInitialInstallStatus) {
        this.fId = pId;
        this.fPackMgr = pPackMgr;
        this.fInstallStatus = pInitialInstallStatus;
    }

    @Override
    public String getIdPack() {
        return this.fId;
    }

    @Override
    public IPack.InstallStatus getInstallStatus() {
        return this.fInstallStatus;
    }

    @Override
    public IPack.ErrorPack getError() {
        return this.fError;
    }

    @Override
    public long getInstallDate() {
        return this.fInstallDate;
    }

    @Override
    public String getTitlePack() {
        return this.fTitlePack;
    }

    @Override
    public boolean isSystemPack() {
        return this.fInstallDate == -1L;
    }

    @Override
    public List<IWspTypeDef> listWspTypeDef(List<IWspTypeDef> pList) {
        if (pList == null) {
            return Collections.unmodifiableList(this.fWspTypeDefList);
        }
        pList.addAll(this.fWspTypeDefList);
        return pList;
    }

    @Override
    public List<IRes> listRes(List<IRes> pList) {
        if (pList == null) {
            return Collections.unmodifiableList(this.fResList);
        }
        pList.addAll(this.fResList);
        return pList;
    }

    @Override
    public ScVersion getFrameworkOptimalVersion() {
        return this.fFrameworkOptimalVersion;
    }

    @Override
    public ScVersion getFrameworkMaxVersion() {
        return this.fFrameworkMaxVersion;
    }

    @Override
    public ScVersion getFrameworkMinVersion() {
        return this.fFrameworkMinVersion;
    }

    @Override
    public void writeJson(JsonSerializer pJson) throws Exception {
        pJson.startObject();
        pJson.key("id").valString(this.fId);
        pJson.key("installStatus").valString(this.fInstallStatus.name());
        if (this.fError != IPack.ErrorPack.noError) {
            pJson.key("error").valString(this.fError.name());
        }
        if (this.fInstallStatus != IPack.InstallStatus.installPending) {
            if (this.isSystemPack()) {
                pJson.key("system").valBoolean(true);
            }
            if (this.fInstallDate > 0L) {
                pJson.key("installDate").valNumber(this.fInstallDate);
            }
            pJson.key("title").valString(this.fTitlePack);
            pJson.key("wspTypeDef").startArray();
            for (IWspTypeDef vWspTypeDef : this.fWspTypeDefList) {
                vWspTypeDef.writeJson(pJson);
            }
            pJson.endArray();
            pJson.key("framework").startObject();
            if (this.fFrameworkOptimalVersion != null) {
                pJson.key("optimal").valString(this.fFrameworkOptimalVersion);
            }
            if (this.fFrameworkMaxVersion != null) {
                pJson.key("max").valString(this.fFrameworkMaxVersion);
            }
            if (this.fFrameworkMinVersion != null) {
                pJson.key("min").valString(this.fFrameworkMinVersion);
            }
            pJson.endObject();
        }
        pJson.endObject();
    }

    public void setInstallDate(long pInstallDate) {
        this.fInstallDate = pInstallDate;
    }

    public void setTitlePack(String pTitlePack) {
        this.fTitlePack = pTitlePack;
    }

    public void setInstallStatus(IPack.InstallStatus pInstallStatus) {
        this.fInstallStatus = pInstallStatus;
    }

    public void setError(IPack.ErrorPack pErrorPack) {
        this.fError = pErrorPack;
    }

    public void setErrorIfHigher(IPack.ErrorPack pErrorPack) {
        this.fError = IPack.ErrorPack.getHigherError(this.fError, pErrorPack);
    }

    public void addWspTypeDef(IWspTypeDef pWspTypeDef) {
        this.fWspTypeDefList.add(pWspTypeDef);
    }

    public void addRes(IRes pRes, String pSourceUrl) {
        this.fResList.add(pRes);
        if (pSourceUrl != null) {
            this.fSourceUrlRes.put(pRes, pSourceUrl);
        }
    }

    public void setFrameworkCompat(ScVersion pOptimalVersion, ScVersion pMaxVersion, ScVersion pMinVersion) {
        this.fFrameworkOptimalVersion = pOptimalVersion;
        this.fFrameworkMaxVersion = pMaxVersion;
        this.fFrameworkMinVersion = pMinVersion;
        ScVersion vFramerwork = ScFramework.getFrameworkVersion();
        if (vFramerwork.isUndefined()) {
            return;
        }
        if (!vFramerwork.isContainedIn(this.fFrameworkMaxVersion, this.fFrameworkMinVersion)) {
            this.setErrorIfHigher(IPack.ErrorPack.versionFrameworkMismatch);
        } else if (vFramerwork.compareTo(this.fFrameworkOptimalVersion) < 0) {
            this.setErrorIfHigher(IPack.ErrorPack.versionFrameworkLower);
        }
    }
}

