/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.pack.impl;

import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import eu.scenari.fw.util.xml.IObjectLoader;
import eu.scenari.wsp.pack.IPack;
import eu.scenari.wsp.pack.IPackMgr;
import eu.scenari.wsp.pack.impl.Pack;
import eu.scenari.wsp.pack.impl.WspOptionDef;
import eu.scenari.wsp.pack.impl.WspTypeDef;
import eu.scenari.wsp.res.IRes;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackContentHandler
extends FragmentSaxHandlerBase
implements IObjectLoader<IPack> {
    private static final String PACKDESK_VERSION = "4.0";
    protected Pack fPack;
    protected IPackMgr fPackMgr;
    protected WspOptionDef fCurrentWspOptionDef = null;
    protected List<String> fCurrentRequireOptionsKeys = null;
    protected List<String> fCurrentIncompatibleOptionsKeys = null;
    protected List<String> fCurrentApplyOnOptionsKeys = null;

    public PackContentHandler(IPackMgr pPackMgr, Pack pPack) {
        this.fPack = pPack;
        this.fPackMgr = pPackMgr;
    }

    @Override
    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        if (pLocalName == "packdesc") {
            String vDtdVersion = pAttributes.getValue("version");
            if (vDtdVersion == null || !vDtdVersion.equals(PACKDESK_VERSION)) {
                this.fPack.setErrorIfHigher(IPack.ErrorPack.versionPackUnknown);
            }
            this.fPack.setTitlePack(pAttributes.getValue("title"));
        } else if (pLocalName == "framework") {
            this.fPack.setFrameworkCompat(new ScVersion(pAttributes.getValue("optimal")), new ScVersion(pAttributes.getValue("max")), new ScVersion(pAttributes.getValue("min")));
        } else if (pLocalName != "installRes") {
            if (pLocalName == "res") {
                IObjectLoader<IRes> vResLoader = this.fPackMgr.getUpdtResMgr().createResLoader();
                vResLoader.initSaxHandlerForElement(this.getXMLReader(), pUri, pLocalName, pQName, pAttributes);
                IRes vRes = vResLoader.getLoadedObject();
                if (vRes != null) {
                    this.fPack.addRes(vRes, pAttributes.getValue("url"));
                }
            } else if (pLocalName == "wspTypeDef") {
                WspTypeDef vWspTypeDesc = new WspTypeDef(this.fPack);
                this.fPack.addWspTypeDef(vWspTypeDesc);
                vWspTypeDesc.setKey(pAttributes.getValue("key"));
                vWspTypeDesc.setLang(pAttributes.getValue("lang"));
                vWspTypeDesc.setUri(pAttributes.getValue("uri"));
                vWspTypeDesc.setTitle(pAttributes.getValue("title"));
                vWspTypeDesc.setKeyResWspType(pAttributes.getValue("keyResWspType"));
                vWspTypeDesc.setVersion(new ScVersion(pAttributes.getValue("version")).setZeroToUndefinedNumbers().lock());
            } else if (pLocalName == "wspOptionDef") {
                this.fCurrentWspOptionDef = new WspOptionDef(this.fPack);
                this.fCurrentWspOptionDef.setKey(pAttributes.getValue("key"));
                this.fCurrentWspOptionDef.setLang(pAttributes.getValue("lang"));
                this.fCurrentWspOptionDef.setUri(pAttributes.getValue("uri"));
                this.fCurrentWspOptionDef.setTitle(pAttributes.getValue("title"));
                this.fCurrentWspOptionDef.setKeyResWspType(pAttributes.getValue("keyResWspType"));
                this.fCurrentWspOptionDef.setVersion(new ScVersion(pAttributes.getValue("version")).setZeroToUndefinedNumbers().lock());
                this.fCurrentWspOptionDef.setNature(pAttributes.getValue("nature"));
                this.fCurrentWspOptionDef.setParentKey(pAttributes.getValue("parentKey"));
                this.fCurrentWspOptionDef.setParentLang(pAttributes.getValue("parentLang"));
                this.fCurrentWspOptionDef.setParentMaxVersion(new ScVersion(pAttributes.getValue("parentMaxVersion")).lock());
                this.fCurrentWspOptionDef.setParentMinVersion(new ScVersion(pAttributes.getValue("parentMinVersion")).lock());
            } else if (pLocalName == "requireOption") {
                if (this.fCurrentRequireOptionsKeys == null) {
                    this.fCurrentRequireOptionsKeys = new ArrayList<String>();
                }
                this.fCurrentRequireOptionsKeys.add(pAttributes.getValue("key"));
            } else if (pLocalName == "icompatibleOption") {
                if (this.fCurrentIncompatibleOptionsKeys == null) {
                    this.fCurrentIncompatibleOptionsKeys = new ArrayList<String>();
                }
                this.fCurrentIncompatibleOptionsKeys.add(pAttributes.getValue("key"));
            } else if (pLocalName == "applyOnOption") {
                if (this.fCurrentApplyOnOptionsKeys == null) {
                    this.fCurrentApplyOnOptionsKeys = new ArrayList<String>();
                }
                this.fCurrentApplyOnOptionsKeys.add(pAttributes.getValue("key"));
            }
        }
        return false;
    }

    @Override
    protected void xEndElement(String pNamespaceURI, String pLocalName, String pQName) throws Exception {
        if (pLocalName == "wspOptionDef" && this.fCurrentWspOptionDef != null) {
            if (this.fCurrentRequireOptionsKeys != null) {
                this.fCurrentWspOptionDef.setRequireOptionsKeys(this.fCurrentRequireOptionsKeys);
                this.fCurrentRequireOptionsKeys = null;
            }
            if (this.fCurrentIncompatibleOptionsKeys != null) {
                this.fCurrentWspOptionDef.setIncompatibleOptionsKeys(this.fCurrentIncompatibleOptionsKeys);
                this.fCurrentIncompatibleOptionsKeys = null;
            }
            if (this.fCurrentApplyOnOptionsKeys != null) {
                this.fCurrentWspOptionDef.setApplyOnOptionsKeys(this.fCurrentApplyOnOptionsKeys);
                this.fCurrentApplyOnOptionsKeys = null;
            }
            this.fPack.addWspTypeDef(this.fCurrentWspOptionDef);
            this.fCurrentWspOptionDef = null;
        }
    }

    @Override
    public IPack getLoadedObject() {
        return this.fPack;
    }

    public static class StopParseException
    extends SAXException {
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

