/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.pack.impl;

import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.src.fs.mini.FsMiniFactory;
import com.scenari.src.fs.mini.FsMiniSrcContent;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.pools.PoolBuffers;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.util.collections.ListFilterBase;
import eu.scenari.fw.util.collections.SecuredBag;
import eu.scenari.fw.util.xml.IObjectLoader;
import eu.scenari.wsp.pack.IPack;
import eu.scenari.wsp.pack.IPackListener;
import eu.scenari.wsp.pack.IPackMgr;
import eu.scenari.wsp.pack.IWspOptionDef;
import eu.scenari.wsp.pack.IWspTypeDef;
import eu.scenari.wsp.pack.impl.Pack;
import eu.scenari.wsp.pack.impl.PackContentHandler;
import eu.scenari.wsp.res.IRes;
import eu.scenari.wsp.res.IResMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackMgr
implements IPackMgr {
    public static String sPackDescFileName = "packdesc.xml";
    protected File fRootPacks = null;
    protected IResMgr fResMgr = null;
    protected Map<String, Pack> fPacks = new HashMap<String, Pack>();
    protected SecuredBag<IPackListener> fListeners = new SecuredBag();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPack getPack(String pIdPack) throws Exception {
        Map<String, Pack> map = this.fPacks;
        synchronized (map) {
            return this.fPacks.get(pIdPack);
        }
    }

    @Override
    public IPack installPack(InputStream pJarStream, boolean pAsynch) throws Exception {
        CRC32 vCheckSum = new CRC32();
        CheckedInputStream vIn = new CheckedInputStream(pJarStream, vCheckSum);
        if (this.fRootPacks == null) {
            throw new Exception("PackMgr is in fixed mode : no root folder defined for user installations.");
        }
        File vTmpFolder = PackMgr.createTempFolder(this.fRootPacks);
        try {
            PackMgr.unzipStream(vIn, vTmpFolder);
            String vId = Long.toString(vCheckSum.getValue(), 36);
            Pack vPack = (Pack)this.getPack(vId);
            if (vPack != null && vPack.getInstallStatus() == IPack.InstallStatus.installPending) {
                FsMiniSrcContent.deleteFiles(vTmpFolder);
                return vPack;
            }
            vPack = new Pack(vId, this, IPack.InstallStatus.installPending);
            this.addPack(vPack);
            if (pAsynch) {
                new Thread(new AsynchInstall(vTmpFolder, vPack)).start();
            } else {
                this.installPack(vTmpFolder, vPack);
            }
            return vPack;
        }
        catch (Exception e) {
            FsMiniSrcContent.deleteFiles(vTmpFolder);
            throw e;
        }
    }

    @Override
    public void uninstallPack(IPack pPack) throws Exception {
        FsMiniSrcContent.tryDeleteFiles(this.buildFolderFromId(pPack.getIdPack()), 3);
        if (this.removePack(pPack)) {
            this.fireEvent(pPack, IPackListener.EventType.removedPack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IPack> listAllPacks(List<IPack> pList) throws Exception {
        if (pList == null) {
            pList = new ArrayList<IPack>();
        }
        Map<String, Pack> map = this.fPacks;
        synchronized (map) {
            for (Pack vPack : this.fPacks.values()) {
                pList.add(vPack);
            }
        }
        return pList;
    }

    @Override
    public IRes findRes(String pKeyRes, ScVersion pMaxVersion, ScVersion pMinVersion) {
        FilterRes vFilter = new FilterRes(pKeyRes, pMaxVersion, pMinVersion);
        for (Pack vPack : this.fPacks.values()) {
            if (vPack.getInstallStatus() != IPack.InstallStatus.installed || vPack.getError().isFatalError()) continue;
            vPack.listRes(vFilter);
        }
        return vFilter.fBestMatch;
    }

    @Override
    public IWspTypeDef findWspTypeDef(String pKey, String pPreferedLang, ScVersion pMaxVersion, ScVersion pMinVersion) {
        FilterWspType vFilter = new FilterWspType(pKey, pPreferedLang, pMaxVersion, pMinVersion);
        for (Pack vPack : this.fPacks.values()) {
            if (vPack.getInstallStatus() != IPack.InstallStatus.installed || vPack.getError().isFatalError()) continue;
            vPack.listWspTypeDef(vFilter);
        }
        return vFilter.fBestMatch;
    }

    @Override
    public List<IWspOptionDef> findWspOptionDefForParent(String pParentKey, String pParentLang, ScVersion pParentVersion) {
        FilterWspOptionForParent vFilter = new FilterWspOptionForParent(pParentKey, pParentLang, pParentVersion);
        for (Pack vPack : this.fPacks.values()) {
            if (vPack.getInstallStatus() != IPack.InstallStatus.installed || vPack.getError().isFatalError()) continue;
            vPack.listWspTypeDef(vFilter);
        }
        return vFilter.fResult;
    }

    @Override
    public List<IWspTypeDef> findLatestWspTypeDef() {
        FilterLatestWspTypeDef vFilter = new FilterLatestWspTypeDef();
        for (Pack vPack : this.fPacks.values()) {
            if (vPack.getInstallStatus() != IPack.InstallStatus.installed || vPack.getError().isFatalError()) continue;
            vPack.listWspTypeDef(vFilter);
        }
        return vFilter.fResult;
    }

    @Override
    public void addPackListener(IPackListener pListener) {
        this.fListeners.add(pListener);
    }

    @Override
    public void removePackListener(IPackListener pListener) {
        this.fListeners.remove(pListener);
    }

    @Override
    public void setUpdtResMgr(IResMgr pResMgr) {
        this.fResMgr = pResMgr;
    }

    @Override
    public IResMgr getUpdtResMgr() {
        return this.fResMgr;
    }

    @Override
    public void initPackMgr() throws Exception {
        File[] vPacks;
        if (this.fRootPacks == null) {
            return;
        }
        for (File vFolderPack : vPacks = this.fRootPacks.listFiles()) {
            if (!vFolderPack.isDirectory()) continue;
            if (vFolderPack.getName().startsWith("_")) {
                try {
                    FsMiniSrcContent.deleteFiles(vFolderPack);
                }
                catch (Exception e) {
                    LogMgr.publishException(e);
                }
                continue;
            }
            try {
                File vPackDesc = new File(vFolderPack, sPackDescFileName);
                if (!vPackDesc.isFile()) continue;
                Pack vPack = new Pack(vFolderPack.getName(), this, IPack.InstallStatus.installed);
                this.loadPackDesc(vPack, vPackDesc);
                this.addPack(vPack);
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectLoader<IPack> addSystemPack() {
        Pack vPack;
        Map<String, Pack> map = this.fPacks;
        synchronized (map) {
            String vId = "~systemPack" + this.fPacks.size();
            vPack = new Pack(vId, this, IPack.InstallStatus.installed);
            this.addPack(vPack);
        }
        return new PackContentHandler(this, vPack);
    }

    protected void setRootFolder(File pRootFolder) throws Exception {
        this.fRootPacks = pRootFolder;
        if (!this.fRootPacks.isDirectory()) {
            this.fRootPacks = this.fRootPacks.getCanonicalFile();
            if (!this.fRootPacks.isDirectory()) {
                if (!this.fRootPacks.exists()) {
                    if (!this.fRootPacks.mkdirs()) {
                        throw LogMgr.newException("Le dossier root du PackMgr '" + pRootFolder + " - " + pRootFolder.getCanonicalPath() + "' n'a pu \u00eatre cr\u00e9\u00e9.", new String[0]);
                    }
                } else {
                    throw LogMgr.newException("Le root du PackMgr '" + pRootFolder + "' n'est pas un dossier.", new String[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void installPack(File pFolderPack, Pack pPack) {
        try {
            try {
                File vSourcePackDesc = new File(pFolderPack, sPackDescFileName);
                if (!vSourcePackDesc.isFile()) {
                    throw new Exception("No " + sPackDescFileName + " file in this pack.");
                }
                this.loadPackDesc(pPack, vSourcePackDesc);
                if (!pPack.getError().isFatalError()) {
                    List<IRes> vResList = pPack.listRes(null);
                    try {
                        this.fResMgr.dispatchStartInstallSession();
                        for (IRes vRes : vResList) {
                            String vUrl = pPack.fSourceUrlRes.get(vRes);
                            vRes.installRes(FsMiniFactory.newNodeFromCanonicalFile(new File(pFolderPack, vUrl), true));
                        }
                        Object var9_9 = null;
                        this.fResMgr.dispatchEndInstallSession();
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        this.fResMgr.dispatchEndInstallSession();
                        throw throwable;
                    }
                    File vTargetFolderPack = this.buildFolderFromId(pPack.getIdPack());
                    if (!vTargetFolderPack.isDirectory() && !vTargetFolderPack.mkdirs()) {
                        throw new Exception("Pack folder creation failed : " + vTargetFolderPack.getAbsolutePath());
                    }
                    File vTargetPackDesc = new File(vTargetFolderPack, sPackDescFileName);
                    FileOutputStream vOut = new FileOutputStream(vTargetPackDesc);
                    try {
                        StreamUtils.write(new FileInputStream(vSourcePackDesc), vOut);
                        Object var11_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        vOut.close();
                        throw throwable;
                    }
                    vOut.close();
                    pPack.setInstallStatus(IPack.InstallStatus.installed);
                    pPack.setInstallDate(vTargetPackDesc.lastModified());
                    this.fireEvent(pPack, IPackListener.EventType.addedPack);
                }
                pPack.setInstallStatus(IPack.InstallStatus.installFailed);
            }
            catch (Exception e) {
                LogMgr.publishException(e);
                pPack.setErrorIfHigher(IPack.ErrorPack.unknownError);
                if (pPack.getInstallStatus() == IPack.InstallStatus.installPending) {
                    pPack.setInstallStatus(IPack.InstallStatus.installFailed);
                }
                Object var13_16 = null;
                FsMiniSrcContent.deleteFiles(pFolderPack);
                return;
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            FsMiniSrcContent.deleteFiles(pFolderPack);
            throw throwable;
        }
        FsMiniSrcContent.deleteFiles(pFolderPack);
    }

    protected void loadPackDesc(Pack pPack, File pSourcePackDesc) throws Exception {
        try {
            PackContentHandler vPackContentHandler = new PackContentHandler(this, pPack);
            XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReaderAutoPooling(true, false);
            vPackContentHandler.initSaxHandlerForRoot(vXmlReader);
            vXmlReader.parse(new InputSource(new FileInputStream(pSourcePackDesc)));
            pPack.setInstallDate(pSourcePackDesc.lastModified());
        }
        catch (Exception e) {
            pPack.setErrorIfHigher(IPack.ErrorPack.malformedPack);
            throw e;
        }
    }

    protected File buildFolderFromId(String pId) {
        return new File(this.fRootPacks, pId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPack(Pack pPack) {
        Map<String, Pack> map = this.fPacks;
        synchronized (map) {
            this.fPacks.put(pPack.getIdPack(), pPack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removePack(IPack pPack) {
        Map<String, Pack> map = this.fPacks;
        synchronized (map) {
            return this.fPacks.remove(pPack.getIdPack()) != null;
        }
    }

    protected void fireEvent(IPack pPack, IPackListener.EventType pEventType) {
        for (IPackListener vPackListener : this.fListeners.asFrozenList()) {
            try {
                vPackListener.onPackUpdate(pPack, pEventType);
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void unzipStream(InputStream pJarIn, File pTargetFolder) throws Exception {
        byte[] vBuf;
        block12: {
            ZipInputStream vZipIn = new ZipInputStream(pJarIn);
            vBuf = PoolBuffers.popBytes4096();
            try {
                try {
                    ZipEntry vEntry = vZipIn.getNextEntry();
                    while (vEntry != null) {
                        if (vEntry.isDirectory()) {
                            File vFolder = new File(pTargetFolder, vEntry.getName());
                            vFolder.mkdir();
                        } else {
                            Object var9_9;
                            File vFile = new File(pTargetFolder, vEntry.getName());
                            vFile.createNewFile();
                            FileOutputStream vOutput = new FileOutputStream(vFile);
                            try {
                                int vOffset = 0;
                                while (vOffset >= 0) {
                                    vOffset = vZipIn.read(vBuf);
                                    if (vOffset <= 0) continue;
                                    ((OutputStream)vOutput).write(vBuf, 0, vOffset);
                                }
                                var9_9 = null;
                            }
                            catch (Throwable throwable) {
                                var9_9 = null;
                                ((OutputStream)vOutput).close();
                                throw throwable;
                            }
                            ((OutputStream)vOutput).close();
                        }
                        vEntry = vZipIn.getNextEntry();
                    }
                    Object var11_11 = null;
                    if (vZipIn == null) break block12;
                }
                catch (Exception e) {
                    FsMiniSrcContent.deleteFiles(pTargetFolder);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (vZipIn != null) {
                    vZipIn.close();
                }
                PoolBuffers.freeBytes(vBuf);
                throw throwable;
            }
            vZipIn.close();
        }
        PoolBuffers.freeBytes(vBuf);
    }

    protected static File createTempFolder(File pParent) throws Exception {
        File vTmpFolder;
        int vCount = 0;
        while ((vTmpFolder = new File(pParent, "_" + Long.toString(Math.round(Math.random() * 1000000.0), 32))).exists()) {
            if (++vCount <= 100) continue;
            throw new Exception("Impossible de cr\u00e9er un dossier temporaire dans " + pParent);
        }
        vTmpFolder.mkdirs();
        return vTmpFolder;
    }

    protected static int matchLang(String pSearchedLang, String pLang) {
        if (pLang == null) {
            pLang = "";
        }
        if (pSearchedLang != null && pSearchedLang.length() > 0) {
            if (pLang.equals(pSearchedLang)) {
                return 300;
            }
            if (pLang.startsWith(pSearchedLang)) {
                return 299 - (pLang.length() - pSearchedLang.length());
            }
            if (pSearchedLang.startsWith(pLang)) {
                return 199 - (pSearchedLang.length() - pLang.length());
            }
        } else if (pLang.length() == 0) {
            return 300;
        }
        if (pLang.startsWith("en")) {
            return 100 - pLang.length();
        }
        if (pLang.startsWith("fr")) {
            return 90 - pLang.length();
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilterLatestWspTypeDef
    extends ListFilterBase<IWspTypeDef> {
        public List<IWspTypeDef> fResult = new ArrayList<IWspTypeDef>();

        @Override
        public boolean add(IWspTypeDef pWspTypeDef) {
            if (pWspTypeDef.isOption()) {
                return false;
            }
            for (int i = 0; i < this.fResult.size(); ++i) {
                IWspTypeDef vWspTypeDefInResult = this.fResult.get(i);
                if (!vWspTypeDefInResult.getKey().equals(pWspTypeDef.getKey()) || !vWspTypeDefInResult.getLang().equals(pWspTypeDef.getLang())) continue;
                if (vWspTypeDefInResult.getVersion().compareTo(pWspTypeDef.getVersion()) < 0) {
                    this.fResult.set(i, pWspTypeDef);
                    return true;
                }
                return true;
            }
            this.fResult.add(pWspTypeDef);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilterWspOptionForParent
    extends ListFilterBase<IWspTypeDef> {
        public String fParentKey;
        public String fParentLang;
        public ScVersion fParentVersion;
        public List<IWspOptionDef> fResult = new ArrayList<IWspOptionDef>();

        public FilterWspOptionForParent(String pParentKey, String pParentLang, ScVersion pParentVersion) {
            this.fParentKey = pParentKey;
            this.fParentLang = pParentLang;
            this.fParentVersion = pParentVersion;
        }

        @Override
        public boolean add(IWspTypeDef pWspTypeDef) {
            if (!pWspTypeDef.isOption()) {
                return false;
            }
            IWspOptionDef vOptionDef = (IWspOptionDef)pWspTypeDef;
            if (vOptionDef.getParentKey().equals(this.fParentKey) && this.fParentVersion.isContainedIn(vOptionDef.getParentMaxVersion(), vOptionDef.getParentMinVersion())) {
                int vMatchLangScore = PackMgr.matchLang(this.fParentLang, vOptionDef.getParentLang());
                int vBestMatchOffset = -1;
                IWspOptionDef vBestMatch = null;
                for (int i = 0; i < this.fResult.size(); ++i) {
                    if (!this.fResult.get(i).getKey().equals(vOptionDef.getKey())) continue;
                    vBestMatchOffset = i;
                    vBestMatch = this.fResult.get(i);
                    break;
                }
                if (vBestMatch != null) {
                    int vBestMatchLangScore = PackMgr.matchLang(this.fParentLang, vBestMatch.getParentLang());
                    if (vMatchLangScore > vBestMatchLangScore) {
                        this.fResult.set(vBestMatchOffset, vOptionDef);
                    } else if (vMatchLangScore == vBestMatchLangScore && vBestMatch.getVersion().compareTo(vOptionDef.getVersion()) < 0) {
                        this.fResult.set(vBestMatchOffset, vOptionDef);
                    }
                } else {
                    this.fResult.add(vOptionDef);
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilterWspType
    extends ListFilterBase<IWspTypeDef> {
        public String fKey;
        public String fPreferedLang;
        public ScVersion fMaxVersion;
        public ScVersion fMinVersion;
        public IWspTypeDef fBestMatch = null;
        public int fMatchLangScore = 0;

        public FilterWspType(String pKey, String pPreferedLang, ScVersion pMaxVersion, ScVersion pMinVersion) {
            this.fKey = pKey;
            this.fPreferedLang = pPreferedLang;
            this.fMaxVersion = pMaxVersion;
            this.fMinVersion = pMinVersion;
        }

        @Override
        public boolean add(IWspTypeDef pWspTypeDef) {
            if (pWspTypeDef.getKey().equals(this.fKey) && pWspTypeDef.getVersion().isContainedIn(this.fMaxVersion, this.fMinVersion)) {
                int vMatchLangScore = PackMgr.matchLang(this.fPreferedLang, pWspTypeDef.getLang());
                if (this.fBestMatch != null) {
                    if (vMatchLangScore > this.fMatchLangScore) {
                        this.fBestMatch = pWspTypeDef;
                        this.fMatchLangScore = vMatchLangScore;
                    } else if (vMatchLangScore == this.fMatchLangScore && this.fBestMatch.getVersion().compareTo(pWspTypeDef.getVersion()) < 0) {
                        this.fBestMatch = pWspTypeDef;
                        this.fMatchLangScore = vMatchLangScore;
                    }
                } else {
                    this.fBestMatch = pWspTypeDef;
                    this.fMatchLangScore = vMatchLangScore;
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilterRes
    extends ListFilterBase<IRes> {
        public String fKey;
        public ScVersion fMaxVersion;
        public ScVersion fMinVersion;
        public IRes fBestMatch = null;

        public FilterRes(String pKey, ScVersion pMaxVersion, ScVersion pMinVersion) {
            this.fKey = pKey;
            this.fMaxVersion = pMaxVersion;
            this.fMinVersion = pMinVersion;
        }

        @Override
        public boolean add(IRes pRes) {
            if (pRes.getKey().equals(this.fKey) && pRes.getVersion().isContainedIn(this.fMaxVersion, this.fMinVersion)) {
                if (this.fBestMatch != null) {
                    if (this.fBestMatch.getVersion().compareTo(pRes.getVersion()) < 0) {
                        this.fBestMatch = pRes;
                    }
                } else {
                    this.fBestMatch = pRes;
                }
            }
            return true;
        }
    }

    protected class AsynchInstall
    implements Runnable {
        File fTmpFolder;
        Pack fPack;

        AsynchInstall(File pTmpFolder, Pack pPack) {
            this.fTmpFolder = pTmpFolder;
            this.fPack = pPack;
        }

        public void run() {
            PackMgr.this.installPack(this.fTmpFolder, this.fPack);
        }
    }
}

