/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.provider.helper;

import eu.scenari.wsp.provider.IWspDefListener;
import eu.scenari.wsp.provider.WspDefEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WspDefEventManager {
    protected List<ListenerEntry> fListeners = new ArrayList<ListenerEntry>();

    public synchronized void addWspDefListener(IWspDefListener pListener, int pOrder) {
        this.fListeners.add(new ListenerEntry(pListener, pOrder));
        Collections.sort(this.fListeners);
    }

    public synchronized int removeWspDefListener(IWspDefListener pListener, int pOrder) {
        int vFound = 0;
        for (int i = 0; i < this.fListeners.size(); ++i) {
            ListenerEntry vEntry = this.fListeners.get(i);
            if (vEntry.fListener == pListener && vEntry.fOrder == pOrder) {
                this.fListeners.remove(i--);
                ++vFound;
            }
            if (vEntry.fOrder > pOrder) break;
        }
        return vFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(WspDefEvent pEvent) throws Exception {
        ListenerEntry[] vFrozenListeners;
        WspDefEventManager wspDefEventManager = this;
        synchronized (wspDefEventManager) {
            vFrozenListeners = this.fListeners.toArray(new ListenerEntry[this.fListeners.size()]);
        }
        for (ListenerEntry vEntry : vFrozenListeners) {
            vEntry.fListener.onWspDefEvent(pEvent, vEntry.fOrder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ListenerEntry
    implements Comparable<ListenerEntry> {
        protected IWspDefListener fListener;
        protected int fOrder;

        public ListenerEntry(IWspDefListener pListener, int pOrder) {
            this.fListener = pListener;
            this.fOrder = pOrder;
        }

        @Override
        public int compareTo(ListenerEntry pOther) {
            return this.fOrder - pOther.fOrder;
        }
    }
}

