/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.repos;

import com.scenari.src.feature.ids.SrcFeatureIds;
import eu.scenari.fw.pools.PoolBuffers;

public class WspUri {
    public static String extractWspCdFromWspUri(String pWspUri) {
        int vEnd = pWspUri.indexOf(47);
        if (vEnd > 0) {
            return pWspUri.substring(0, vEnd);
        }
        return pWspUri;
    }

    public static String extractWspCdFromFullUri(String pFullUri) {
        int vStart = pFullUri.length() > 2 && pFullUri.charAt(0) == ';' && pFullUri.charAt(1) == '#' ? pFullUri.indexOf(59, 2) + 1 : 0;
        int vEnd = pFullUri.indexOf(47, vStart);
        if (vEnd > vStart) {
            return pFullUri.substring(vStart, vEnd);
        }
        if (vEnd == vStart || vStart == pFullUri.length()) {
            return null;
        }
        return vStart > 0 ? pFullUri.substring(vStart) : pFullUri;
    }

    public static String extractWspCdFromWspRefUri(String pWspRefUri) {
        return WspUri.extractWspCdFromWspUri(pWspRefUri);
    }

    public static String extractWspCdFromFullRefUri(String pWspRefUri) {
        return WspUri.extractWspCdFromFullUri(pWspRefUri);
    }

    public static String extractSrcUriFromWspUri(String pWspUri) {
        return WspUri.extractSrcUriFromFullUri(pWspUri);
    }

    public static String extractSrcUriFromFragmentUri(String pFragmentUri) {
        return WspUri.extractSrcUriFromFullUri(pFragmentUri);
    }

    public static String extractSrcUriFromFullUri(String pFullUri) {
        int vStart = pFullUri.indexOf(47);
        if (vStart > 0) {
            return pFullUri.substring(vStart);
        }
        if (vStart == 0) {
            return pFullUri;
        }
        return "";
    }

    public static String extractRefUriFromWspRefUri(String pWspRefUri) {
        int vStart = pWspRefUri.indexOf(47);
        if (vStart >= 0) {
            if (pWspRefUri.regionMatches(false, vStart + 1, "id:", 0, "id:".length())) {
                return pWspRefUri.substring(vStart + 1);
            }
            return vStart == 0 ? pWspRefUri : pWspRefUri.substring(vStart);
        }
        return "";
    }

    public static String extractRefUriFromFragmentRefUri(String pFragmentRefUri) {
        if (pFragmentRefUri.length() < 2) {
            return pFragmentRefUri;
        }
        if (pFragmentRefUri.charAt(0) == ';' && pFragmentRefUri.charAt(1) == '#') {
            int vAfterIdFragment = pFragmentRefUri.indexOf(59, 2) + 1;
            return pFragmentRefUri.substring(vAfterIdFragment);
        }
        return pFragmentRefUri;
    }

    public static String extractRefUriFromFullRefUri(String pFullRefUri) {
        int vStart;
        int vAfterIdFragment = 0;
        if (pFullRefUri.length() > 2 && pFullRefUri.charAt(0) == ';' && pFullRefUri.charAt(1) == '#') {
            vAfterIdFragment = pFullRefUri.indexOf(59, 2) + 1;
        }
        if ((vStart = pFullRefUri.indexOf(47, vAfterIdFragment)) < 0) {
            if (pFullRefUri.regionMatches(false, vAfterIdFragment, "id:", 0, "id:".length())) {
                return vAfterIdFragment > 0 ? pFullRefUri.substring(vAfterIdFragment) : pFullRefUri;
            }
            return "";
        }
        if (pFullRefUri.regionMatches(false, vStart + 1, "id:", 0, "id:".length())) {
            return pFullRefUri.substring(vStart + 1);
        }
        return vStart > 0 ? pFullRefUri.substring(vStart) : pFullRefUri;
    }

    public static String extractFragmentIdFromFragmentUri(String pFragmentUri) {
        return WspUri.extractFragmentIdFromFullUri(pFragmentUri);
    }

    public static String extractFragmentIdFromFullUri(String pFullUri) {
        int vEnd;
        if (pFullUri.length() < 2) {
            return null;
        }
        if (pFullUri.charAt(0) == ';' && pFullUri.charAt(1) == '#' && (vEnd = pFullUri.indexOf(59, 2)) > 0) {
            return pFullUri.substring(2, vEnd);
        }
        return null;
    }

    public static String extractFragmentIdFromFragmentRefUri(String pFragmentRefUri) {
        return WspUri.extractFragmentIdFromFullUri(pFragmentRefUri);
    }

    public static String extractFragmentIdFromFullRefUri(String pFullRefUri) {
        return WspUri.extractFragmentIdFromFullUri(pFullRefUri);
    }

    public static String buildWspUri(String pWspCd, String pSrcUri) {
        return pWspCd.concat(pSrcUri);
    }

    public static String buildFragmentUri(String pSrcUri, String pFragmentId) {
        if (pFragmentId == null || pFragmentId.length() == 0) {
            return pSrcUri;
        }
        StringBuilder vSb = PoolBuffers.popStringBuilder();
        vSb.append(";#").append(pFragmentId).append(';').append(pSrcUri);
        return PoolBuffers.getStringAndFreeStringBuilder(vSb);
    }

    public static String buildFullUri(String pWspCd, String pSrcUri, String pFragmentId) {
        if (pFragmentId == null || pFragmentId.length() == 0) {
            return WspUri.buildWspUri(pWspCd, pSrcUri);
        }
        StringBuilder vSb = PoolBuffers.popStringBuilder();
        vSb.append(";#").append(pFragmentId).append(';').append(pWspCd).append(pSrcUri);
        return PoolBuffers.getStringAndFreeStringBuilder(vSb);
    }

    public static String buildWspRefUri(String pWspCd, String pRefUri) {
        if (SrcFeatureIds.isSrcId(pRefUri)) {
            StringBuilder vSb = PoolBuffers.popStringBuilder();
            vSb.append(pWspCd).append('/').append(pRefUri);
            return PoolBuffers.getStringAndFreeStringBuilder(vSb);
        }
        return WspUri.buildWspUri(pWspCd, pRefUri);
    }

    public static String buildFragmentRefUri(String pRefUri, String pFragmentId) {
        return WspUri.buildFragmentUri(pRefUri, pFragmentId);
    }

    public static String buildFullRefUri(String pWspCd, String pRefUri, String pFragmentId) {
        if (SrcFeatureIds.isSrcId(pRefUri)) {
            StringBuilder vSb = PoolBuffers.popStringBuilder();
            vSb.append(";#").append(pFragmentId).append(';').append(pWspCd).append('/').append(pRefUri);
            return PoolBuffers.getStringAndFreeStringBuilder(vSb);
        }
        return WspUri.buildFullUri(pWspCd, pRefUri, pFragmentId);
    }

    public static String extractWspUriFromFullUri(String pFullUri) {
        if (pFullUri.length() < 2) {
            return pFullUri;
        }
        if (pFullUri.charAt(0) == ';' && pFullUri.charAt(1) == '#') {
            int vAfterIdFragment = pFullUri.indexOf(59, 2) + 1;
            return pFullUri.substring(vAfterIdFragment);
        }
        return pFullUri;
    }

    public static String extractWspRefUriFromFullRefUri(String pFullUri) {
        return WspUri.extractWspUriFromFullUri(pFullUri);
    }
}

