/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.repos.src;

import com.scenari.m.bdp.facet.IFacet;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.IHModule;
import com.scenari.m.bdp.service.repos.WServiceRepos;
import com.scenari.m.co.service.IWService;
import com.scenari.m.co.univers.IWUnivers;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.aspect.ISrcAspectDef;
import com.scenari.src.helpers.base.SrcContentFolderBase;
import com.scenari.src.helpers.util.SrcNodeFrontEnd;
import com.scenari.src.system.SrcSystemBase;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.wsp.provider.IWspDefinition;
import eu.scenari.wsp.provider.IWspProvider;
import eu.scenari.wsp.repos.IRepository;
import eu.scenari.wsp.repos.IRepositoryHandler;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ContentHandler;

public class ContentReposSrcServer
extends SrcSystemBase
implements ISrcServer {
    protected String fCdServiceRepos = null;
    protected IRepository fRepository = null;

    public ISrcContent findContentByUri(String pUri) throws Exception {
        IHModule vModule;
        if (pUri.length() == 0) {
            final IWspProvider vWspProvider = this.getRepository().getWspProvider();
            return new SrcContentFolderBase(){

                @Override
                public List<String> listChildrenNames(List<String> pListToAppend, int pStatusChildren) throws Exception {
                    if (pListToAppend == null) {
                        pListToAppend = new ArrayList<String>();
                    }
                    for (IWspDefinition vWspDefinition : vWspProvider) {
                        pListToAppend.add(vWspDefinition.getWspCode());
                    }
                    return pListToAppend;
                }
            };
        }
        int vNexSlash = pUri.indexOf(47, 1);
        String vWspCd = vNexSlash > 0 ? pUri.substring(1, vNexSlash) : pUri.substring(1);
        IHWorkspace vWsp = this.getRepository().getWsp(vWspCd, true);
        if (vWsp == null) {
            return ISrcNode.NULL;
        }
        ISrcNode vResult = vWsp.findNodeByUri(vNexSlash < 0 ? "" : pUri.substring(vNexSlash));
        IHItemType vItemType = vResult.getAspect(IWspSrc.ITEMTYPE_ASPECT_TYPE);
        if (vItemType != null && (vModule = vItemType.hGetModule("contentFacet")) != null && vModule instanceof IFacet) {
            vResult = ((IFacet)vModule).getFacet((IWspSrc)vResult, null, null);
        }
        return vResult;
    }

    public Object getAspect(ISrcAspectDef pDefinition) throws Exception {
        if (pDefinition == ISrcServer.TYPE) {
            return this;
        }
        return null;
    }

    public ISrcNode getStartSrcNode() throws Exception {
        return new SrcNodeFrontEnd(this, "");
    }

    public void publishDefinition(ContentHandler pHandler) throws Exception {
        throw new Exception("publishDefinition() not implemented");
    }

    protected synchronized IRepository getRepository() throws Exception {
        if (this.fRepository == null) {
            IWService vService = ((IWUnivers)this.fOwner).hGetService(this.fCdServiceRepos);
            if (vService == null) {
                throw LogMgr.newException("Le code du service de repository '" + this.fCdServiceRepos + "' d\u00e9fini dans l'espace source n'est pas d\u00e9clar\u00e9.", new String[0]);
            }
            if (!(vService instanceof WServiceRepos)) {
                throw LogMgr.newException("Le code du service de repository '" + this.fCdServiceRepos + "' d\u00e9fini dans l'espace source n'est pas du type '" + WServiceRepos.class.getName() + "'.", new String[0]);
            }
            this.fRepository = ((IRepositoryHandler)((Object)vService)).getRepository();
        }
        return this.fRepository;
    }
}

