/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.repos.wsptype;

import com.scenari.m.bdp.item.fs.XSsOverlay;
import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.src.system.ISrcSystem;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.wsp.repos.wsptype.WspOption;
import eu.scenari.wsp.res.IRes;
import eu.scenari.wsp.res.IResMgr;
import eu.scenari.wsp.res.IResMgrHolder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WspType
implements IResMgrHolder {
    protected IResMgr fResMgr = null;
    protected String fDefaultCode = null;
    protected String fUri = null;
    protected String fKey = null;
    protected String fLang = null;
    protected String fTitle = null;
    protected String fDescription = null;
    protected IRes fWspUpdateRes = null;
    protected ScVersion fWspVersion = ScVersion.UNDEFINED_VERSION;
    protected String fConfig = null;
    protected String fLocalAutoUpdate = null;
    protected List fSystemSpaces = new ArrayList();
    protected List fEditionSheets = new ArrayList();
    protected List<XSsOverlay> fOverlaysSs = null;
    protected List fOptions = null;
    protected ISrcSystem fContentRootSrcSystem = null;

    public WspType(IResMgr pResMgr) {
        this.fResMgr = pResMgr;
    }

    public void writeXml(IXmlWriter pWriter) throws Exception {
        int i;
        pWriter.writeStartTag(this.getTagRoot());
        if (this.fDefaultCode != null) {
            pWriter.writeAttribute("defaultCode", this.fDefaultCode);
        }
        pWriter.writeAttribute("title", this.fTitle);
        pWriter.writeAttribute("description", this.fDescription);
        if (this.fUri != null) {
            pWriter.writeAttribute("uri", this.fUri);
        }
        if (this.fKey != null) {
            pWriter.writeAttribute("key", this.fKey);
        }
        pWriter.writeAttribute("version", this.fWspVersion.toString());
        pWriter.writeEndOpenTag();
        if (this.fConfig != null) {
            pWriter.writeXmlFragment(this.fConfig);
        }
        if (this.fWspUpdateRes != null) {
            pWriter.writeStartTag("wspUpdate");
            if (this.fLocalAutoUpdate != null) {
                pWriter.writeAttribute("localAutoUpdate", this.fLocalAutoUpdate);
            }
            pWriter.writeEndOpenTag();
            this.fWspUpdateRes.writeXml(pWriter);
            pWriter.writeCloseTag("wspUpdate");
        }
        this.writeXmlContentRoot(pWriter);
        for (i = 0; i < this.fSystemSpaces.size(); ++i) {
            SystemSpace vSystSp = (SystemSpace)this.fSystemSpaces.get(i);
            vSystSp.writeXml(pWriter);
        }
        if (this.fOverlaysSs != null) {
            for (i = 0; i < this.fOverlaysSs.size(); ++i) {
                XSsOverlay vSsOverlay = this.fOverlaysSs.get(i);
                pWriter.writeStartTag("ssOverlay");
                pWriter.writeAttribute("ssUri", vSsOverlay.fSsUri);
                pWriter.writeEndOpenTag();
                pWriter.writeXmlFragment(vSsOverlay.fContentOverlay);
                pWriter.writeCloseTag("ssOverlay");
            }
        }
        if (this.fOptions != null) {
            for (i = 0; i < this.fOptions.size(); ++i) {
                ((WspType)this.fOptions.get(i)).writeXml(pWriter);
            }
        }
        for (i = 0; i < this.fEditionSheets.size(); ++i) {
            EditionSheet vEdSheet = (EditionSheet)this.fEditionSheets.get(i);
            vEdSheet.writeXml(pWriter);
        }
        pWriter.writeCloseTag(this.getTagRoot());
    }

    public void writeXmlContentRoot(IXmlWriter pWriter) throws Exception {
        if (this.fContentRootSrcSystem != null) {
            pWriter.writeStartTag("contentRoot");
            if (this.fContentRootSrcSystem != null) {
                pWriter.writeEndOpenTag();
                this.fContentRootSrcSystem.publishDefinition(pWriter);
                pWriter.writeCloseTag("contentRoot");
            } else {
                pWriter.writeEndEmptyTag();
            }
        }
    }

    public boolean isSameMaster(WspType pOther) {
        if (this.fUri.equals(pOther.fUri) && this.fWspVersion.equals(pOther.fWspVersion)) {
            if (this.fOptions == null && pOther.fOptions == null) {
                return true;
            }
            if (this.fOptions != null && pOther.fOptions != null && this.fOptions.size() == pOther.fOptions.size()) {
                int l = this.fOptions.size();
                for (int i = 0; i < l; ++i) {
                    WspOption vOtherOpt;
                    WspOption vOpt = (WspOption)this.fOptions.get(i);
                    if (vOpt.isSameMaster(vOtherOpt = (WspOption)pOther.fOptions.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getUri() {
        return this.fUri;
    }

    public String getKey() {
        return this.fKey;
    }

    public String getLang() {
        return this.fLang;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public IRes getWspUpdateRes() {
        return this.fWspUpdateRes;
    }

    public ScVersion getWspVersion() {
        return this.fWspVersion;
    }

    public void setWspVersion(ScVersion wspCurrentVersion) {
        this.fWspVersion = wspCurrentVersion;
    }

    public String getLocalAutoUpdate() {
        return this.fLocalAutoUpdate;
    }

    public List getSystemSpaces() {
        return this.fSystemSpaces;
    }

    public List<XSsOverlay> getOverlaysSs() {
        return this.fOverlaysSs;
    }

    public List<WspOption> getOptions() {
        return this.fOptions;
    }

    public void setOptions(List pOptions) {
        this.fOptions = pOptions;
    }

    @Override
    public IResMgr getResMgr() {
        return this.fResMgr;
    }

    protected String getTagRoot() {
        return "wspType";
    }

    public WspType getWspTypeParent() {
        return null;
    }

    public WspType getWspTypeRoot() {
        return this;
    }

    public ISrcSystem getContentRootSrcSystem() {
        return this.fContentRootSrcSystem;
    }

    public void setContentRootSrcSystem(ISrcSystem pContentRootSource) {
        this.fContentRootSrcSystem = pContentRootSource;
    }

    public boolean isOption() {
        return false;
    }

    public static class EditionSheet {
        public String fPack = null;
        public String fXpi = null;
        private String fVersion = null;

        protected void writeXml(IXmlWriter pWriter) throws Exception {
            pWriter.writeStartTag("editionSheet");
            pWriter.writeAttribute("pack", this.fPack);
            pWriter.writeAttribute("xpi", this.fXpi);
            if (this.fVersion != null) {
                pWriter.writeAttribute("version", this.fVersion);
            }
            pWriter.writeEndEmptyTag();
        }

        public void setVersion(WspType pWspType, String pVersion) {
            this.fVersion = pVersion != null && pVersion.equals(pWspType.getWspVersion()) ? null : pVersion;
        }

        public ScVersion getVersion(WspType pWspType) {
            if (this.fVersion != null) {
                return new ScVersion(this.fVersion);
            }
            return pWspType.getWspVersion();
        }
    }

    public static class SystemSpace {
        public String fSpace = null;
        public IRes fRes = null;
        public ISrcSystem fSourceSystem = null;
        public String fSourceXmlDef = null;
        private String fCurrentVersion = null;
        public String fLocalAutoUpdate = null;
        public boolean fStrictReload = false;
        public boolean fAutoDownload = true;
        public boolean fReadOnly = true;
        public boolean fOptional = false;
        public boolean fOverwrite = false;
        public ArrayList fWspOptions = new ArrayList();

        protected void writeXml(IXmlWriter pWriter) throws Exception {
            pWriter.writeStartTag("systemSpace");
            pWriter.writeAttribute("space", this.fSpace);
            if (this.fCurrentVersion != null) {
                pWriter.writeAttribute("currentVersion", this.fCurrentVersion);
            }
            if (this.fStrictReload) {
                pWriter.writeAttribute("strictReload", "true");
            }
            if (!this.fAutoDownload) {
                pWriter.writeAttribute("autoDownLoad", "false");
            }
            if (this.fLocalAutoUpdate != null) {
                pWriter.writeAttribute("localAutoUpdate", this.fLocalAutoUpdate);
            }
            if (!this.fReadOnly) {
                pWriter.writeAttribute("readOnly", "false");
            }
            if (this.fOptional) {
                pWriter.writeAttribute("optional", "true");
            }
            if (this.fOverwrite) {
                pWriter.writeAttribute("overwrite", "true");
            }
            pWriter.writeEndOpenTag();
            if (this.fSourceXmlDef != null) {
                pWriter.writeXmlFragment(this.fSourceXmlDef);
            } else {
                this.fRes.writeXml(pWriter);
            }
            pWriter.writeCloseTag("systemSpace");
        }

        public void setCurrentVersion(WspType pWspType, String pCurrentVersion) {
            this.fCurrentVersion = pCurrentVersion != null && pCurrentVersion.equals(pWspType.getWspVersion()) ? null : pCurrentVersion;
        }

        public ScVersion getCurrentVersion(WspType pWspType) {
            if (this.fCurrentVersion != null) {
                return new ScVersion(this.fCurrentVersion);
            }
            return pWspType.getWspVersion();
        }
    }
}

