/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.res.impl;

import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.src.ISrcNode;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.wsp.res.IRes;
import eu.scenari.wsp.res.IResMgr;
import eu.scenari.wsp.res.impl.ResMgr;
import java.io.File;

public class Res
implements IRes {
    protected ResMgr fResMgr;
    protected String fKey = null;
    protected ScVersion fVersion = null;
    protected File fFile = null;

    protected Res(ResMgr pResMgr, String pKey, String pVersion) {
        this(pResMgr, pKey, new ScVersion(pVersion));
    }

    protected Res(ResMgr pResMgr, String pKey, ScVersion pVersion) {
        if (pKey == null || pKey.length() == 0) {
            throw new IllegalArgumentException("Null res key not allowed.");
        }
        this.fResMgr = pResMgr;
        this.fKey = pKey;
        this.fVersion = pVersion != null ? pVersion.lock() : ScVersion.UNDEFINED_VERSION;
    }

    protected Res(ResMgr pResMgr, String pKey, ScVersion pVersion, File pFile) {
        this(pResMgr, pKey, pVersion.lock());
        this.fFile = pFile;
    }

    public IRes getAvailableRes() {
        if (this.fFile != null && this.fFile.exists()) {
            return this;
        }
        return this.fResMgr.searchLocalRes(this.fKey, this.fVersion, this.fVersion);
    }

    public File getLocalFile() {
        return this.fFile;
    }

    public String getKey() {
        return this.fKey;
    }

    public ScVersion getVersion() {
        return this.fVersion;
    }

    public void writeXml(IXmlWriter pWriter) throws Exception {
        pWriter.writeStartTag("res");
        pWriter.writeAttribute("key", this.fKey);
        pWriter.writeAttribute("version", this.fVersion.toString());
        pWriter.writeEndEmptyTag();
    }

    public IResMgr getResMgr() {
        return this.fResMgr;
    }

    public IRes installRes(ISrcNode pSrc) throws Exception {
        return this.fResMgr.installRes(this, pSrc);
    }

    public String toString() {
        return this.fKey + " (" + this.fVersion + ")";
    }

    protected void setFile(File pFile) {
        this.fFile = pFile;
    }
}

