/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.res.impl;

import com.scenari.s.fw.utils.HCharSeqUtil;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.copymove.SrcFeatureCopyMove;
import com.scenari.src.fs.mini.FsMiniFactory;
import com.scenari.src.fs.mini.FsMiniSrcNode;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.collections.SecuredBag;
import eu.scenari.fw.util.xml.IObjectLoader;
import eu.scenari.wsp.res.IRes;
import eu.scenari.wsp.res.IResListerner;
import eu.scenari.wsp.res.IResMgr;
import eu.scenari.wsp.res.impl.Res;
import eu.scenari.wsp.res.impl.ResLoader;
import java.io.File;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResMgr
implements IResMgr {
    protected String fFileNameContent = "content";
    protected String fFileNameData = "data";
    protected File fRootUpdates = null;
    protected File fRootUpdatesData = null;
    protected SecuredBag<IResListerner> fListeners = new SecuredBag();
    protected IResMgr fSubUpdtMgr = null;
    public static final Comparator sStringNumberComparator = new Comparator(){

        public int compare(Object pStr1, Object pStr2) {
            int vLen2;
            String vStr1 = (String)pStr1;
            String vStr2 = (String)pStr2;
            int vLen1 = vStr1.length();
            if (vLen1 > (vLen2 = vStr2.length())) {
                return 1;
            }
            if (vLen1 < vLen2) {
                return -1;
            }
            for (int i = 0; i < vLen1; ++i) {
                char vNum2;
                char vNum1 = vStr1.charAt(i);
                if (vNum1 > (vNum2 = vStr2.charAt(i))) {
                    return 1;
                }
                if (vNum1 >= vNum2) continue;
                return -1;
            }
            return 0;
        }

        public boolean equals(Object pObj) {
            return pObj == this;
        }
    };

    public void initMgr(File pRootUpdates) throws Exception {
        this.fRootUpdates = pRootUpdates;
        if (!this.fRootUpdates.isDirectory()) {
            this.fRootUpdates = pRootUpdates.getCanonicalFile();
            if (!this.fRootUpdates.isDirectory()) {
                if (!this.fRootUpdates.exists()) {
                    if (!this.fRootUpdates.mkdirs()) {
                        throw LogMgr.newException("Le dossier root de l'UpdateMgr '" + pRootUpdates + " - " + pRootUpdates.getCanonicalPath() + "' n'a pu \u00eatre cr\u00e9\u00e9.", new String[0]);
                    }
                } else {
                    throw LogMgr.newException("Le root de l'UpdateMgr '" + pRootUpdates + "' n'est pas un dossier.", new String[0]);
                }
            }
        }
        if (this.fFileNameData != null) {
            this.fRootUpdatesData = new File(this.fRootUpdates, this.fFileNameData);
            this.fRootUpdatesData.mkdir();
        } else {
            this.fRootUpdatesData = this.fRootUpdates;
        }
    }

    public void setSubUpdtMgr(IResMgr pSubUpdtMgr) {
        this.fSubUpdtMgr = pSubUpdtMgr;
    }

    @Override
    public IRes searchLocalRes(String pKey, ScVersion pMaxVersion, ScVersion pMinVersion) {
        IRes vResult = this.xSearchRes(pKey, pMaxVersion, pMinVersion);
        if (vResult == null && this.fSubUpdtMgr != null) {
            vResult = this.fSubUpdtMgr.searchLocalRes(pKey, pMaxVersion, pMinVersion);
        }
        return vResult;
    }

    @Override
    public void addLocalResListener(IResListerner pListener) {
        this.fListeners.add(pListener);
    }

    @Override
    public void removeLocalResListener(IResListerner pListener) {
        this.fListeners.remove(pListener);
    }

    @Override
    public IObjectLoader<IRes> createResLoader() {
        return new ResLoader(this);
    }

    @Override
    public void dispatchStartInstallSession() {
        this.fireLocalResEvent(IResListerner.LocalResEventType.startSession, null, null);
    }

    @Override
    public void dispatchEndInstallSession() {
        this.fireLocalResEvent(IResListerner.LocalResEventType.endSession, null, null);
    }

    protected IRes installRes(Res pRes, ISrcNode pSrc) throws Exception {
        ScVersion vVersion = pRes.getVersion().isPartiallyUndefined() ? new ScVersion(pRes.getVersion()).setZeroToUndefinedNumbers() : pRes.getVersion();
        File vFile = this.xGetFolderContentVersion(pRes.getKey(), vVersion);
        FsMiniSrcNode vDest = FsMiniFactory.newNodeFromCanonicalFile(vFile, true);
        if (vDest.getContentStatus() != -1) {
            if (!this.fireLocalResEvent(IResListerner.LocalResEventType.willRemoveLocalRes, pRes.getKey(), pRes.getVersion())) {
                return null;
            }
            vDest.removeSrc();
        }
        SrcFeatureCopyMove.copy(pSrc, vDest);
        this.fireLocalResEvent(IResListerner.LocalResEventType.addedLocalRes, pRes.getKey(), vVersion);
        return new Res(this, pRes.getKey(), vVersion, vFile);
    }

    protected boolean fireLocalResEvent(IResListerner.LocalResEventType pLocalResEventType, String pKey, ScVersion pVersion) {
        for (IResListerner vListener : this.fListeners.asFrozenList()) {
            try {
                if (vListener.onLocalResUpdate(pLocalResEventType, pKey, pVersion) || pLocalResEventType != IResListerner.LocalResEventType.willRemoveLocalRes) continue;
                return false;
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
        return true;
    }

    protected IRes xSearchRes(String pKey, ScVersion pMaxVersion, ScVersion pMinVersion) {
        File vFolderRes = new File(this.fRootUpdatesData, pKey);
        if (vFolderRes.isDirectory()) {
            int vMajor = pMaxVersion != null ? pMaxVersion.getMajorVersion() : -1;
            int vMedium = pMaxVersion != null ? pMaxVersion.getMediumVersion() : -1;
            int vMinor = pMaxVersion != null ? pMaxVersion.getMinorVersion() : -1;
            int vMinMajor = pMinVersion != null ? Math.max(0, pMinVersion.getMajorVersion()) : 0;
            int vMinMedium = pMinVersion != null ? Math.max(0, pMinVersion.getMediumVersion()) : 0;
            int vMinMinor = pMinVersion != null ? Math.max(0, pMinVersion.getMinorVersion()) : 0;
            String vStrMajor = null;
            if (vMajor == -1) {
                vStrMajor = this.xLookForMaxSubFolder(vFolderRes);
                if (vStrMajor != null) {
                    vMajor = Integer.parseInt(vStrMajor);
                }
                if (vMajor < vMinMajor) {
                    vStrMajor = null;
                }
            } else {
                vStrMajor = HCharSeqUtil.hGetIntToString(vMajor);
            }
            while (vStrMajor != null) {
                File vFolderMajor = new File(vFolderRes, vStrMajor);
                if (vFolderMajor.isDirectory()) {
                    String vStrMedium = null;
                    if (vMedium == -1) {
                        vStrMedium = this.xLookForMaxSubFolder(vFolderMajor);
                        if (vStrMedium != null) {
                            vMedium = Integer.parseInt(vStrMedium);
                        }
                        if (vMajor == vMinMajor && vMedium < vMinMedium) {
                            vStrMedium = null;
                        }
                    } else {
                        vStrMedium = HCharSeqUtil.hGetIntToString(vMedium);
                    }
                    while (vStrMedium != null) {
                        File vFolderMedium = new File(vFolderMajor, vStrMedium);
                        if (vFolderMedium.isDirectory()) {
                            String vStrMinor = null;
                            if (vMinor == -1) {
                                vStrMinor = this.xLookForMaxSubFolder(vFolderMedium);
                                if (vStrMinor != null) {
                                    vMinor = Integer.parseInt(vStrMinor);
                                }
                                if (vMajor == vMinMajor && vMedium == vMinMedium && vMinor < vMinMinor) {
                                    vStrMinor = null;
                                }
                            } else {
                                vStrMinor = HCharSeqUtil.hGetIntToString(vMinor);
                            }
                            while (vStrMinor != null) {
                                File vFolderMinor = new File(vFolderMedium, vStrMinor);
                                if (vFolderMinor.exists()) {
                                    ScVersion vVersion = new ScVersion();
                                    vVersion.setVersion(vMajor, vMedium, vMinor);
                                    return new Res(this, pKey, vVersion, new File(vFolderMinor, this.fFileNameContent));
                                }
                                if (vMinor > vMinMinor) {
                                    vStrMinor = HCharSeqUtil.hGetIntToString(--vMinor);
                                    continue;
                                }
                                vStrMinor = null;
                            }
                        }
                        if (vMedium > vMinMedium) {
                            vStrMedium = HCharSeqUtil.hGetIntToString(--vMedium);
                            continue;
                        }
                        vStrMedium = null;
                    }
                }
                if (vMajor > vMinMajor) {
                    vStrMajor = HCharSeqUtil.hGetIntToString(--vMajor);
                    continue;
                }
                vStrMajor = null;
            }
        }
        return null;
    }

    protected String xLookForMaxSubFolder(File pFolder) {
        String[] vListStr = pFolder.list();
        if (vListStr != null && vListStr.length > 0) {
            int i;
            int vNbNum = vListStr.length;
            String vMax = null;
            for (i = 0; i < vNbNum; ++i) {
                if (!ResMgr.isNumber(vListStr[i])) continue;
                vMax = vListStr[i++];
                break;
            }
            while (i < vNbNum) {
                String vStr = vListStr[i];
                if (ResMgr.isNumber(vStr) && sStringNumberComparator.compare(vMax, vStr) < 0) {
                    vMax = vListStr[i];
                }
                ++i;
            }
            return vMax;
        }
        return null;
    }

    protected File xGetFolderContentVersion(String pKey, ScVersion pVersion) {
        return new File(this.fRootUpdatesData, pVersion.toLocalPath(pKey, this.fFileNameContent));
    }

    protected static boolean isNumber(String pStr) {
        int vLen = pStr.length();
        if (vLen == 0) {
            return false;
        }
        for (int i = 0; i < vLen; ++i) {
            if (Character.isDigit(pStr.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

