/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.service.adminpack;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.HSDialog;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.universe.execframe.IExecFrame;
import eu.scenari.wsp.pack.IPack;
import eu.scenari.wsp.repos.IRepository;
import eu.scenari.wsp.service.adminpack.SvcAdminPack;
import java.io.InputStream;

public class SvcAdminPackDialog
extends HSDialog {
    public static final String CDACTION_LISTPACK = "ListPacks";
    public static final String CDACTION_INFOPACK = "InfoPack";
    public static final String CDACTION_INSTALLPACK = "InstallPack";
    public static final String CDACTION_UNINSTALLPACK = "UninstallPack";
    public static String sParamsInit = "SvcAdminPackReader";
    public static String sDialogResult = "SvcAdminPackSender";
    protected InputStream fParamStream = null;
    protected IRepository fRepository = null;
    protected IPack fPack = null;
    protected ILogMsg fMessageException = null;
    protected Object fResult = sDialogResult;

    public SvcAdminPackDialog(SvcAdminPack pService) {
        super(pService);
    }

    public Object getParamsInitializer(IExecFrame pExecFrame) {
        return sParamsInit;
    }

    public Object getDialogResult(IExecFrame pExecFrame) {
        return this.fResult;
    }

    protected String wGetDefaultCdAction() {
        return CDACTION_LISTPACK;
    }

    public InputStream getParamStream() {
        return this.fParamStream;
    }

    public void setParamStream(InputStream pParamStream) {
        this.fParamStream = pParamStream;
    }

    protected IHDialog xExecute() throws Exception {
        IHDialog vResult = this;
        String vCdAction = this.hGetCdAction();
        this.fRepository = ((SvcAdminPack)this.fService).getRepository(this);
        try {
            if (this.fRepository.getPackMgr() == null) {
                throw new Exception("Aucun packMgr d\u00e9clar\u00e9 pour ce repository.");
            }
            if (!CDACTION_LISTPACK.equals(vCdAction)) {
                if (CDACTION_INFOPACK.equals(vCdAction)) {
                    this.fPack = this.fRepository.getPackMgr().getPack(this.hGetParam());
                } else if (CDACTION_INSTALLPACK.equals(vCdAction)) {
                    this.fPack = this.fRepository.getPackMgr().installPack(this.getParamStream(), true);
                } else if (CDACTION_UNINSTALLPACK.equals(vCdAction)) {
                    this.fPack = this.fRepository.getPackMgr().getPack(this.hGetParam());
                    if (this.fPack == null) {
                        throw LogMgr.newException("Pack \u00e0 d\u00e9sinstaller non trouv\u00e9 (id du pack: %s).", this.hGetParam());
                    }
                    this.fRepository.getPackMgr().uninstallPack(this.fPack);
                } else {
                    vResult = super.xExecute();
                }
            }
        }
        catch (Exception e) {
            this.fMessageException = LogMgr.getMessage(e);
            LogMgr.publishMessage(this.fMessageException);
        }
        return vResult;
    }

    public IRepository getRepository() {
        return this.fRepository;
    }

    public ILogMsg getMessageException() {
        return this.fMessageException;
    }

    public IPack getPack() {
        return this.fPack;
    }
}

