/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.service.adminwsp;

import com.scenari.m.bdp.item.fs.HWorkspaceFs;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.dialog.webdav.WResultatGet;
import com.scenari.m.co.service.HSDialog;
import com.scenari.src.fs.mini.FsMiniFactory;
import com.scenari.src.helpers.util.ZipperSrc;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.mime.MimeMgr;
import eu.scenari.universe.execframe.IExecFrame;
import eu.scenari.wsp.provider.IWspDefinition;
import eu.scenari.wsp.provider.IWspProvider;
import eu.scenari.wsp.repos.IRepository;
import eu.scenari.wsp.repos.IWspHandler;
import eu.scenari.wsp.res.IRes;
import eu.scenari.wsp.service.adminwsp.SvcAdminWsp;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvcAdminWspDialog
extends HSDialog {
    public static final String CDACTION_LIST = "List";
    public static final String CDACTION_INFOWSPPROVIDER = "InfoWspProvider";
    public static final String CDACTION_INFOWSP = "InfoWsp";
    public static final String CDACTION_CREATEWSP = "CreateWsp";
    public static final String CDACTION_DELETEWSP = "DeleteWsp";
    public static final String CDACTION_UPDATE_WSPPROPS = "UpdateWspProps";
    public static final String CDACTION_IS_MIGRATION_NEEDED = "IsMigrationNeeded";
    public static final String CDACTION_UPDATE_WSPTYPE = "UpdateWspType";
    public static final String CDACTION_MIGRATE_UPDATE_WSPTYPE = "MigrateUpdateWspType";
    public static final String CDACTION_RELOADWSP = "ReloadWsp";
    public static final String CDACTION_GET_RES = "GetRes";
    public static final String CDACTION_ACTIVATE_MODE_LOAD_ALL_ITEMS = "ActivateModeLoadAllItems";
    public static final String CDACTION_DEACTIVATE_MODE_LOAD_ALL_ITEMS = "DectivateModeLoadAllItems";
    public static final String CDACTION_STATUS_LOADED_ALL_ITEMS = "StatusLoadedAllItems";
    public static final String CDACTION_REMOVECACHE = "RemoveCache";
    public static Pattern sSafeIdentifierKeyRes = Pattern.compile(".*\\.safe\\..*");
    public static Pattern sSafeIdentifierKeyResPath = Pattern.compile("(.*\\/)?skin\\/.*");
    public static String sParamsInit = "SvcAdminWspReader";
    public static String sDialogResult = "SvcAdminWspSender";
    protected InputStream fParamStream = null;
    protected Map<String, Object> fParamWspParams = null;
    protected IRepository fRepository = null;
    protected IWspHandler fWspHanler = null;
    protected IWspDefinition fWspDefinition = null;
    protected IWspHandler.IWspTypeUpdater fUpdater = null;
    protected List fListUpdates = null;
    protected ILogMsg fMessageException = null;
    protected Object fResult = sDialogResult;

    public SvcAdminWspDialog(SvcAdminWsp pService) {
        super(pService);
    }

    @Override
    public Object getParamsInitializer(IExecFrame pExecFrame) {
        return sParamsInit;
    }

    @Override
    public Object getDialogResult(IExecFrame pExecFrame) {
        return this.fResult;
    }

    @Override
    protected String wGetDefaultCdAction() {
        return CDACTION_LIST;
    }

    public InputStream getParamWspMeta() {
        return this.fParamStream;
    }

    public void setParamWspMeta(InputStream pParamWspMeta) {
        this.fParamStream = pParamWspMeta;
    }

    public InputStream getParamResStream() {
        return this.fParamStream;
    }

    public void setParamResStream(InputStream pParamResStream) {
        this.fParamStream = pParamResStream;
    }

    public Map<String, Object> getParamWspParams() {
        return this.fParamWspParams;
    }

    public void setParamWspParams(Map<String, Object> pParamWspParams) {
        this.fParamWspParams = pParamWspParams;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected IHDialog xExecute() throws Exception {
        void var1_3;
        SvcAdminWspDialog svcAdminWspDialog = this;
        String vCdAction = this.hGetCdAction();
        this.fRepository = ((SvcAdminWsp)this.fService).getRepository(this);
        try {
            if (CDACTION_INFOWSP.equals(vCdAction)) {
                this.initRefsWsp();
                return var1_3;
            } else if (CDACTION_CREATEWSP.equals(vCdAction)) {
                IWspProvider vWspProv = this.fRepository.getWspProvider();
                if (!vWspProv.controlAccess(this.hGetUser(), IWspProvider.PERM_WSP_CREATE)) throw LogMgr.newException("Access denied", new String[0]);
                this.fWspDefinition = vWspProv.createWsp(this.getParamWspParams(), this.getParamWspMeta());
                this.fWspHanler = this.fRepository.getWspHandler(this.fWspDefinition.getWspCode(), true);
                return var1_3;
            } else if (CDACTION_UPDATE_WSPPROPS.equals(vCdAction)) {
                this.initRefsWsp();
                if (!this.fWspDefinition.controlAccess(this.hGetUser(), IWspDefinition.PERM_ADMIN_PARAMS)) throw LogMgr.newException("Access denied", new String[0]);
                this.fWspDefinition.updateWsp(this.getParamWspParams());
                return var1_3;
            } else if (CDACTION_DELETEWSP.equals(vCdAction)) {
                this.initRefsWsp();
                if (!this.fWspDefinition.controlAccess(this.hGetUser(), IWspDefinition.PERM_ADMIN_DELETE)) throw LogMgr.newException("Access denied", new String[0]);
                this.fWspDefinition.deleteWsp(this.getParamWspParams());
                return var1_3;
            } else if (CDACTION_UPDATE_WSPTYPE.equals(vCdAction)) {
                this.initRefsWsp();
                if (!this.fWspDefinition.controlAccess(this.hGetUser(), IWspDefinition.PERM_ADMIN_PARAMS) && !this.fWspDefinition.controlAccess(this.hGetUser(), IWspDefinition.PERM_UPDATE_WSP_TYPE)) throw LogMgr.newException("Access denied", new String[0]);
                this.fUpdater = this.fWspHanler.newWspTypeUpdater(this.fWspHanler.getRepository().parseWspType(this.getParamWspMeta()));
                if (this.fUpdater == null) {
                    throw LogMgr.newException("Migration pending", new String[0]);
                }
                this.fUpdater.switchToNewWspType();
                return var1_3;
            } else if (CDACTION_MIGRATE_UPDATE_WSPTYPE.equals(vCdAction)) {
                this.initRefsWsp();
                if (!this.fWspDefinition.controlAccess(this.hGetUser(), IWspDefinition.PERM_ADMIN_PARAMS) && !this.fWspDefinition.controlAccess(this.hGetUser(), IWspDefinition.PERM_UPDATE_WSP_TYPE)) throw LogMgr.newException("Access denied", new String[0]);
                this.fUpdater = this.fWspHanler.newWspTypeUpdater(this.fWspHanler.getRepository().parseWspType(this.getParamWspMeta()));
                if (this.fUpdater == null) {
                    throw LogMgr.newException("Migration pending", new String[0]);
                }
                this.fUpdater.migrateAndSwitchToNewWspType();
                return var1_3;
            } else {
                if (CDACTION_IS_MIGRATION_NEEDED.equals(vCdAction)) {
                    this.initRefsWsp();
                    if (!this.fWspDefinition.controlAccess(this.hGetUser(), IWspDefinition.PERM_ADMIN_PARAMS) && !this.fWspDefinition.controlAccess(this.hGetUser(), IWspDefinition.PERM_UPDATE_WSP_TYPE)) throw LogMgr.newException("Access denied", new String[0]);
                    this.fUpdater = this.fWspHanler.newWspTypeUpdater(this.fWspHanler.getRepository().parseWspType(this.getParamWspMeta()));
                    if (this.fUpdater != null) return var1_3;
                    throw LogMgr.newException("Migration pending", new String[0]);
                }
                if (CDACTION_RELOADWSP.equals(vCdAction)) {
                    this.initRefsWsp();
                    this.fWspHanler.reload(this.fWspDefinition);
                    return var1_3;
                } else if (CDACTION_GET_RES.equals(vCdAction)) {
                    String vKey = this.hGetParam();
                    if (vKey == null) throw LogMgr.newException("KeyRes not defined.", new String[0]);
                    String vPath = null;
                    int vPathOffset = vKey.indexOf(47);
                    if (vPathOffset > 0) {
                        vPath = vKey.substring(vPathOffset + 1);
                        vKey = vKey.substring(0, vPathOffset);
                    }
                    if (!sSafeIdentifierKeyRes.matcher(vKey).matches() && (vPath == null || !sSafeIdentifierKeyResPath.matcher(vPath).matches())) throw LogMgr.newException("KeyRes '%s' not safe for download.", this.hGetParam());
                    ScVersion vMax = ScVersion.UNDEFINED_VERSION;
                    ScVersion vMin = ScVersion.UNDEFINED_VERSION;
                    String[] vVersionString = vKey.split("#");
                    String vKeyRes = vVersionString[0];
                    if (vVersionString.length >= 2 && vVersionString[1] != null) {
                        vMax = new ScVersion(vVersionString[1]);
                    }
                    if (vVersionString.length >= 3 && vVersionString[2] != null) {
                        vMin = new ScVersion(vVersionString[2]);
                    }
                    IRes vRes = this.fRepository.getResMgr().searchLocalRes(vKeyRes, vMax, vMin);
                    File vFile = null;
                    if (vRes != null) {
                        vFile = vRes.getLocalFile();
                    }
                    if (vFile == null) {
                        throw LogMgr.newException("KeyRes %s does not exist.", vKey);
                    }
                    if (vPath != null && vPath.length() > 0) {
                        vFile = new File(vFile, vPath);
                    }
                    if (vFile.isFile()) {
                        WResultatGet vGetResult = new WResultatGet();
                        vGetResult.hSetInputStream(new FileInputStream(vFile));
                        vGetResult.hSetLength((int)vFile.length());
                        vGetResult.hSetLastModifDate(vFile.lastModified());
                        vGetResult.hSetContentType(MimeMgr.getDefaultMimeMgr().searchMimeFromUrl(vFile.getName()));
                        vGetResult.hSetDownloadNameFile(vFile.getName());
                        this.fResult = vGetResult;
                        return var1_3;
                    } else {
                        if (!vFile.isDirectory()) throw LogMgr.newException("KeyRes %s does not exist.", this.hGetParam());
                        WResultatGet vGetResult = new WResultatGet();
                        vGetResult.hSetStream(new ZipperSrc(FsMiniFactory.newNodeFromCanonicalFile(vFile, true), null, null));
                        vGetResult.hSetContentType("application/zip");
                        vGetResult.hSetDownloadNameFile(vFile.getName().concat(".zip"));
                        this.fResult = vGetResult;
                    }
                    return var1_3;
                } else if (CDACTION_ACTIVATE_MODE_LOAD_ALL_ITEMS.equals(vCdAction)) {
                    this.initRefsWsp();
                    ((HWorkspaceFs)this.fWspHanler.getWsp()).hSetModeLoadAllItems(true);
                    return var1_3;
                } else if (CDACTION_DEACTIVATE_MODE_LOAD_ALL_ITEMS.equals(vCdAction)) {
                    this.initRefsWsp();
                    ((HWorkspaceFs)this.fWspHanler.getWsp()).hSetModeLoadAllItems(false);
                    return var1_3;
                } else if (CDACTION_STATUS_LOADED_ALL_ITEMS.equals(vCdAction)) {
                    this.initRefsWsp();
                    return var1_3;
                } else if (CDACTION_REMOVECACHE.equals(vCdAction)) {
                    this.initRefsWsp();
                    if (!this.fWspDefinition.controlAccess(this.hGetUser(), IWspDefinition.PERM_ADMIN_PARAMS)) throw LogMgr.newException("Access denied", new String[0]);
                    this.fWspHanler.removeCache();
                    return var1_3;
                } else {
                    IHDialog iHDialog = super.xExecute();
                }
            }
            return var1_3;
        }
        catch (Exception e) {
            this.fMessageException = LogMgr.getMessage(e);
            LogMgr.publishMessage(this.fMessageException);
        }
        return var1_3;
    }

    public IRepository getRepository() {
        return this.fRepository;
    }

    public ILogMsg getMessageException() {
        return this.fMessageException;
    }

    public IWspHandler getWspHanler() {
        return this.fWspHanler;
    }

    public IWspDefinition getWspDefinition() {
        return this.fWspDefinition;
    }

    public IWspHandler.IWspTypeUpdater getUpdater() {
        return this.fUpdater;
    }

    public List getListDownloadUpdates() {
        return this.fListUpdates;
    }

    protected void initRefsWsp() throws Exception {
        this.fWspHanler = this.fRepository.getWspHandler(this.hGetParam(), true);
        this.fWspDefinition = this.fRepository.getWspProvider().getWspDefinition(this.hGetParam());
    }
}

