/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.service.export;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.IHModule;
import com.scenari.m.bdp.module.rename.IHRenamingPlan;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.dialog.webdav.WResultatError;
import com.scenari.m.co.dialog.webdav.WResultatGet;
import com.scenari.m.co.service.HSDialog;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.helpers.base.SrcNodeWrapper;
import com.scenari.src.helpers.util.ZipperSrc;
import com.scenari.src.helpers.util.ZipperSrcFreeEncoding;
import eu.scenari.facet.export.FacetExport;
import eu.scenari.facet.export.IFacetExporter;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.universe.execframe.IExecFrame;
import eu.scenari.wsp.service.export.SvcExport;
import java.util.regex.Pattern;

public class SvcExportDialog
extends HSDialog {
    public static final String CDACTION_EXPORT = "Export";
    public static final String SCOPE_NODE = "node";
    public static final String SCOPE_NET = "net";
    public static final String FORMAT_JAR = "jar";
    public static final String FORMAT_ZIP = "zip";
    public static final String FORMAT_STREAM = "stream";
    public static String sParamsInit = "SvcExportReader";
    protected static Pattern sFileNameFilter = Pattern.compile("\\$|\\/|\\>|\\<|\\||\\?|\\:|\\*|\\\"|\\'|\\\\|\\p{Cntrl}|\\t}");
    protected String fParamRefUri = null;
    protected String fParamFormat = null;
    protected String fParamScope = null;
    protected IHWorkspace fWorkspace = null;
    protected ISrcNode fSrcNode = null;
    protected ILogMsg fError = null;
    protected Object fDialogResult = null;

    public SvcExportDialog(SvcExport pService) {
        super(pService);
    }

    public String getParamRefUri() {
        return this.fParamRefUri;
    }

    public void setParamRefUri(String pRefUri) {
        this.fParamRefUri = pRefUri;
    }

    public String getParamFormat() {
        return this.fParamFormat;
    }

    public void setParamFormat(String pParamFormat) {
        this.fParamFormat = pParamFormat;
    }

    public String getParamScope() {
        return this.fParamScope;
    }

    public void setParamScope(String pParamScope) {
        this.fParamScope = pParamScope;
    }

    public Object getParamsInitializer(IExecFrame pExecFrame) {
        return sParamsInit;
    }

    public Object getDialogResult(IExecFrame pExecFrame) {
        return this.fDialogResult != null ? this.fDialogResult : new WResultatError(404);
    }

    public IHWorkspace getWorkspace() {
        return this.fWorkspace;
    }

    public ISrcNode getSrcNode() {
        return this.fSrcNode;
    }

    public ILogMsg getError() {
        return this.fError;
    }

    protected String wGetDefaultCdAction() {
        return CDACTION_EXPORT;
    }

    protected IHDialog xExecute() throws Exception {
        IHDialog vResult = this;
        String vCdAction = this.hGetCdAction();
        if (CDACTION_EXPORT.equals(vCdAction)) {
            try {
                String vWspCode = this.hGetParam();
                this.fWorkspace = ((SvcExport)this.fService).getRepository(this).getWsp(vWspCode, true);
                this.fSrcNode = SrcFeatureIds.findNodeByRefUri(this.fWorkspace.findNodeByUri(""), this.fParamRefUri);
                if (this.fSrcNode.getContentStatus() <= 0) {
                    throw LogMgr.newException("La source de l'export '%s' n'existe pas.", this.fParamRefUri);
                }
                this.xExport();
            }
            catch (Exception e) {
                this.fError = LogMgr.getMessage(e);
            }
        } else {
            vResult = super.xExecute();
        }
        return vResult;
    }

    protected void xExport() throws Exception {
        String vScope = this.getParamFormat();
        if (vScope == null) {
            this.xExportNode();
        } else if (vScope.equals(SCOPE_NET)) {
            this.xExportNet();
        } else {
            this.xExportNode();
        }
    }

    protected void xExportNode() throws Exception {
        ISrcNode vExport = this.xCreateExportNode(this.fSrcNode, new FacetExport.UriReplacement(this.fSrcNode));
        this.xBuildResult(vExport);
    }

    protected void xExportNet() throws Exception {
        throw new Exception("Not implemented");
    }

    protected void xBuildResult(ISrcNode pRoot) throws Exception {
        String vFormat = this.getParamFormat();
        if (vFormat == null) {
            this.xBuildResultJar(pRoot);
        } else if (vFormat.equals(FORMAT_ZIP)) {
            this.xBuildResultZip(pRoot);
        } else if (vFormat.equals(FORMAT_STREAM)) {
            this.xBuildResultStream(pRoot);
        } else {
            this.xBuildResultJar(pRoot);
        }
    }

    protected void xBuildResultJar(ISrcNode pRoot) throws Exception {
        WResultatGet vResult = new WResultatGet();
        if (this.fParamRefUri == null || this.fParamRefUri.length() == 0) {
            vResult.hSetStream(new ZipperSrc(pRoot, null, null));
            vResult.hSetDownloadNameFile(this.getWspName().concat(".jar"));
        } else {
            vResult.hSetStream(new ZipperSrc(pRoot, pRoot.getSrcName(), null));
            vResult.hSetDownloadNameFile(pRoot.getSrcName().concat(".jar"));
        }
        vResult.hSetContentType("application/jar");
        long vDate = pRoot.getLastModif();
        vResult.hSetLastModifDate(vDate > 0L ? vDate : 0L);
        this.fDialogResult = vResult;
    }

    protected void xBuildResultZip(ISrcNode pRoot) throws Exception {
        WResultatGet vResult = new WResultatGet();
        if (this.fParamRefUri == null || this.fParamRefUri.length() == 0) {
            vResult.hSetStream(new ZipperSrcFreeEncoding(pRoot, null, null));
            vResult.hSetDownloadNameFile(this.getWspName().concat(".zip"));
        } else {
            vResult.hSetStream(new ZipperSrcFreeEncoding(pRoot, pRoot.getSrcName(), null));
            vResult.hSetDownloadNameFile(pRoot.getSrcName().concat(".zip"));
        }
        vResult.hSetContentType("application/zip");
        long vDate = pRoot.getLastModif();
        vResult.hSetLastModifDate(vDate > 0L ? vDate : 0L);
        this.fDialogResult = vResult;
    }

    protected void xBuildResultStream(ISrcNode pRoot) throws Exception {
        if (pRoot.getContentStatus() != 1) {
            this.xBuildResultJar(pRoot);
        } else {
            WResultatGet vResult = new WResultatGet();
            vResult.hSetInputStream(pRoot.newInputStream(true));
            vResult.hSetDownloadNameFile(pRoot.getSrcName());
            vResult.hSetContentType(pRoot.getContentType());
            vResult.hSetLength(pRoot.getContentSize());
            long vDate = pRoot.getLastModif();
            vResult.hSetLastModifDate(vDate > 0L ? vDate : 0L);
            this.fDialogResult = vResult;
        }
    }

    protected ISrcNode xCreateExportNode(ISrcNode pSrc, IHRenamingPlan pPlan) throws Exception {
        IHItemType vItemType = pSrc.getAspect(IWspSrc.ITEMTYPE_ASPECT_TYPE);
        if (vItemType != null) {
            ISrcNode vExport;
            String vCodeModuleExport = ((SvcExport)this.hGetService()).getCodeModuleExport(this);
            IHModule vModule = vItemType.hGetModule(vCodeModuleExport);
            if (vModule != null && vModule instanceof IFacetExporter && (vExport = ((IFacetExporter)((Object)vModule)).exportItem(pPlan, pSrc.getAspect(IWspSrc.WSPSRC_ASPECT_TYPE), null)) != null) {
                return vExport;
            }
            return pSrc;
        }
        return new SpaceWrapper(pSrc, pPlan);
    }

    protected String getWspName() throws Exception {
        String vName = this.fWorkspace.hGetTitleWorkspace();
        vName = vName == null ? this.fWorkspace.hGetCodeWorkspace() : sFileNameFilter.matcher(vName).replaceAll("");
        return vName;
    }

    public class SpaceWrapper
    extends SrcNodeWrapper {
        protected IHRenamingPlan fPlan;

        public SpaceWrapper(ISrcNode pSubSource, IHRenamingPlan pPlan) {
            super(pSubSource);
            this.fPlan = pPlan;
        }

        protected ISrcNode xCreateSrcNode(ISrcNode pSubSource) throws Exception {
            return SvcExportDialog.this.xCreateExportNode(pSubSource, this.fPlan);
        }
    }
}

