/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.service.gencommit;

import com.scenari.m.bdp.item.IHItemDef;
import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.bdp.itemtype.IHItemType;
import com.scenari.m.bdp.module.genpresc.IHModuleGenPresc;
import com.scenari.m.bdp.service.tabpresc.HSDialogTabPresc;
import com.scenari.m.bdp.univers.support.HInstanceDefBase;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.HSDialog;
import com.scenari.m.ge.generator.DestLockMgr;
import com.scenari.m.ge.generator.IGenerator;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.ids.SrcFeatureIds;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.universe.execframe.IExecFrame;
import eu.scenari.wsp.service.SvcWspBase;

public abstract class SvcGenCommitDialog
extends HSDialog {
    public static final String CDACTION_COMMIT = "Commit";
    public static String sParamsInit = "SvcGenCommitReader";
    public static String sDialogResult = "SvcGenCommitSender";
    protected IHWorkspace fWorkspace = null;
    protected String fRefUri = null;
    protected String fCdGen = null;
    protected String fUriSubInst = null;
    protected ISrcNode fSrcNode = null;
    protected IHItemDef fItemDef = null;
    protected IHModuleGenPresc fModuleGen = null;
    protected ILogMsg fError = null;

    public SvcGenCommitDialog(SvcWspBase pService) {
        super(pService);
    }

    public void setRefUri(String pRefUri) {
        this.fRefUri = pRefUri;
    }

    public void setCdGen(String pCdGen) {
        this.fCdGen = pCdGen;
    }

    public void setUriSubInst(String pUriSubInst) {
        this.fUriSubInst = pUriSubInst;
        this.setCdGen(HInstanceDefBase.getCdGenFromUriSubInst(pUriSubInst));
    }

    public Object getParamsInitializer(IExecFrame pExecFrame) {
        return sParamsInit;
    }

    public Object getDialogResult(IExecFrame pExecFrame) {
        return sDialogResult;
    }

    public IHWorkspace getWorkspace() {
        return this.fWorkspace;
    }

    public ISrcNode getSrcNode() {
        return this.fSrcNode;
    }

    public ILogMsg getError() {
        return this.fError;
    }

    protected String wGetDefaultCdAction() {
        return CDACTION_COMMIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHDialog xExecute() throws Exception {
        IHDialog vResult = this;
        String vCdAction = this.hGetCdAction();
        if (CDACTION_COMMIT.equals(vCdAction)) {
            try {
                String vWspCode = this.hGetParam();
                this.fWorkspace = ((SvcWspBase)this.fService).getRepository(this).getWsp(vWspCode, true);
                this.fSrcNode = SrcFeatureIds.findNodeByRefUri(this.fWorkspace.findNodeByUri(""), this.fRefUri);
                this.fItemDef = this.fSrcNode.getAspect(IWspSrc.ITEMDEF_ASPECT_TYPE);
                IHItemType vItemType = this.fWorkspace.hGetItemType(this.fItemDef.getUriSs());
                this.fModuleGen = (IHModuleGenPresc)vItemType.hGetModule(this.fCdGen);
                IGenerator vGen = this.fModuleGen.popGenerator();
                ISrcNode vFolderDest = this.fWorkspace.hGetFolderGeneration().findNodeByUri(HSDialogTabPresc.createSrcUriGenInWsp(this.fItemDef.getUri(), this.fModuleGen, this.hGetUser(), this.fUriSubInst));
                vGen.setDestRoot(vFolderDest);
                DestLockMgr.DestLock vLockDest = DestLockMgr.get().tryLockDest(vGen, false);
                if (vLockDest == null) {
                    throw LogMgr.newException("Generation pending...", new String[0]);
                }
                try {
                    this.commitGen(vGen);
                    Object var9_9 = null;
                    vLockDest.release();
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    vLockDest.release();
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.fError = LogMgr.getMessage(e);
            }
        } else {
            vResult = super.xExecute();
        }
        return vResult;
    }

    protected abstract void commitGen(IGenerator var1) throws Exception;
}

