/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.service.history;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.HSDialog;
import com.scenari.m.co.service.IWService;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.history.SrcFeatureHistory;
import com.scenari.src.feature.ids.SrcFeatureIds;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.universe.execframe.IExecFrame;
import eu.scenari.wsp.service.history.SvcHistory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvcHistoryDialog
extends HSDialog {
    public static final String CDACTION_LISTTRASHEDNODES = "ListTrashedNodes";
    public static final String CDACTION_LISTHISTORYNODES = "ListHistoryNodes";
    public static final String CDACTION_RESTOREFROMTRASH = "RestoreFromTrash";
    public static final String CDACTION_RESTOREFROMHISTORY = "RestoreFromHistory";
    public static String sParamsInit = "SvcHistoryReader";
    public static String sDialogResult = "SvcHistorySender";
    protected String fRefUriLive = null;
    protected String fRefUriHist = null;
    protected IHWorkspace fWorkspace = null;
    protected ISrcNode fSrcNodeLive = null;
    protected ISrcNode fSrcNodeRestored = null;
    protected List<ISrcNode> fSrcNodes = null;
    protected ILogMsg fError = null;

    public SvcHistoryDialog(IWService pService) {
        super(pService);
    }

    @Override
    protected String wGetDefaultCdAction() {
        return CDACTION_LISTTRASHEDNODES;
    }

    public void setRefUriLive(String pRefUri) {
        this.fRefUriLive = pRefUri;
    }

    public void setRefUriHist(String pRefUriHist) {
        this.fRefUriHist = pRefUriHist;
    }

    @Override
    public Object getParamsInitializer(IExecFrame pExecFrame) {
        return sParamsInit;
    }

    @Override
    public Object getDialogResult(IExecFrame pExecFrame) {
        return sDialogResult;
    }

    @Override
    protected IHDialog xExecute() throws Exception {
        IHDialog vResult = this;
        String vCdAction = this.hGetCdAction();
        if (CDACTION_LISTTRASHEDNODES.equals(vCdAction)) {
            try {
                String vWspCode = this.hGetParam();
                this.fWorkspace = ((SvcHistory)this.fService).getRepository(this).getWsp(vWspCode, true);
                if (this.fWorkspace == null) {
                    throw LogMgr.newException("Workspace '" + vWspCode + "' unknown.", new String[0]);
                }
                this.fSrcNodeLive = SrcFeatureIds.findNodeByRefUri(this.fWorkspace.findNodeByUri(""), this.fRefUriLive);
                this.fSrcNodes = SrcFeatureHistory.getTrashedNodes(this.fSrcNodeLive);
            }
            catch (Exception e) {
                LogMgr.addMessage((Throwable)e, "Fail to get trahsNodes for refUri : " + this.fRefUriLive, new String[0]);
                this.fError = LogMgr.getMessage(e);
            }
        } else if (CDACTION_LISTHISTORYNODES.equals(vCdAction)) {
            try {
                String vWspCode = this.hGetParam();
                this.fWorkspace = ((SvcHistory)this.fService).getRepository(this).getWsp(vWspCode, true);
                if (this.fWorkspace == null) {
                    throw LogMgr.newException("Workspace '" + vWspCode + "' unknown.", new String[0]);
                }
                this.fSrcNodeLive = SrcFeatureIds.findNodeByRefUri(this.fWorkspace.findNodeByUri(""), this.fRefUriLive);
                this.fSrcNodes = SrcFeatureHistory.getHistoryNodes(this.fSrcNodeLive);
            }
            catch (Exception e) {
                LogMgr.addMessage((Throwable)e, "Fail to get historyNodes for refUri : " + this.fRefUriLive, new String[0]);
                this.fError = LogMgr.getMessage(e);
            }
        } else if (CDACTION_RESTOREFROMTRASH.equals(vCdAction)) {
            try {
                String vWspCode = this.hGetParam();
                this.fWorkspace = ((SvcHistory)this.fService).getRepository(this).getWsp(vWspCode, true);
                if (this.fWorkspace == null) {
                    throw LogMgr.newException("Workspace '" + vWspCode + "' unknown.", new String[0]);
                }
                this.fSrcNodeLive = SrcFeatureIds.findNodeByRefUri(this.fWorkspace.findNodeByUri(""), this.fRefUriLive);
                ISrcNode vTrashedNode = SrcFeatureHistory.getTrashedNode(this.fSrcNodeLive, this.fRefUriHist);
                this.fSrcNodeRestored = SrcFeatureHistory.restoreNode(vTrashedNode, null);
                this.fSrcNodes = SrcFeatureHistory.getTrashedNodes(this.fSrcNodeLive);
            }
            catch (Exception e) {
                LogMgr.addMessage((Throwable)e, "Fail to retsore from trash. refUri : " + this.fRefUriHist, new String[0]);
                this.fError = LogMgr.getMessage(e);
            }
        } else if (CDACTION_RESTOREFROMHISTORY.equals(vCdAction)) {
            try {
                String vWspCode = this.hGetParam();
                this.fWorkspace = ((SvcHistory)this.fService).getRepository(this).getWsp(vWspCode, true);
                if (this.fWorkspace == null) {
                    throw LogMgr.newException("Workspace '" + vWspCode + "' unknown.", new String[0]);
                }
                this.fSrcNodeLive = SrcFeatureIds.findNodeByRefUri(this.fWorkspace.findNodeByUri(""), this.fRefUriLive);
                ISrcNode vHistNode = SrcFeatureHistory.getHistoryNode(this.fSrcNodeLive, this.fRefUriHist);
                this.fSrcNodeRestored = SrcFeatureHistory.restoreNode(vHistNode, null);
                this.fSrcNodes = SrcFeatureHistory.getHistoryNodes(this.fSrcNodeLive);
            }
            catch (Exception e) {
                LogMgr.addMessage((Throwable)e, "Fail to retsore from history. refUri : " + this.fRefUriHist, new String[0]);
                this.fError = LogMgr.getMessage(e);
            }
        } else {
            vResult = super.xExecute();
        }
        return vResult;
    }

    public ISrcNode getSrcNodeLive() {
        return this.fSrcNodeLive;
    }

    public ISrcNode getSrcNodeRestored() {
        return this.fSrcNodeRestored;
    }

    public List<ISrcNode> getSrcNodes() {
        return this.fSrcNodes;
    }

    public ILogMsg getError() {
        return this.fError;
    }
}

