/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.service.privatefolder;

import com.scenari.src.ISrcServer;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.helpers.util.SrcNodeFrontEnd;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.universe.execframe.IExecFrame;
import eu.scenari.wsp.service.privatefolder.SvcPrivateFolder;
import eu.scenari.wsp.service.wspsrc.SvcWspSrc;
import eu.scenari.wsp.service.wspsrc.SvcWspSrcDialog;

public class SvcPrivateFolderDialog
extends SvcWspSrcDialog {
    public static String sSvcPrivateFolderReader = "SvcPrivateFolderReader";
    public static String sSvcPrivateFolderSender = "SvcPrivateFolderSender";
    protected String fParamPrivateUri = null;

    public SvcPrivateFolderDialog(SvcPrivateFolder pService) {
        super(pService);
    }

    public void setParamPrivateUri(String pPrivateUri) {
        this.fParamPrivateUri = pPrivateUri;
    }

    public String getParamPrivateUri() {
        return this.fParamPrivateUri;
    }

    public Object getParamsInitializer(IExecFrame pExecFrame) {
        return sSvcPrivateFolderReader;
    }

    public Object getDialogResult(IExecFrame pExecFrame) {
        return sSvcPrivateFolderSender;
    }

    protected void findSrc() throws Exception {
        try {
            String vWspCode = this.hGetParam();
            this.fWorkspace = ((SvcWspSrc)this.fService).getRepository(this).getWsp(vWspCode, true);
            if (this.fWorkspace == null) {
                throw LogMgr.newException("Workspace '" + vWspCode + "' unknown.", new String[0]);
            }
            String vUri = SrcFeatureIds.findUriByRefUri(this.fWorkspace.findNodeByUri(""), this.fParamRefUri);
            ISrcServer vPrivateFolder = this.fWorkspace.getPrivateDataFolder(vUri);
            this.fSrcNode = new SrcNodeFrontEnd(vPrivateFolder, this.fParamPrivateUri);
        }
        catch (Exception e) {
            LogMgr.addMessage((Throwable)e, "Fail to get srcNode for refUri : " + this.fParamRefUri, new String[0]);
            this.fError = LogMgr.getMessage(e);
        }
    }
}

