/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.service.search;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.HSDialog;
import com.scenari.src.feature.search.SrcFeatureSearch;
import com.scenari.src.search.ISearchRequest;
import com.scenari.src.search.ISearchRequestCompiled;
import com.scenari.src.search.ISearchRequestEditable;
import com.scenari.src.search.ISearchResultRow;
import eu.scenari.universe.execframe.IExecFrame;
import eu.scenari.wsp.service.search.SvcSearch;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvcSearchDialog
extends HSDialog {
    public static final String CDACTION_SEARCH = "Search";
    public static String sParamsInit = "SvcSearchReader";
    public static String sDialogResult = "SvcSearchSender";
    public static int sMaxResults = 10000;
    protected IHWorkspace fWorkspace = null;
    protected Object fStreamRequest = null;
    protected ISearchRequestCompiled fRequest = null;
    protected Iterator<ISearchResultRow> fResults = null;

    public SvcSearchDialog(SvcSearch pService) {
        super(pService);
    }

    public void setStreamRequest(String pStreamRequest) {
        this.fStreamRequest = new StringReader(pStreamRequest);
    }

    public void setStreamRequest(Reader pStreamRequest) {
        this.fStreamRequest = pStreamRequest;
    }

    public void setStreamRequest(InputStream pStreamRequest) {
        this.fStreamRequest = pStreamRequest;
    }

    public ISearchRequestCompiled getRequest() {
        return this.fRequest;
    }

    public Iterator<ISearchResultRow> getResults() {
        return this.fResults;
    }

    @Override
    public Object getParamsInitializer(IExecFrame pExecFrame) {
        return sParamsInit;
    }

    @Override
    public final Object getDialogResult(IExecFrame pExecFrame) {
        return sDialogResult;
    }

    @Override
    protected final String wGetDefaultCdAction() {
        return CDACTION_SEARCH;
    }

    @Override
    protected final IHDialog xExecute() throws Exception {
        IHDialog vResult = this;
        String vCdAction = this.hGetCdAction();
        if (CDACTION_SEARCH.equals(vCdAction)) {
            ISearchRequestEditable vReq;
            String vWspCode = this.hGetParam();
            this.fWorkspace = ((SvcSearch)this.fService).getRepository(this).getWsp(vWspCode, true);
            ISearchRequestEditable iSearchRequestEditable = vReq = this.fStreamRequest instanceof Reader ? SrcFeatureSearch.parseXmlRequest((Reader)this.fStreamRequest) : SrcFeatureSearch.parseXmlRequest((InputStream)this.fStreamRequest);
            if (vReq.getResultType() == ISearchRequest.ResultType.entries && (vReq.getMaxResults() <= 0 || vReq.getMaxResults() > sMaxResults)) {
                vReq.setMaxResults(sMaxResults);
            }
            this.fRequest = SrcFeatureSearch.compileRequest(vReq, this.fWorkspace.findNodeByUri(""));
            this.fResults = this.fRequest.execute(null);
        } else {
            vResult = super.xExecute();
        }
        return vResult;
    }
}

