/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.service.versions;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.HSDialog;
import com.scenari.m.co.service.IWService;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.feature.versions.INetVersionNodeAspect;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.universe.execframe.IExecFrame;
import eu.scenari.wsp.service.versions.SvcVersions;

public class SvcVersionsDialog
extends HSDialog {
    public static final String CDACTION_CREATE = "Create";
    public static String sParamsInit = "SvcVersionsReader";
    public static String sDialogResult = "SvcVersionsSender";
    protected String fRefUri = null;
    protected String fComment = null;
    protected IHWorkspace fWorkspace = null;
    protected ISrcNode fSrcNode = null;
    protected ILogMsg fError = null;

    public SvcVersionsDialog(IWService pService) {
        super(pService);
    }

    protected String wGetDefaultCdAction() {
        return CDACTION_CREATE;
    }

    public void setRefUri(String pRefUri) {
        this.fRefUri = pRefUri;
    }

    public void setComment(String pComment) {
        this.fComment = pComment;
    }

    public Object getParamsInitializer(IExecFrame pExecFrame) {
        return sParamsInit;
    }

    public Object getDialogResult(IExecFrame pExecFrame) {
        return sDialogResult;
    }

    protected IHDialog xExecute() throws Exception {
        IHDialog vResult = this;
        String vCdAction = this.hGetCdAction();
        if (CDACTION_CREATE.equals(vCdAction)) {
            try {
                String vWspCode = this.hGetParam();
                this.fWorkspace = ((SvcVersions)this.fService).getRepository(this).getWsp(vWspCode, true);
                if (this.fWorkspace == null) {
                    throw LogMgr.newException("Workspace '" + vWspCode + "' unknown.", new String[0]);
                }
                this.fSrcNode = SrcFeatureIds.findNodeByRefUri(this.fWorkspace.findNodeByUri(""), this.fRefUri);
                INetVersionNodeAspect vVersionSrcNode = this.fSrcNode.getAspect(INetVersionNodeAspect.TYPE);
                vVersionSrcNode.createNetVersion(this.fComment, null);
            }
            catch (Exception e) {
                LogMgr.addMessage((Throwable)e, "Fail to get srcNode for refUri : " + this.fRefUri, new String[0]);
                this.fError = LogMgr.getMessage(e);
            }
        } else {
            vResult = super.xExecute();
        }
        return vResult;
    }

    public ILogMsg getError() {
        return this.fError;
    }
}

