/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.service.wspmetaeditor;

import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.HSDialog;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.serializer.simple.XmlWriterAppendable;
import eu.scenari.fw.initapp.ScVersion;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.stream.bytes.OutputStreamBlob;
import eu.scenari.universe.execframe.IExecFrame;
import eu.scenari.wsp.pack.IPackMgr;
import eu.scenari.wsp.pack.IWspOptionDef;
import eu.scenari.wsp.pack.IWspTypeDef;
import eu.scenari.wsp.repos.IRepository;
import eu.scenari.wsp.repos.IWspHandler;
import eu.scenari.wsp.repos.wsptype.WspOption;
import eu.scenari.wsp.repos.wsptype.WspType;
import eu.scenari.wsp.repos.wsptype.WspTypeContentHandler;
import eu.scenari.wsp.res.IRes;
import eu.scenari.wsp.service.adminwsp.SvcAdminWsp;
import eu.scenari.wsp.service.adminwsp.SvcAdminWspDialog;
import eu.scenari.wsp.service.wspmetaeditor.SvcWspMetaEditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvcWspMetaEditorDialog
extends HSDialog {
    public static final String CDACTION_GETNEWEDITOR = "GetNewEditor";
    public static final String CDACTION_GETUPDATEEDITOR = "GetUpdateEditor";
    public static final String CDACTION_CREATEWSP = "CreateWsp";
    public static final String CDACTION_IS_MIGRATION_NEEDED = "IsMigrationNeeded";
    public static final String CDACTION_UPDATEWSPTYPE = "UpdateWspType";
    public static final String CDACTION_MIGRATE_UPDATE_WSPTYPE = "MigrateUpdateWspType";
    public static final String TAG_WSPMETAEDITOR = "wspMetaEditor";
    public static final String TAG_WSPTYPEDEF = "wspTypeDef";
    public static final String TAG_WSPOPTIONDEF = "wspOptionDef";
    public static final String ATT_URI = "uri";
    public static final String ATT_TITLE = "title";
    public static final String ATT_NATURE = "nature";
    public static final String ATT_LANG = "lang";
    public static final String ATT_VERSION = "version";
    public static final String ATT_KEYRESWSPTYPE = "keyResWspType";
    public static final String ATT_SELECTED = "selected";
    public static final String ATT_UNKNOWN = "unknown";
    protected static final Comparator<IWspTypeDef> WSPTYPEDEF_COMPARATOR = new Comparator<IWspTypeDef>(){

        @Override
        public int compare(IWspTypeDef pO1, IWspTypeDef pO2) {
            int vLabelComp = pO1.getTitle().compareTo(pO2.getTitle());
            if (vLabelComp == 0) {
                return pO1.getVersion().compareTo(pO2.getVersion());
            }
            return vLabelComp;
        }
    };
    public static String sParamsInit = "SvcWspMetaEditorReader";
    public static String sDialogResult = "SvcWspMetaEditorSender";
    protected Map<String, Object> fParamWspParams = null;
    protected InputStream fParamWspMetaSpec = null;
    protected IRepository fRepository = null;
    protected Document fEditor = null;
    protected ILogMsg fMessageException = null;

    public SvcWspMetaEditorDialog(SvcWspMetaEditor pService) {
        super(pService);
    }

    @Override
    public Object getParamsInitializer(IExecFrame pExecFrame) {
        return sParamsInit;
    }

    @Override
    public Object getDialogResult(IExecFrame pExecFrame) {
        return sDialogResult;
    }

    @Override
    protected String wGetDefaultCdAction() {
        return CDACTION_GETNEWEDITOR;
    }

    public Map<String, Object> getParamWspParams() {
        return this.fParamWspParams;
    }

    public void setParamWspParams(Map<String, Object> pParamWspParams) {
        this.fParamWspParams = pParamWspParams;
    }

    public InputStream getParamWspMetaSpec() {
        return this.fParamWspMetaSpec;
    }

    public void setParamWspMetaSpec(InputStream pParamWspMetaSpec) {
        this.fParamWspMetaSpec = pParamWspMetaSpec;
    }

    @Override
    protected IHDialog xExecute() throws Exception {
        IHDialog vResult = this;
        String vCdAction = this.hGetCdAction();
        this.fRepository = ((SvcWspMetaEditor)this.fService).getRepository(this);
        try {
            if (CDACTION_GETNEWEDITOR.equals(vCdAction)) {
                this.buildDefaultEditor();
            } else if (CDACTION_GETUPDATEEDITOR.equals(vCdAction)) {
                this.buildDefaultEditor();
                this.injectCurrentWspMetaInEditor();
            } else {
                if (CDACTION_CREATEWSP.equals(vCdAction)) {
                    SvcAdminWsp vSvcAdminWsp = ((SvcWspMetaEditor)this.fService).getSvcAdminWsp(this);
                    SvcAdminWspDialog vSvcAdminDialog = (SvcAdminWspDialog)vSvcAdminWsp.hNewDialog(this);
                    vSvcAdminDialog.hSetCdAction(CDACTION_CREATEWSP);
                    vSvcAdminDialog.setParamWspParams(this.getParamWspParams());
                    vSvcAdminDialog.setParamWspMeta(this.buildWspMetaFromWspMetaSpec());
                    return vSvcAdminDialog;
                }
                if (CDACTION_UPDATEWSPTYPE.equals(vCdAction) || CDACTION_MIGRATE_UPDATE_WSPTYPE.equals(vCdAction) || CDACTION_IS_MIGRATION_NEEDED.equals(vCdAction)) {
                    SvcAdminWsp vSvcAdminWsp = ((SvcWspMetaEditor)this.fService).getSvcAdminWsp(this);
                    SvcAdminWspDialog vSvcAdminDialog = (SvcAdminWspDialog)vSvcAdminWsp.hNewDialog(this);
                    vSvcAdminDialog.hSetCdAction(vCdAction);
                    vSvcAdminDialog.hSetParam(this.hGetParam());
                    vSvcAdminDialog.setParamWspMeta(this.buildWspMetaFromWspMetaSpec());
                    return vSvcAdminDialog;
                }
                vResult = super.xExecute();
            }
        }
        catch (Exception e) {
            this.fMessageException = LogMgr.getMessage(e);
            LogMgr.publishMessage(this.fMessageException);
        }
        return vResult;
    }

    protected void buildDefaultEditor() throws Exception {
        this.fEditor = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Node vNode = this.fEditor.appendChild(this.fEditor.createElement(TAG_WSPMETAEDITOR));
        IPackMgr vPackMgr = this.getRepository().getPackMgr();
        List<IWspTypeDef> vListWspTypes = vPackMgr.findLatestWspTypeDef();
        this.buildNodes(vListWspTypes, vNode, vPackMgr);
    }

    protected void injectCurrentWspMetaInEditor() throws Exception {
        WspType vWspType;
        IWspHandler vWspHandler = this.getRepository().getWspHandler(this.hGetParam(), true);
        if (vWspHandler != null && (vWspType = vWspHandler.getWspType()) != null) {
            this.injectWspTypeInNode(vWspType, this.fEditor.getDocumentElement());
        }
    }

    protected void buildNodes(List<? extends IWspTypeDef> pListWspTypes, Node pParentNode, IPackMgr pPackMgr) {
        Collections.sort(pListWspTypes, WSPTYPEDEF_COMPARATOR);
        for (IWspTypeDef iWspTypeDef : pListWspTypes) {
            Element vElt = this.fEditor.createElement(iWspTypeDef.isOption() ? TAG_WSPOPTIONDEF : TAG_WSPTYPEDEF);
            vElt.setAttribute(ATT_URI, iWspTypeDef.getUri());
            vElt.setAttribute(ATT_KEYRESWSPTYPE, iWspTypeDef.getKeyResWspType());
            vElt.setAttribute(ATT_LANG, iWspTypeDef.getLang());
            vElt.setAttribute(ATT_TITLE, iWspTypeDef.getTitle());
            vElt.setAttribute(ATT_VERSION, iWspTypeDef.getVersion().toString());
            if (iWspTypeDef.isOption()) {
                vElt.setAttribute(ATT_NATURE, ((IWspOptionDef)iWspTypeDef).getNature());
            }
            pParentNode.appendChild(vElt);
            List<IWspOptionDef> vChildren = pPackMgr.findWspOptionDefForParent(iWspTypeDef.getKey(), iWspTypeDef.getLang(), iWspTypeDef.getVersion());
            this.buildNodes(vChildren, vElt, pPackMgr);
        }
    }

    protected void injectWspTypeInNode(WspType pWspType, Element pParentNode) {
        for (Element vChild = (Element)pParentNode.getFirstChild(); vChild != null; vChild = (Element)vChild.getNextSibling()) {
            if (!pWspType.getUri().equals(vChild.getAttribute(ATT_URI))) continue;
            vChild.setAttribute(ATT_SELECTED, Boolean.TRUE.toString());
            if (pWspType.getOptions() != null) {
                for (WspOption vWspOption : pWspType.getOptions()) {
                    this.injectWspTypeInNode(vWspOption, vChild);
                }
            }
            return;
        }
        Element vElt = this.fEditor.createElement(pWspType.isOption() ? TAG_WSPOPTIONDEF : TAG_WSPTYPEDEF);
        vElt.setAttribute(ATT_URI, pWspType.getUri());
        if (pWspType.getWspUpdateRes() != null) {
            vElt.setAttribute(ATT_KEYRESWSPTYPE, pWspType.getWspUpdateRes().getKey());
        }
        if (pWspType.getWspVersion() != null) {
            vElt.setAttribute(ATT_VERSION, pWspType.getWspVersion().toString());
        }
        vElt.setAttribute(ATT_LANG, pWspType.getLang());
        vElt.setAttribute(ATT_TITLE, pWspType.getTitle());
        vElt.setAttribute(ATT_SELECTED, Boolean.TRUE.toString());
        vElt.setAttribute(ATT_UNKNOWN, Boolean.TRUE.toString());
        if (pWspType.isOption()) {
            // empty if block
        }
        pParentNode.insertBefore(vElt, pParentNode.getFirstChild());
        if (pWspType.getOptions() != null) {
            for (WspOption vWspOption : pWspType.getOptions()) {
                this.injectWspTypeInNode(vWspOption, vElt);
            }
        }
    }

    protected InputStream buildWspMetaFromWspMetaSpec() throws Exception {
        XMLReader vXmlReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        WspMetaSpecContentHandler vWspMetaSpecContentHandler = new WspMetaSpecContentHandler(this.getRepository().getPackMgr());
        vXmlReader.setContentHandler(vWspMetaSpecContentHandler);
        vXmlReader.parse(new InputSource(this.getParamWspMetaSpec()));
        OutputStreamBlob vBlob = new OutputStreamBlob();
        XmlWriterAppendable vXmlWriter = new XmlWriterAppendable(new OutputStreamWriter((OutputStream)vBlob, "UTF-8"));
        vWspMetaSpecContentHandler.getWspType().writeXml(vXmlWriter);
        vXmlWriter.close();
        return vBlob.getInputStream(true);
    }

    public Document getEditor() {
        return this.fEditor;
    }

    public IRepository getRepository() {
        return this.fRepository;
    }

    public ILogMsg getMessageException() {
        return this.fMessageException;
    }

    protected static class WspMetaSpecContentHandler
    extends DefaultHandler {
        protected WspType fCurrentWspType;
        protected IPackMgr fPackMgr;

        public WspMetaSpecContentHandler(IPackMgr pPackMgr) {
            this.fPackMgr = pPackMgr;
        }

        public WspType getWspType() {
            return this.fCurrentWspType;
        }

        public void startElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws SAXException {
            if (pLocalName == SvcWspMetaEditorDialog.TAG_WSPTYPEDEF) {
                String vKeyResWspType = pAttributes.getValue(SvcWspMetaEditorDialog.ATT_KEYRESWSPTYPE);
                ScVersion vVersion = new ScVersion(pAttributes.getValue(SvcWspMetaEditorDialog.ATT_VERSION));
                if (vKeyResWspType == null) {
                    throw new SAXException("WspType notAllowed");
                }
                IRes vRes = this.fPackMgr.getUpdtResMgr().searchLocalRes(vKeyResWspType, vVersion, vVersion);
                if (vRes == null) {
                    throw new SAXException("Local res '" + vKeyResWspType + "' not found.");
                }
                this.fCurrentWspType = this.xLoadWspType(new File(vRes.getLocalFile(), "wsptype.xml"));
            } else if (pLocalName == SvcWspMetaEditorDialog.TAG_WSPOPTIONDEF) {
                String vKeyResWspType = pAttributes.getValue(SvcWspMetaEditorDialog.ATT_KEYRESWSPTYPE);
                ScVersion vVersion = new ScVersion(pAttributes.getValue(SvcWspMetaEditorDialog.ATT_VERSION));
                if (vKeyResWspType == null) {
                    throw new SAXException("WspOption notAllowed");
                }
                IRes vRes = this.fPackMgr.getUpdtResMgr().searchLocalRes(vKeyResWspType, vVersion, vVersion);
                if (vRes == null) {
                    throw new SAXException("Local res '" + vKeyResWspType + "' not found.");
                }
                if (this.fCurrentWspType.getOptions() == null) {
                    this.fCurrentWspType.setOptions(new ArrayList());
                }
                this.fCurrentWspType.getOptions().add((WspOption)this.xLoadWspType(new File(vRes.getLocalFile(), "wsptype.xml")));
            }
        }

        public void endElement(String pUri, String pLocalName, String pQName) throws SAXException {
            if (this.fCurrentWspType != null && this.fCurrentWspType instanceof WspOption) {
                this.fCurrentWspType = ((WspOption)this.fCurrentWspType).getWspTypeParent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WspType xLoadWspType(File pSource) throws SAXException {
            try {
                WspTypeContentHandler vHandler = new WspTypeContentHandler(this.fPackMgr.getUpdtResMgr());
                XMLReader vReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
                try {
                    vHandler.initSaxHandlerForRoot(vReader);
                    FileInputStream vWspTypeIn = new FileInputStream(pSource);
                    vReader.parse(new InputSource(vWspTypeIn));
                    Object var6_6 = null;
                    HPoolXmlReader.hGet().hFreeXmlReader(vReader);
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    HPoolXmlReader.hGet().hFreeXmlReader(vReader);
                    throw throwable;
                }
                return vHandler.getWspType();
            }
            catch (Exception e) {
                throw (SAXException)LogMgr.addMessage(new SAXException(), LogMgr.getMessage(e));
            }
        }
    }
}

