/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wsp.service.wspsrc;

import com.scenari.m.bdp.item.IHWorkspace;
import com.scenari.m.bdp.item.IWspSrc;
import com.scenari.m.co.dialog.IHDialog;
import com.scenari.m.co.service.HSDialog;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.ids.SrcFeatureIds;
import com.scenari.src.feature.streams.SrcFeatureStreams;
import eu.scenari.fw.log.ILogMsg;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.universe.execframe.IExecFrame;
import eu.scenari.wsp.service.wspsrc.SvcWspSrc;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvcWspSrcDialog
extends HSDialog {
    public static final String CDACTION_GETSRC = "GetSrc";
    public static final String CDACTION_PUTSRC = "PutSrc";
    public static String sSvcWspSrcReader = "SvcWspSrcReader";
    public static String sSvcWspSrcSender = "SvcWspSrcSender";
    protected String fParamRefUri = null;
    protected List<String> fParamRefUris = null;
    protected InputStream fParamStream = null;
    protected IHWorkspace fWorkspace = null;
    protected ISrcNode fSrcNode = null;
    protected List<ISrcNode> fSrcNodes = null;
    protected ILogMsg fError = null;

    public SvcWspSrcDialog(SvcWspSrc pService) {
        super(pService);
    }

    public void setParamRefUri(String pRefUri) {
        this.fParamRefUri = pRefUri;
    }

    public void setParamRefUri(List<String> pRefUris) {
        this.fParamRefUris = pRefUris;
    }

    public String getParamRefUri() {
        return this.fParamRefUri;
    }

    public void setParamRefUris(List<String> pParamRefUris) {
        this.fParamRefUris = pParamRefUris;
    }

    public List<String> getParamRefUris() {
        return this.fParamRefUris;
    }

    public void setParamStream(InputStream pParamStream) {
        this.fParamStream = pParamStream;
    }

    public InputStream getParamStream() {
        return this.fParamStream;
    }

    @Override
    public Object getParamsInitializer(IExecFrame pExecFrame) {
        return sSvcWspSrcReader;
    }

    @Override
    public Object getDialogResult(IExecFrame pExecFrame) {
        return sSvcWspSrcSender;
    }

    public IHWorkspace getWorkspace() {
        return this.fWorkspace;
    }

    public ISrcNode getSrcNode() {
        return this.fSrcNode;
    }

    public List<ISrcNode> getSrcNodes() {
        return this.fSrcNodes;
    }

    public ILogMsg getError() {
        return this.fError;
    }

    @Override
    protected String wGetDefaultCdAction() {
        return CDACTION_GETSRC;
    }

    @Override
    protected IHDialog xExecute() throws Exception {
        IHDialog vResult = this;
        String vCdAction = this.hGetCdAction();
        if (CDACTION_GETSRC.equals(vCdAction)) {
            this.findSrc();
        } else if (CDACTION_PUTSRC.equals(vCdAction)) {
            this.findSrc();
            if (this.fSrcNode != null) {
                SrcFeatureStreams.writeFrom(this.fSrcNode, this.fParamStream);
            }
        } else {
            vResult = super.xExecute();
        }
        return vResult;
    }

    protected void findSrc() throws Exception {
        try {
            String vWspCode = this.hGetParam();
            this.fWorkspace = ((SvcWspSrc)this.fService).getRepository(this).getWsp(vWspCode, true);
            if (this.fWorkspace == null) {
                throw LogMgr.newException("Workspace '" + vWspCode + "' unknown.", new String[0]);
            }
            if (this.fParamRefUri != null) {
                this.fSrcNode = SrcFeatureIds.findNodeByRefUri(this.fWorkspace.findNodeByUri(""), this.fParamRefUri);
            } else if (this.fParamRefUris != null) {
                IWspSrc vRootWsp = this.fWorkspace.findNodeByUri("");
                this.fSrcNodes = new ArrayList<ISrcNode>(this.fParamRefUris.size());
                for (String vRefUri : this.fParamRefUris) {
                    this.fSrcNodes.add(SrcFeatureIds.findNodeByRefUri(vRootWsp, vRefUri));
                }
            }
        }
        catch (Exception e) {
            LogMgr.addMessage((Throwable)e, "Fail to get srcNode for refUri : " + this.fParamRefUri, new String[0]);
            this.fError = LogMgr.getMessage(e);
        }
    }
}

