/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wspfs;

import com.scenari.m.co.user.IHActorMgr;
import com.scenari.m.co.user.IUser;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.src.ISrcNode;
import com.scenari.src.ISrcServer;
import com.scenari.src.system.ISrcSystem;
import eu.scenari.fw.stream.StreamUtils;
import eu.scenari.fw.util.xml.IFragmentSaxHandler;
import eu.scenari.wsp.provider.IWspDefinition;
import eu.scenari.wsp.provider.IWspProvider;
import eu.scenari.wsp.provider.WspDefEvent;
import eu.scenari.wspfs.FsWspProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.acl.Permission;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FsWspDefinition
implements IWspDefinition {
    protected String fWspCode;
    protected String fWspTitle;
    protected FsWspProvider fWspProvider;
    protected ISrcSystem fSrcSystemContent = null;
    protected ISrcNode fSrcRootContent = null;
    protected ISrcSystem fSrcSystemGen = null;
    protected ISrcNode fSrcRootGen = null;

    public FsWspDefinition(FsWspProvider pWspProvider, String pWspCode) {
        this.fWspCode = pWspCode;
        this.fWspProvider = pWspProvider;
        this.fWspTitle = null;
    }

    @Override
    public ISrcNode getSrcRootContent() throws Exception {
        return this.fSrcRootContent;
    }

    @Override
    public ISrcNode getSrcRootGen() throws Exception {
        return this.fSrcRootGen;
    }

    @Override
    public String getWspCode() {
        return this.fWspCode;
    }

    @Override
    public Element getWspProperties() {
        return null;
    }

    @Override
    public IWspProvider getWspProvider() {
        return this.fWspProvider;
    }

    @Override
    public String getWspTitle() {
        return this.fWspTitle;
    }

    @Override
    public ISrcServer getPrivateDataFolder(String pSrcUri) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readWspMeta(IFragmentSaxHandler pWspMetaHandler) throws Exception {
        XMLReader vReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
        try {
            pWspMetaHandler.initSaxHandlerForRoot(vReader);
            ISrcNode vWspMeta = this.fWspProvider.buildWspMetaSrc(this);
            vReader.parse(new InputSource(vWspMeta.newInputStream(false)));
        }
        finally {
            HPoolXmlReader.hGet().hFreeXmlReader(vReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeWspMeta(InputStream pNewWspMeta) throws Exception {
        OutputStream vOut = this.fWspProvider.buildWspMetaSrc(this).newOutputStream(false);
        try {
            StreamUtils.write(pNewWspMeta, vOut);
        }
        finally {
            vOut.close();
        }
        this.fWspProvider.fWspDefEventManager.dispatchEvent(new WspDefEvent(WspDefEvent.TYPE_PROPERTIES_UPDATED, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWsp(Map<String, Object> pOptions) throws Exception {
        boolean vUpdated = false;
        String vTitle = (String)pOptions.get("title");
        if (vTitle != null) {
            this.fWspTitle = vTitle;
            vUpdated = true;
        }
        if (vUpdated) {
            FsWspProvider fsWspProvider = this.fWspProvider;
            synchronized (fsWspProvider) {
                this.fWspProvider.saveWspList();
            }
        }
    }

    @Override
    public void deleteWsp(Map<String, Object> pDeleteParams) throws Exception {
        boolean vDeleteContent = false;
        boolean vDeleteGen = false;
        if (pDeleteParams != null) {
            vDeleteContent = Boolean.parseBoolean((String)pDeleteParams.get("deleteContent"));
            vDeleteGen = Boolean.parseBoolean((String)pDeleteParams.get("deleteGen"));
        }
        this.fWspProvider.deleteWsp(this.fWspCode, vDeleteContent, vDeleteGen);
    }

    @Override
    public boolean controlAccess(IUser pUser, Permission pPerm) {
        return true;
    }

    public ISrcSystem getSrcSystemRootContent() {
        return this.fSrcSystemContent;
    }

    public ISrcSystem getSrcSystemRootGen() {
        return this.fSrcSystemGen;
    }

    public IHActorMgr getActorMgr() {
        return null;
    }

    public void saveListUsersWsp(InputStream pStream) throws Exception {
        throw new Exception("TODO");
    }

    public static void writeRights(IXmlWriter pXmlWriter, IHActorMgr pActorMgr) throws Exception {
        if (pActorMgr != null) {
            pXmlWriter.writeOpenTag("access");
            int vNbRoles = pActorMgr.hGetRoles().size();
            Iterator iter = pActorMgr.hGetUsers();
            while (iter.hasNext()) {
                String vUser = (String)iter.next();
                List vList = pActorMgr.hGetRolesByUser(vUser);
                if (vList.size() <= 0) continue;
                pXmlWriter.writeStartTag("user");
                pXmlWriter.writeAttribute("account", vUser);
                if (vList.size() != vNbRoles) {
                    StringBuilder vBuf = new StringBuilder(vList.size() * 12);
                    vBuf.append((String)vList.get(0));
                    for (int j = 1; j < vList.size(); ++j) {
                        vBuf.append(' ');
                        vBuf.append((String)vList.get(j));
                    }
                    pXmlWriter.writeAttribute("rights", vBuf.toString());
                }
                pXmlWriter.writeEndEmptyTag();
            }
            pXmlWriter.writeCloseTag("access");
        }
    }
}

