/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wspfs;

import com.scenari.m.co.user.IUser;
import com.scenari.s.fw.util.xml.HPoolXmlReader;
import com.scenari.serializer.simple.XmlWriterAppendable;
import com.scenari.src.ISrcContent;
import com.scenari.src.ISrcNode;
import com.scenari.src.feature.alternateurl.SrcFeatureAlternateUrl;
import com.scenari.src.feature.paths.SrcFeaturePaths;
import com.scenari.src.feature.relocate.SrcFeatureRelocate;
import com.scenari.src.fs.basic.FsBasicSystem;
import com.scenari.src.fs.mini.FsMiniFactory;
import com.scenari.src.system.ISrcSystem;
import com.scenari.xsldom.xalan.stree.DocumentImpl;
import com.scenari.xsldom.xalan.stree.ElementImpl;
import eu.scenari.fw.log.LogMgr;
import eu.scenari.fw.util.lang.TunneledException;
import eu.scenari.wsp.provider.IWspDefListener;
import eu.scenari.wsp.provider.IWspDefinition;
import eu.scenari.wsp.provider.IWspProvider;
import eu.scenari.wsp.provider.WspDefEvent;
import eu.scenari.wsp.provider.helper.WspDefEventManager;
import eu.scenari.wsp.repos.IRepository;
import eu.scenari.wsp.repos.wsptype.WspType;
import eu.scenari.wsp.repos.wsptype.WspTypeContentHandler;
import eu.scenari.wspfs.FsWspDefinition;
import eu.scenari.wspfs.WspListDefContentHandler;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.acl.Permission;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FsWspProvider
implements IWspProvider.IWspProviderInternal {
    protected List<FsWspDefinition> fListWspDef = new ArrayList<FsWspDefinition>();
    protected List<? super FsWspDefinition> fListWspDefFrozen = null;
    protected WspDefEventManager fWspDefEventManager = new WspDefEventManager();
    protected ISrcNode fRootWspContents = null;
    protected ISrcNode fRootWspGenerations = null;
    protected ISrcNode fInternalData = null;
    protected String fWspMetaPath = ".wspmeta";
    protected String fDefaultSourcesPath = "sources";
    protected String fDefaultGenPath = "~gen";
    protected String fWspListFilePath = "wspList.xml";
    protected boolean fIsServerMode = false;
    protected Element fWspProviderProperties = null;

    @Override
    public synchronized Iterator<IWspDefinition> iterator() throws TunneledException {
        if (this.fListWspDefFrozen == null) {
            this.fListWspDefFrozen = new ArrayList<FsWspDefinition>(this.fListWspDef);
        }
        return this.fListWspDefFrozen.iterator();
    }

    @Override
    public IWspDefinition createWsp(Map<String, Object> pCreateParams, InputStream pWspMeta) throws Exception {
        FsWspDefinition vResult = this.hCreateWsp((String)pCreateParams.get("code"), pCreateParams.get("folderContent"), pCreateParams.get("folderGen"), pWspMeta);
        String vTitle = (String)pCreateParams.get("title");
        if (vTitle != null) {
            vResult.fWspTitle = vTitle;
        }
        return vResult;
    }

    @Override
    public boolean controlAccess(IUser pUser, Permission pPerm) {
        if (pUser.getAccount() == "anonymous") {
            return true;
        }
        try {
            return pUser.isSuperAdmin();
        }
        catch (Exception e) {
            LogMgr.publishException(e);
            return true;
        }
    }

    @Override
    public synchronized IWspDefinition getWspDefinition(String pCode) throws Exception {
        for (FsWspDefinition vWspDef : this.fListWspDef) {
            if (!vWspDef.getWspCode().equals(pCode)) continue;
            return vWspDef;
        }
        return null;
    }

    @Override
    public synchronized Element getWspProviderProperties() {
        if (this.fWspProviderProperties == null) {
            DocumentImpl vDoc = new DocumentImpl();
            this.fWspProviderProperties = (Element)vDoc.appendChild(vDoc.createElement("wspProviderProperties"));
            this.xOverrideWspProvProps();
            ((ElementImpl)this.fWspProviderProperties).setComplete(true);
            vDoc.setComplete(true);
        }
        return this.fWspProviderProperties;
    }

    private void xOverrideWspProvProps() {
        this.fWspProviderProperties.setAttribute("backEnd", "fs");
        if (!this.fIsServerMode) {
            try {
                this.fWspProviderProperties.setAttribute("defaultContentPath", SrcFeatureAlternateUrl.getFilePath(this.fRootWspContents));
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
            try {
                this.fWspProviderProperties.setAttribute("defaultGenPath", SrcFeatureAlternateUrl.getFilePath(this.fRootWspGenerations));
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
        }
    }

    public void setWspProviderProperties(Element pWspProviderProperties) {
        this.fWspProviderProperties = pWspProviderProperties;
        this.xOverrideWspProvProps();
    }

    @Override
    public void addWspDefListener(IWspDefListener pListener, int pOrder) {
        this.fWspDefEventManager.addWspDefListener(pListener, pOrder);
    }

    @Override
    public int removeWspDefListener(IWspDefListener pListener, int pOrder) {
        return this.fWspDefEventManager.removeWspDefListener(pListener, pOrder);
    }

    public ISrcNode getRootWspContents() {
        return this.fRootWspContents;
    }

    public void setRootWspContents(ISrcNode pRootWspContents) {
        this.fRootWspContents = pRootWspContents;
    }

    public ISrcNode getRootWspGenerations() {
        return this.fRootWspGenerations;
    }

    public void setRootWspGenerations(ISrcNode pRootWspGenerations) {
        this.fRootWspGenerations = pRootWspGenerations;
    }

    public ISrcNode getInternalData() {
        return this.fInternalData;
    }

    public void setInternalData(ISrcNode pInternalData) {
        this.fInternalData = pInternalData;
    }

    public String getWspMetaPath() {
        return this.fWspMetaPath;
    }

    public void setWspMetaPath(String pWspMetaPath) {
        this.fWspMetaPath = pWspMetaPath;
    }

    public synchronized boolean deleteWsp(String pCode, boolean pDropContent, boolean pDropGenerations) throws Exception {
        FsWspDefinition vWspDef = (FsWspDefinition)this.getWspDefinition(pCode);
        if (vWspDef != null) {
            this.removeWspDef(vWspDef);
            this.saveWspList();
            try {
                String vGen;
                String vContent = SrcFeatureAlternateUrl.getFilePath(vWspDef.getSrcRootContent());
                String string = vGen = vWspDef.getSrcRootGen() != null ? SrcFeatureAlternateUrl.getFilePath(vWspDef.getSrcRootGen()) : null;
                if (pDropContent) {
                    vWspDef.getSrcRootContent().removeSrc();
                }
                if (pDropGenerations) {
                    vWspDef.getSrcRootGen().removeSrc();
                }
                if (pDropContent && pDropGenerations && vGen != null && vContent != null) {
                    String[] vCh;
                    File vParent = new File(vContent).getParentFile();
                    if (new File(vGen).getParentFile().equals(vParent) && ((vCh = vParent.list()) == null || vCh.length == 0)) {
                        vParent.delete();
                    }
                }
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
            this.fWspDefEventManager.dispatchEvent(new WspDefEvent(WspDefEvent.TYPE_DELETED, vWspDef));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WspType lookForExistingWspType(IRepository pRepos, String pWspCode, String pPathContent) throws Exception {
        ISrcNode vWspMetaSource;
        WspType vWspType = null;
        if (pPathContent == null || pPathContent.length() == 0) {
            ISrcNode vRootWspContent = this.buildDefaultWspRootContent(pWspCode);
            String vRootContent = SrcFeatureAlternateUrl.getFilePath(vRootWspContent);
            vWspMetaSource = vRootWspContent.findNodeChild(this.fWspMetaPath);
        } else {
            String vRootContent = pPathContent;
            vWspMetaSource = FsMiniFactory.newNodeFromPath(vRootContent, true).findNodeChild(this.fWspMetaPath);
        }
        if (vWspMetaSource.getContentStatus() == 1) {
            XMLReader vReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
            try {
                WspTypeContentHandler vHandler = new WspTypeContentHandler(pRepos.getResMgr());
                vHandler.initSaxHandlerForRoot(vReader);
                vReader.parse(new InputSource(vWspMetaSource.newInputStream(false)));
                vWspType = vHandler.getWspType();
            }
            catch (Exception e) {
                LogMgr.publishException(e);
            }
            finally {
                HPoolXmlReader.hGet().hFreeXmlReader(vReader);
            }
        }
        return vWspType;
    }

    @Override
    public void setRepository(IRepository pRepos) {
        this.fIsServerMode = pRepos.isServerMode();
    }

    protected void initProvider() throws Exception {
        ISrcContent vWspLitSrc = this.getWspListSrc();
        if (vWspLitSrc.getContentStatus() == 1) {
            XMLReader vReader = HPoolXmlReader.hGet().hGetXmlReader(true, false);
            try {
                WspListDefContentHandler vContentHandler = new WspListDefContentHandler(this);
                vContentHandler.initSaxHandlerForRoot(vReader);
                vReader.parse(new InputSource(vWspLitSrc.newInputStream(false)));
            }
            catch (Exception e) {
                HPoolXmlReader.hGet().hFreeXmlReader(vReader);
                LogMgr.publishException((Throwable)e, "Loading wspList from the provider failed : %s", vWspLitSrc.toString());
            }
        }
    }

    protected ISrcContent getWspListSrc() throws Exception {
        return SrcFeaturePaths.findContentByPath(this.fInternalData, this.fWspListFilePath, false);
    }

    protected synchronized void appendWspDef(FsWspDefinition pWspDef) {
        this.fListWspDef.add(pWspDef);
        this.fListWspDefFrozen = null;
    }

    protected void removeWspDef(FsWspDefinition pWspDef) {
        assert (Thread.holdsLock(this));
        this.fListWspDef.remove(pWspDef);
        this.fListWspDefFrozen = null;
    }

    protected ISrcNode buildDefaultWspRootContent(String pWspCode) throws Exception {
        ISrcNode vParentNode = SrcFeaturePaths.findNodeByPath(this.fRootWspContents, pWspCode, false);
        if (this.fRootWspGenerations == null) {
            vParentNode = SrcFeaturePaths.findNodeByPath(vParentNode, this.fDefaultSourcesPath, false);
        }
        return SrcFeatureRelocate.relocateAsRoot(vParentNode);
    }

    protected ISrcNode buildDefaultWspRootGen(String pWspCode) throws Exception {
        ISrcNode vParentNode;
        if (this.fRootWspGenerations == null) {
            vParentNode = SrcFeaturePaths.findNodeByPath(this.fRootWspContents, pWspCode, false);
            vParentNode = SrcFeaturePaths.findNodeByPath(vParentNode, this.fDefaultGenPath, false);
        } else {
            vParentNode = SrcFeaturePaths.findNodeByPath(this.fRootWspGenerations, pWspCode, false);
        }
        return SrcFeatureRelocate.relocateAsRoot(vParentNode);
    }

    protected ISrcNode buildWspMetaSrc(FsWspDefinition pWspDef) throws Exception {
        return SrcFeaturePaths.findNodeByPath(pWspDef.getSrcRootContent(), this.fWspMetaPath, false);
    }

    protected void saveWspList() throws Exception {
        assert (Thread.holdsLock(this));
        OutputStream vOutput = this.getWspListSrc().newOutputStream(false);
        try {
            XmlWriterAppendable vWriter = new XmlWriterAppendable(new OutputStreamWriter(vOutput, "UTF-8"));
            WspListDefContentHandler.writeWspList(vWriter, this);
            vWriter.close();
        }
        catch (Exception e) {
            vOutput.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FsWspDefinition hCreateWsp(String pCode, Object pFolderContent, Object pFolderGen, InputStream pXmlWspType) throws Exception {
        if (pCode == null || pCode.length() == 0) {
            throw LogMgr.newException("WspCode undefined.", new String[0]);
        }
        FsWspDefinition vWspDef = new FsWspDefinition(this, pCode);
        FsWspProvider fsWspProvider = this;
        synchronized (fsWspProvider) {
            FsBasicSystem vCustomFs;
            if (this.getWspDefinition(pCode) != null) {
                return null;
            }
            if (pFolderContent != null) {
                if (pFolderContent instanceof ISrcSystem) {
                    vWspDef.fSrcSystemContent = (ISrcSystem)pFolderContent;
                    vWspDef.fSrcSystemContent.setOwner(vWspDef);
                } else {
                    vCustomFs = new FsBasicSystem(vWspDef);
                    vCustomFs.initRoot(pFolderContent.toString());
                    vWspDef.fSrcSystemContent = vCustomFs;
                }
                vWspDef.fSrcRootContent = vWspDef.fSrcSystemContent.getStartSrcNode();
            }
            if (pFolderGen != null) {
                if (pFolderGen instanceof ISrcSystem) {
                    vWspDef.fSrcSystemGen = (ISrcSystem)pFolderGen;
                    vWspDef.fSrcSystemGen.setOwner(vWspDef);
                } else {
                    vCustomFs = new FsBasicSystem(vWspDef);
                    vCustomFs.initRoot(pFolderGen.toString());
                    vWspDef.fSrcSystemGen = vCustomFs;
                }
                vWspDef.fSrcRootGen = vWspDef.fSrcSystemGen.getStartSrcNode();
            }
            if (vWspDef.fSrcRootContent == null) {
                vWspDef.fSrcRootContent = this.buildDefaultWspRootContent(pCode);
            }
            if (vWspDef.fSrcRootGen == null) {
                vWspDef.fSrcRootGen = this.buildDefaultWspRootGen(pCode);
            }
            vWspDef.writeWspMeta(pXmlWspType);
            this.appendWspDef(vWspDef);
            this.saveWspList();
        }
        this.fWspDefEventManager.dispatchEvent(new WspDefEvent(WspDefEvent.TYPE_NEW, vWspDef));
        return vWspDef;
    }

    public boolean hCheckRightAdminListWsp(IUser pUser) {
        if (pUser.getAccount() == "anonymous") {
            return true;
        }
        try {
            return pUser.isSuperAdmin();
        }
        catch (Exception e) {
            LogMgr.publishException(e);
            return true;
        }
    }
}

