/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.wspfs;

import com.scenari.serializer.simple.IXmlWriter;
import com.scenari.src.system.ISrcSystemLoader;
import com.scenari.src.system.SrcSystemFactory;
import eu.scenari.fw.util.xml.FragmentSaxHandlerBase;
import eu.scenari.wspfs.FsWspDefinition;
import eu.scenari.wspfs.FsWspProvider;
import java.util.List;
import org.xml.sax.Attributes;

public class WspListDefContentHandler
extends FragmentSaxHandlerBase {
    public static final String TAG_WSPLIST = "wspList";
    public static final String TAG_WSP = "wsp";
    public static final String TAG_SRCCONTENT = "srcContent";
    public static final String TAG_SRCGENERATION = "srcGeneration";
    public static final String ATT_XXX_CODE = "code";
    public static final String ATT_XXX_TITLE = "title";
    protected FsWspProvider fWspProvider;
    protected FsWspDefinition fCurrentWspDef = null;
    protected ISrcSystemLoader fCurrentSrcSystemLoader = null;

    public static void writeWspList(IXmlWriter pWriter, FsWspProvider pWspProv) throws Exception {
        pWriter.writeHeaderXml("UTF-8");
        pWriter.writeOpenTag(TAG_WSPLIST);
        List<FsWspDefinition> vList = pWspProv.fListWspDef;
        for (FsWspDefinition vWspDef : vList) {
            pWriter.writeStartTag(TAG_WSP);
            pWriter.writeAttribute(ATT_XXX_CODE, vWspDef.getWspCode());
            pWriter.writeAttribute(ATT_XXX_TITLE, vWspDef.getWspTitle());
            if (vWspDef.fSrcSystemContent != null || vWspDef.fSrcSystemGen != null) {
                pWriter.writeEndOpenTag();
                if (vWspDef.fSrcSystemContent != null) {
                    pWriter.writeOpenTag(TAG_SRCCONTENT);
                    vWspDef.fSrcSystemContent.publishDefinition(pWriter);
                    pWriter.writeCloseTag(TAG_SRCCONTENT);
                }
                if (vWspDef.fSrcSystemGen != null) {
                    pWriter.writeOpenTag(TAG_SRCGENERATION);
                    vWspDef.fSrcSystemGen.publishDefinition(pWriter);
                    pWriter.writeCloseTag(TAG_SRCGENERATION);
                }
                pWriter.writeCloseTag(TAG_WSP);
                continue;
            }
            pWriter.writeEndEmptyTag();
        }
        pWriter.writeCloseTag(TAG_WSPLIST);
    }

    public WspListDefContentHandler(FsWspProvider pWspProvider) {
        this.fWspProvider = pWspProvider;
    }

    protected boolean xStartElement(String pUri, String pLocalName, String pQName, Attributes pAttributes) throws Exception {
        boolean vResult = true;
        if (pLocalName == TAG_WSP) {
            String vTitle;
            String vCode = pAttributes.getValue(ATT_XXX_CODE);
            this.fCurrentWspDef = new FsWspDefinition(this.fWspProvider, vCode);
            this.fWspProvider.appendWspDef(this.fCurrentWspDef);
            this.fCurrentWspDef.fWspTitle = vTitle = pAttributes.getValue(ATT_XXX_TITLE);
        } else if (pLocalName == TAG_SRCCONTENT) {
            this.fCurrentSrcSystemLoader = SrcSystemFactory.newGenericSourceSystemLoader(this.fCurrentWspDef, null);
            this.fCurrentSrcSystemLoader.initSaxHandlerForChildren(this.getXMLReader());
        } else if (pLocalName == TAG_SRCGENERATION) {
            this.fCurrentSrcSystemLoader = SrcSystemFactory.newGenericSourceSystemLoader(this.fCurrentWspDef, null);
            this.fCurrentSrcSystemLoader.initSaxHandlerForChildren(this.getXMLReader());
        } else {
            vResult = false;
        }
        return vResult;
    }

    protected void xEndElement(String pNamespaceURI, String pLocalName, String pQName) throws Exception {
        if (pLocalName == TAG_WSP) {
            if (this.fCurrentWspDef.fSrcRootContent == null) {
                this.fCurrentWspDef.fSrcRootContent = this.fWspProvider.buildDefaultWspRootContent(this.fCurrentWspDef.getWspCode());
            }
            if (this.fCurrentWspDef.fSrcRootGen == null) {
                this.fCurrentWspDef.fSrcRootGen = this.fWspProvider.buildDefaultWspRootGen(this.fCurrentWspDef.getWspCode());
            }
            this.fCurrentWspDef = null;
        } else if (pLocalName == TAG_SRCCONTENT) {
            this.fCurrentWspDef.fSrcSystemContent = this.fCurrentSrcSystemLoader.getSrcSystem();
            this.fCurrentWspDef.fSrcRootContent = this.fCurrentWspDef.fSrcSystemContent.getStartSrcNode();
            this.fCurrentSrcSystemLoader = null;
        } else if (pLocalName == TAG_SRCGENERATION) {
            this.fCurrentWspDef.fSrcSystemGen = this.fCurrentSrcSystemLoader.getSrcSystem();
            this.fCurrentWspDef.fSrcRootGen = this.fCurrentWspDef.fSrcSystemGen.getStartSrcNode();
            this.fCurrentSrcSystemLoader = null;
        }
    }
}

