/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.optimistic;

/**
 * The default implementation of a DataVersion, uses a <code>long</code> to
 * compare versions.
 * This class is immutable.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani (manik@jboss.org)</a>
 */
public class DefaultDataVersion implements DataVersion
{

    /**
     * Version zero.
     * Assign this as the first version to your data.
     */
    public static final DataVersion ZERO = new DefaultDataVersion(0L);

    /**
     * Version one.
     */
    private static final DataVersion ONE = new DefaultDataVersion(1L);

    /**
     * Version two.
     */
    private static final DataVersion TWO = new DefaultDataVersion(2L);

    private long version;

    /**
     * Constructs with version 0.
     * @deprecated use {@link #ZERO} constant
     */
    public DefaultDataVersion()
    {
    }

    /**
     * Constructs with a version number.
     */
    public DefaultDataVersion(long version)
    {
        this.version = version;
    }

    /**
     * Returns a new DataVersion with a newer version number.
     */
    public DataVersion increment()
    {
        if (this == ZERO)
            return ONE;
        if (this == ONE)
            return TWO;
        return new DefaultDataVersion(version + 1);
    }

    public boolean newerThan(DataVersion other)
    {
        if (other instanceof DefaultDataVersion)
        {
            DefaultDataVersion dvOther = (DefaultDataVersion) other;
            return version > dvOther.version;
        }
        return false;
    }

    public String toString()
    {
        return "Ver="+version;
    }

    public boolean equals(Object other)
    {
        if (other instanceof DefaultDataVersion)
        {
            return version == ((DefaultDataVersion) other).version;
        }
        return false;
    }

    public int hashCode()
    {
        return (int)version;
    }

}
