/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.Histogram;
import it.tidalwave.image.render.PreviewSettings;
import java.awt.RenderingHints;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.logging.Logger;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.HistogramDescriptor;

public class HistogramJAI
extends Histogram {
    private static final String CLASS = HistogramJAI.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private RenderedImage renderedImage;
    private javax.media.jai.Histogram delegate;
    private double[] max;
    private double[] min;

    HistogramJAI(RenderedImage renderedImage) {
        super((Object)renderedImage);
        this.renderedImage = renderedImage;
        this.compute();
    }

    public int[] getFrequencies(int band) {
        this.validateBand(band);
        this.ensureDataComputed();
        return this.delegate.getBins(band);
    }

    public int getMin(int band) {
        this.validateBand(band);
        this.ensureDataComputed();
        return (int)this.min[band];
    }

    public int getMax(int band) {
        this.validateBand(band);
        this.ensureDataComputed();
        return (int)this.max[band];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDataComputed() {
        HistogramJAI histogramJAI = this;
        synchronized (histogramJAI) {
            if (this.delegate == null) {
                this.compute();
            }
        }
    }

    private void compute() {
        SampleModel sampleModel = this.renderedImage.getSampleModel();
        this.bandCount = sampleModel.getNumBands();
        int bits = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        ROI roi = null;
        int[] bins = new int[this.bandCount];
        this.min = new double[this.bandCount];
        this.max = new double[this.bandCount];
        int maxxx = 1 << bits;
        for (int i = 0; i < this.bandCount; ++i) {
            bins[i] = maxxx;
            this.min[i] = 0.0;
            this.max[i] = maxxx;
        }
        RenderingHints renderingHints = null;
        Integer xPeriod = new Integer(1);
        Integer yPeriod = new Integer(1);
        RenderedOp op = HistogramDescriptor.create((RenderedImage)this.renderedImage, roi, (Integer)xPeriod, (Integer)yPeriod, (int[])bins, (double[])this.min, (double[])this.max, renderingHints);
        this.delegate = (javax.media.jai.Histogram)op.getProperty("histogram");
    }

    public Histogram getPreview(PreviewSettings previewSetting) {
        throw new RuntimeException("NOT IMPLEMENTED YET!");
    }
}

