/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.jai.JAIUtils;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.PadPeriodicPlanarOp;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PadPeriodicPlanarJAIOp
extends OperationImplementation<PadPeriodicPlanarOp, PlanarImage> {
    private static final String CLASS = PadPeriodicPlanarJAIOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected PlanarImage execute(PadPeriodicPlanarOp operation, PlanarImage planarImage) {
        ParameterBlock pb = new ParameterBlock();
        int oldWidth = planarImage.getData().getWidth();
        int oldHeight = planarImage.getData().getHeight();
        int newWidth = JAIUtils.closestPower2Size(oldWidth);
        int newHeight = JAIUtils.closestPower2Size(oldHeight);
        int padx = (newWidth - oldWidth) / 2;
        int pady = (newHeight - oldHeight) / 2;
        pb.addSource(planarImage);
        pb.add((float)padx);
        pb.add((float)pady);
        RenderedOp trans = JAI.create((String)"translate", (ParameterBlock)pb);
        pb = new ParameterBlock();
        pb.addSource(trans);
        pb.add(padx);
        pb.add(padx);
        pb.add(pady);
        pb.add(pady);
        pb.add(BorderExtender.createInstance((int)3));
        planarImage = JAI.create((String)"border", (ParameterBlock)pb);
        JAIUtils.logImage((Logger)logger, (String)">>>> PadPeriodicPlanarOp returning", (RenderedImage)planarImage);
        return planarImage;
    }
}

