/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.PaintOp;
import it.tidalwave.image.render.PreviewSettings;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaintJAIOp
extends OperationImplementation<PaintOp, PlanarImage> {
    private static final String CLASS = PaintJAIOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected PlanarImage execute(PaintOp operation, PlanarImage planarImage) {
        int x = operation.getX();
        int y = operation.getY();
        int w = operation.getW();
        int h = operation.getH();
        Graphics2D g2 = operation.getGraphics2D();
        PreviewSettings previewSettings = operation.getPreviewSettings();
        ImageObserver imageObserver = operation.getImageObserver();
        if (w != 0) {
            double scaleX = (double)w / (double)planarImage.getWidth();
            double scaleY = (double)h / (double)planarImage.getHeight();
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            xform.concatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
            g2.drawRenderedImage((RenderedImage)planarImage, xform);
        } else {
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            g2.drawRenderedImage((RenderedImage)planarImage, xform);
        }
        return planarImage;
    }
}

