/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.jai.JAIUtils;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.RotateQuadrantOp;
import java.awt.image.RenderedImage;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.TransposeDescriptor;
import javax.media.jai.operator.TransposeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateQuadrantJAIOp
extends OperationImplementation<RotateQuadrantOp, PlanarImage> {
    private static final String CLASS = RotateQuadrantJAIOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected PlanarImage execute(RotateQuadrantOp operation, PlanarImage planarImage) {
        int degrees = operation.getDegrees();
        logger.fine("rotateQuadrant(" + degrees + ") - " + planarImage.getSampleModel());
        if (degrees != 0) {
            TransposeType transposeType = null;
            if (degrees == 90) {
                transposeType = TransposeDescriptor.ROTATE_90;
            } else if (degrees == 180) {
                transposeType = TransposeDescriptor.ROTATE_180;
            } else if (degrees == 270) {
                transposeType = TransposeDescriptor.ROTATE_270;
            } else {
                throw new IllegalArgumentException("degrees: " + degrees);
            }
            planarImage = TransposeDescriptor.create((RenderedImage)planarImage, (TransposeType)transposeType, null);
            JAIUtils.logImage((Logger)logger, (String)">>>>   rotateQuadrant() returning", (RenderedImage)planarImage);
        }
        return planarImage;
    }
}

