/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.jai;

import it.tidalwave.image.Quality;
import it.tidalwave.image.jai.JAIUtils;
import it.tidalwave.image.jai.ScaleJAIOp;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.SizeOp;
import java.awt.RenderingHints;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.KernelJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.ConvolveDescriptor;
import javax.media.jai.operator.ScaleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeJAIOp
extends OperationImplementation<SizeOp, PlanarImage> {
    private static final String CLASS = ScaleJAIOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected PlanarImage execute(SizeOp operation, PlanarImage planarImage) {
        RenderingHints hints = null;
        float scale = (float)operation.getScale();
        Quality quality = Quality.BEST;
        PlanarImage result = planarImage;
        if ((double)scale > 1.0) {
            result = JAIUtils.jaiMagnification(planarImage, scale, quality, hints);
        } else if ((double)scale < 1.0) {
            float ZERO = 0.0f;
            if ((double)scale > 0.5) {
                Interpolation interpolation = Interpolation.getInstance((int)1);
                logger.finer(">>>>>>>> Scale(" + scale + ", " + interpolation + ")");
                result = ScaleDescriptor.create((RenderedImage)planarImage, (Float)Float.valueOf(scale), (Float)Float.valueOf(scale), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)interpolation, hints);
            } else {
                Kernel averagingKernel = JAIUtils.getAveragingKernel((int)((int)Math.round(1.0 / (double)scale)));
                logger.finer(">>>>>>>> Convolve() with averaging kernel: " + averagingKernel);
                result = ConvolveDescriptor.create((RenderedImage)planarImage, (KernelJAI)new KernelJAI(averagingKernel), hints);
                Interpolation interpolation = Interpolation.getInstance((int)0);
                logger.finer(">>>>>>>> Scale(" + scale + ", " + interpolation + ")");
                result = ScaleDescriptor.create((RenderedImage)result, (Float)Float.valueOf(scale), (Float)Float.valueOf(scale), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)interpolation, hints);
            }
        }
        JAIUtils.logImage((Logger)logger, (String)">>>> SizeJAIOp returning", (RenderedImage)result);
        return result;
    }
}

