/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAcl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAllowableActions;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomBase;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.HtmlDoc;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.RepositoryWorkspace;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.ServiceDoc;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AtomPubParser {
    public static final String LINK_REL_CONTENT = "@@content@@";
    private final InputStream stream;
    private AtomBase parseResult;

    public AtomPubParser(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("No stream.");
        }
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws XmlPullParserException {
        XmlPullParser parser = XMLUtils.createParser(this.stream);
        try {
            do {
                int event;
                if ((event = parser.getEventType()) != 2) continue;
                QName name = new QName(parser.getNamespace(), parser.getName());
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if ("feed".equals(name.getLocalPart())) {
                        this.parseResult = this.parseFeed(parser);
                    } else {
                        if (!"entry".equals(name.getLocalPart())) continue;
                        this.parseResult = this.parseEntry(parser);
                    }
                } else if ("http://docs.oasis-open.org/ns/cmis/core/200908/".equals(name.getNamespaceURI())) {
                    if ("allowableActions".equals(name.getLocalPart())) {
                        this.parseResult = AtomPubParser.parseAllowableActions(parser);
                    } else {
                        if (!"acl".equals(name.getLocalPart())) continue;
                        this.parseResult = AtomPubParser.parseACL(parser);
                    }
                } else if ("http://www.w3.org/2007/app".equals(name.getNamespaceURI())) {
                    if (!"service".equals(name.getLocalPart())) continue;
                    this.parseResult = AtomPubParser.parseServiceDoc(parser);
                } else {
                    if (!"html".equalsIgnoreCase(name.getLocalPart())) continue;
                    this.parseResult = new HtmlDoc();
                }
                break;
            } while (XMLUtils.next(parser));
        }
        finally {
            IOUtils.consumeAndClose(this.stream);
        }
    }

    public AtomBase getResults() {
        return this.parseResult;
    }

    private static ServiceDoc parseServiceDoc(XmlPullParser parser) throws XmlPullParserException {
        ServiceDoc result = new ServiceDoc();
        XMLUtils.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 2) {
                QName name = new QName(parser.getNamespace(), parser.getName());
                if ("http://www.w3.org/2007/app".equals(name.getNamespaceURI())) {
                    if ("workspace".equals(name.getLocalPart())) {
                        result.addWorkspace(AtomPubParser.parseWorkspace(parser));
                        continue;
                    }
                    XMLUtils.skip(parser);
                    continue;
                }
                XMLUtils.skip(parser);
                continue;
            }
            if (event == 3 || !XMLUtils.next(parser)) break;
        }
        return result;
    }

    private static RepositoryWorkspace parseWorkspace(XmlPullParser parser) throws XmlPullParserException {
        RepositoryWorkspace workspace = new RepositoryWorkspace();
        XMLUtils.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 2) {
                AtomElement element = AtomPubParser.parseWorkspaceElement(parser);
                if (element != null && element.getObject() instanceof RepositoryInfo) {
                    workspace.setId(((RepositoryInfo)element.getObject()).getId());
                }
                workspace.addElement(element);
                continue;
            }
            if (event == 3 || !XMLUtils.next(parser)) break;
        }
        XMLUtils.next(parser);
        return workspace;
    }

    private AtomFeed parseFeed(XmlPullParser parser) throws XmlPullParserException {
        AtomFeed result = new AtomFeed();
        XMLUtils.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 2) {
                QName name = new QName(parser.getNamespace(), parser.getName());
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if ("link".equals(name.getLocalPart())) {
                        result.addElement(AtomPubParser.parseLink(parser));
                        continue;
                    }
                    if ("entry".equals(name.getLocalPart())) {
                        result.addEntry(this.parseEntry(parser));
                        continue;
                    }
                    XMLUtils.skip(parser);
                    continue;
                }
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
                    if ("numItems".equals(name.getLocalPart())) {
                        result.addElement(AtomPubParser.parseBigInteger(parser));
                        continue;
                    }
                    XMLUtils.skip(parser);
                    continue;
                }
                XMLUtils.skip(parser);
                continue;
            }
            if (event == 3 || !XMLUtils.next(parser)) break;
        }
        XMLUtils.next(parser);
        return result;
    }

    private AtomEntry parseEntry(XmlPullParser parser) throws XmlPullParserException {
        AtomEntry result = new AtomEntry();
        XMLUtils.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 2) {
                AtomElement element = this.parseElement(parser);
                if (element == null) continue;
                result.addElement(element);
                if (element.getObject() instanceof ObjectData) {
                    result.setId(((ObjectData)element.getObject()).getId());
                    continue;
                }
                if (!(element.getObject() instanceof TypeDefinition)) continue;
                result.setId(((TypeDefinition)element.getObject()).getId());
                continue;
            }
            if (event == 3 || !XMLUtils.next(parser)) break;
        }
        XMLUtils.next(parser);
        return result;
    }

    private static AtomAllowableActions parseAllowableActions(XmlPullParser parser) throws XmlPullParserException {
        return new AtomAllowableActions(XMLConverter.convertAllowableActions(parser));
    }

    private static AtomAcl parseACL(XmlPullParser parser) throws XmlPullParserException {
        return new AtomAcl(XMLConverter.convertAcl(parser));
    }

    private AtomElement parseElement(XmlPullParser parser) throws XmlPullParserException {
        QName name = new QName(parser.getNamespace(), parser.getName());
        if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
            if ("object".equals(name.getLocalPart())) {
                return new AtomElement(name, XMLConverter.convertObject(parser));
            }
            if ("pathSegment".equals(name.getLocalPart()) || "relativePathSegment".equals(name.getLocalPart())) {
                return AtomPubParser.parseText(parser);
            }
            if ("type".equals(name.getLocalPart())) {
                return new AtomElement(name, XMLConverter.convertTypeDefinition(parser));
            }
            if ("children".equals(name.getLocalPart())) {
                return this.parseChildren(parser);
            }
        } else if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
            if ("link".equals(name.getLocalPart())) {
                return AtomPubParser.parseLink(parser);
            }
            if ("content".equals(name.getLocalPart())) {
                return AtomPubParser.parseAtomContentSrc(parser);
            }
        }
        XMLUtils.skip(parser);
        return null;
    }

    private AtomElement parseChildren(XmlPullParser parser) throws XmlPullParserException {
        AtomElement result = null;
        QName childName = new QName(parser.getNamespace(), parser.getName());
        XMLUtils.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 2) {
                QName name = new QName(parser.getNamespace(), parser.getName());
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if ("feed".equals(name.getLocalPart())) {
                        result = new AtomElement(childName, this.parseFeed(parser));
                        continue;
                    }
                    XMLUtils.skip(parser);
                    continue;
                }
                XMLUtils.skip(parser);
                continue;
            }
            if (event == 3 || !XMLUtils.next(parser)) break;
        }
        XMLUtils.next(parser);
        return result;
    }

    private static AtomElement parseWorkspaceElement(XmlPullParser parser) throws XmlPullParserException {
        QName name = new QName(parser.getNamespace(), parser.getName());
        if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
            if ("repositoryInfo".equals(name.getLocalPart())) {
                return new AtomElement(name, XMLConverter.convertRepositoryInfo(parser));
            }
            if ("uritemplate".equals(name.getLocalPart())) {
                return AtomPubParser.parseTemplate(parser);
            }
        } else if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
            if ("link".equals(name.getLocalPart())) {
                return AtomPubParser.parseLink(parser);
            }
        } else if ("http://www.w3.org/2007/app".equals(name.getNamespaceURI()) && "collection".equals(name.getLocalPart())) {
            return AtomPubParser.parseCollection(parser);
        }
        XMLUtils.skip(parser);
        return null;
    }

    private static AtomElement parseCollection(XmlPullParser parser) throws XmlPullParserException {
        QName name = new QName(parser.getNamespace(), parser.getName());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("href", parser.getAttributeValue(null, "href"));
        XMLUtils.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 2) {
                QName tagName = new QName(parser.getNamespace(), parser.getName());
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(tagName.getNamespaceURI()) && "collectionType".equals(tagName.getLocalPart())) {
                    result.put("collectionType", XMLUtils.readText(parser, 102400));
                    continue;
                }
                XMLUtils.skip(parser);
                continue;
            }
            if (event == 3 || !XMLUtils.next(parser)) break;
        }
        XMLUtils.next(parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseTemplate(XmlPullParser parser) throws XmlPullParserException {
        QName name = new QName(parser.getNamespace(), parser.getName());
        HashMap<String, String> result = new HashMap<String, String>();
        XMLUtils.next(parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 2) {
                QName tagName = new QName(parser.getNamespace(), parser.getName());
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(tagName.getNamespaceURI())) {
                    if ("template".equals(tagName.getLocalPart())) {
                        result.put("template", XMLUtils.readText(parser, 102400));
                        continue;
                    }
                    if ("type".equals(tagName.getLocalPart())) {
                        result.put("type", XMLUtils.readText(parser, 102400));
                        continue;
                    }
                    XMLUtils.skip(parser);
                    continue;
                }
                XMLUtils.skip(parser);
                continue;
            }
            if (event == 3 || !XMLUtils.next(parser)) break;
        }
        XMLUtils.next(parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseLink(XmlPullParser parser) throws XmlPullParserException {
        QName name = new QName(parser.getNamespace(), parser.getName());
        AtomLink result = new AtomLink();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if ("rel".equals(parser.getAttributeName(i))) {
                result.setRel(parser.getAttributeValue(i));
                continue;
            }
            if ("href".equals(parser.getAttributeName(i))) {
                result.setHref(parser.getAttributeValue(i));
                continue;
            }
            if (!"type".equals(parser.getAttributeName(i))) continue;
            result.setType(parser.getAttributeValue(i));
        }
        XMLUtils.skip(parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseAtomContentSrc(XmlPullParser parser) throws XmlPullParserException {
        QName name = new QName(parser.getNamespace(), parser.getName());
        AtomLink result = new AtomLink();
        result.setRel(LINK_REL_CONTENT);
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!"src".equals(parser.getAttributeName(i))) continue;
            result.setHref(parser.getAttributeValue(i));
        }
        XMLUtils.skip(parser);
        return new AtomElement(name, result);
    }

    private static AtomElement parseText(XmlPullParser parser) throws XmlPullParserException {
        QName name = new QName(parser.getNamespace(), parser.getName());
        return new AtomElement(name, XMLUtils.readText(parser, 102400));
    }

    private static AtomElement parseBigInteger(XmlPullParser parser) throws XmlPullParserException {
        QName name = new QName(parser.getNamespace(), parser.getName());
        return new AtomElement(name, new BigInteger(XMLUtils.readText(parser, 102400)));
    }
}

