/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AtomEntryWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAllowableActions;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateObjectIdAndChangeTokenImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PartialContentStreamImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;

public class ObjectServiceImpl
extends AbstractAtomPubService
implements ObjectService {
    public ObjectServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    @Override
    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        ObjectServiceImpl.checkCreateProperties(properties);
        String link = null;
        if (folderId == null) {
            link = this.loadCollection(repositoryId, "unfiled");
            if (link == null) {
                throw new CmisObjectNotFoundException("Unknown repository or unfiling not supported!");
            }
        } else {
            link = this.loadLink(repositoryId, folderId, "down", "application/atom+xml;type=feed");
            if (link == null) {
                this.throwLinkException(repositoryId, folderId, "down", "application/atom+xml;type=feed");
            }
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("versioningState", (Object)versioningState);
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createObject(properties, null, policies), this.getCmisVersion(repositoryId), contentStream);
        Response resp = this.post(url, "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        this.handleAclModifications(repositoryId, entry, addAces, removeAces);
        return entry.getId();
    }

    @Override
    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        throw new CmisNotSupportedException("createDocumentFromSource is not supported by the AtomPub binding!");
    }

    @Override
    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        ObjectServiceImpl.checkCreateProperties(properties);
        String link = this.loadLink(repositoryId, folderId, "down", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, folderId, "down", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createObject(properties, null, policies), this.getCmisVersion(repositoryId));
        Response resp = this.post(url, "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        this.handleAclModifications(repositoryId, entry, addAces, removeAces);
        return entry.getId();
    }

    @Override
    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        ObjectServiceImpl.checkCreateProperties(properties);
        String link = null;
        if (folderId == null) {
            link = this.loadCollection(repositoryId, "unfiled");
            if (link == null) {
                throw new CmisObjectNotFoundException("Unknown repository or unfiling not supported!");
            }
        } else {
            link = this.loadLink(repositoryId, folderId, "down", "application/atom+xml;type=feed");
            if (link == null) {
                this.throwLinkException(repositoryId, folderId, "down", "application/atom+xml;type=feed");
            }
        }
        UrlBuilder url = new UrlBuilder(link);
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createObject(properties, null, policies), this.getCmisVersion(repositoryId));
        Response resp = this.post(url, "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        this.handleAclModifications(repositoryId, entry, addAces, removeAces);
        return entry.getId();
    }

    @Override
    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        ObjectServiceImpl.checkCreateProperties(properties);
        String link = null;
        if (folderId == null) {
            link = this.loadCollection(repositoryId, "unfiled");
            if (link == null) {
                throw new CmisObjectNotFoundException("Unknown repository or unfiling not supported!");
            }
        } else {
            link = this.loadLink(repositoryId, folderId, "down", "application/atom+xml;type=feed");
            if (link == null) {
                this.throwLinkException(repositoryId, folderId, "down", "application/atom+xml;type=feed");
            }
        }
        UrlBuilder url = new UrlBuilder(link);
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createObject(properties, null, policies), this.getCmisVersion(repositoryId));
        Response resp = this.post(url, "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        this.handleAclModifications(repositoryId, entry, addAces, removeAces);
        return entry.getId();
    }

    @Override
    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        ObjectServiceImpl.checkCreateProperties(properties);
        PropertyData<?> sourceIdProperty = properties.getProperties().get("cmis:sourceId");
        if (!(sourceIdProperty instanceof PropertyId)) {
            throw new CmisInvalidArgumentException("Source Id is not set!");
        }
        String sourceId = (String)((PropertyId)sourceIdProperty).getFirstValue();
        if (sourceId == null) {
            throw new CmisInvalidArgumentException("Source Id is not set!");
        }
        String link = this.loadLink(repositoryId, sourceId, "http://docs.oasis-open.org/ns/cmis/link/200908/relationships", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, sourceId, "http://docs.oasis-open.org/ns/cmis/link/200908/relationships", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createObject(properties, null, policies), this.getCmisVersion(repositoryId));
        Response resp = this.post(url, "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        this.handleAclModifications(repositoryId, entry, addAces, removeAces);
        return entry.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        AtomEntryWriter entryWriter;
        Response resp;
        AtomEntry entry;
        if (objectId == null || objectId.getValue() == null || objectId.getValue().length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        String link = this.loadLink(repositoryId, objectId.getValue(), "self", "application/atom+xml;type=entry");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId.getValue(), "self", "application/atom+xml;type=entry");
        }
        UrlBuilder url = new UrlBuilder(link);
        if (changeToken != null) {
            url.addParameter("changeToken", changeToken.getValue());
        }
        if ((entry = this.parse((resp = this.put(url, "application/atom+xml;type=entry", new Output(entryWriter = new AtomEntryWriter(this.createObject(properties, changeToken == null ? null : changeToken.getValue(), null), this.getCmisVersion(repositoryId))){
            final /* synthetic */ AtomEntryWriter val$entryWriter;
            {
                this.val$entryWriter = atomEntryWriter;
            }

            @Override
            public void write(OutputStream out) throws IOException {
                this.val$entryWriter.write(out);
            }
        })).getStream(), AtomEntry.class)).getId() == null) {
            throw new CmisConnectionException("Received Atom entry is not a CMIS entry!");
        }
        objectId.setValue(entry.getId());
        if (changeToken != null) {
            changeToken.setValue(null);
        }
        this.lockLinks();
        try {
            this.removeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                PropertyData<?> changeTokenStr;
                ObjectData object;
                if (element.getObject() instanceof AtomLink) {
                    this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                    continue;
                }
                if (!(element.getObject() instanceof ObjectData) || changeToken == null || (object = (ObjectData)element.getObject()).getProperties() == null || !((changeTokenStr = object.getProperties().getProperties().get("cmis:changeToken")) instanceof PropertyString)) continue;
                changeToken.setValue((String)((PropertyString)changeTokenStr).getFirstValue());
            }
        }
        finally {
            this.unlockLinks();
        }
    }

    @Override
    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        String link = this.loadCollection(repositoryId, "update");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or bulk update properties is not supported!");
        }
        BulkUpdateImpl bulkUpdate = new BulkUpdateImpl();
        bulkUpdate.setObjectIdAndChangeToken(objectIdAndChangeToken);
        bulkUpdate.setProperties(properties);
        bulkUpdate.setAddSecondaryTypeIds(addSecondaryTypeIds);
        bulkUpdate.setRemoveSecondaryTypeIds(removeSecondaryTypeIds);
        final AtomEntryWriter entryWriter = new AtomEntryWriter(bulkUpdate);
        Response resp = this.post(new UrlBuilder(link), "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                entryWriter.write(out);
            }
        });
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        ArrayList<BulkUpdateObjectIdAndChangeToken> result = new ArrayList<BulkUpdateObjectIdAndChangeToken>(feed.getEntries().size());
        if (!feed.getEntries().isEmpty()) {
            for (AtomEntry entry : feed.getEntries()) {
                for (AtomElement element : entry.getElements()) {
                    ObjectData object;
                    String id;
                    if (!(element.getObject() instanceof ObjectData) || (id = (object = (ObjectData)element.getObject()).getId()) == null) continue;
                    String changeToken = null;
                    PropertyData<?> changeTokenProp = object.getProperties().getProperties().get("cmis:changeToken");
                    if (changeTokenProp instanceof PropertyString) {
                        changeToken = (String)((PropertyString)changeTokenProp).getFirstValue();
                    }
                    result.add(new BulkUpdateObjectIdAndChangeTokenImpl(id, changeToken));
                }
            }
        }
        return result;
    }

    @Override
    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        String link = this.loadLink(repositoryId, objectId, "self", "application/atom+xml;type=entry");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "self", "application/atom+xml;type=entry");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("allVersions", allVersions);
        this.delete(url);
    }

    @Override
    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        String link = this.loadLink(repositoryId, folderId, "down", null);
        String childrenLink = null;
        if (link != null) {
            childrenLink = link;
            link = null;
        } else {
            link = this.loadLink(repositoryId, folderId, "down", "application/cmistree+xml");
        }
        if (link == null) {
            link = this.loadLink(repositoryId, folderId, "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/cmistree+xml");
        }
        if (link == null) {
            link = this.loadLink(repositoryId, folderId, "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/atom+xml;type=feed");
        }
        if (link == null) {
            link = childrenLink;
        }
        if (link == null) {
            this.throwLinkException(repositoryId, folderId, "down", "application/cmistree+xml");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("allVersions", allVersions);
        url.addParameter("unfileObjects", (Object)unfileObjects);
        url.addParameter("continueOnFailure", continueOnFailure);
        Response resp = this.getHttpInvoker().invokeDELETE(url, this.getSession());
        if (resp.getResponseCode() == 200 || resp.getResponseCode() == 202 || resp.getResponseCode() == 204) {
            return new FailedToDeleteDataImpl();
        }
        if (resp.getResponseCode() == 500 && (link = this.loadLink(repositoryId, folderId, "down", "application/atom+xml;type=feed")) != null) {
            url = new UrlBuilder(link);
            url.addParameter("filter", "cmis:objectId");
            url.addParameter("includeAllowableActions", false);
            url.addParameter("includeRelationships", (Object)IncludeRelationships.NONE);
            url.addParameter("renditionFilter", "cmis:none");
            url.addParameter("includePathSegment", false);
            url.addParameter("maxItems", 1000);
            url.addParameter("skipCount", 0);
            resp = this.read(url);
            AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
            FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
            ArrayList<String> ids = new ArrayList<String>(feed.getEntries().size());
            result.setIds(ids);
            for (AtomEntry entry : feed.getEntries()) {
                ids.add(entry.getId());
            }
            return result;
        }
        throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
    }

    @Override
    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        String link = this.loadLink(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/allowableactions", "application/cmisallowableactions+xml");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/allowableactions", "application/cmisallowableactions+xml");
        }
        UrlBuilder url = new UrlBuilder(link);
        Response resp = this.read(url);
        AtomAllowableActions allowableActions = this.parse(resp.getStream(), AtomAllowableActions.class);
        return allowableActions.getAllowableActions();
    }

    @Override
    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        String link = null;
        if (streamId != null && (link = this.loadLink(repositoryId, objectId, "alternate", streamId)) != null) {
            streamId = null;
        }
        if (link == null) {
            link = this.loadLink(repositoryId, objectId, "@@content@@", null);
        }
        if (link == null) {
            throw new CmisConstraintException("No content stream");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("streamId", streamId);
        Response resp = this.getHttpInvoker().invokeGET(url, this.getSession(), offset, length);
        if (resp.getResponseCode() != 200 && resp.getResponseCode() != 206) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        ContentStreamImpl result = resp.getResponseCode() == 206 ? new PartialContentStreamImpl() : new ContentStreamImpl();
        String filename = null;
        String contentDisposition = resp.getHeader("Content-Disposition");
        if (contentDisposition != null) {
            filename = MimeHelper.decodeContentDispositionFilename(contentDisposition);
        }
        result.setFileName(filename);
        result.setLength(resp.getContentLength());
        result.setMimeType(resp.getContentTypeHeader());
        result.setStream(resp.getStream());
        return result;
    }

    @Override
    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        return this.getObjectInternal(repositoryId, AbstractAtomPubService.IdentifierType.ID, objectId, ReturnVersion.THIS, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeACL, extension);
    }

    @Override
    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        return this.getObjectInternal(repositoryId, AbstractAtomPubService.IdentifierType.PATH, path, ReturnVersion.THIS, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeACL, extension);
    }

    @Override
    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        ObjectData object = this.getObjectInternal(repositoryId, AbstractAtomPubService.IdentifierType.ID, objectId, ReturnVersion.THIS, filter, Boolean.FALSE, IncludeRelationships.NONE, "cmis:none", Boolean.FALSE, Boolean.FALSE, extension);
        return object.getProperties();
    }

    @Override
    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectData object = this.getObjectInternal(repositoryId, AbstractAtomPubService.IdentifierType.ID, objectId, ReturnVersion.THIS, "cmis:objectId", Boolean.FALSE, IncludeRelationships.NONE, renditionFilter, Boolean.FALSE, Boolean.FALSE, extension);
        List<RenditionData> result = object.getRenditions();
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || objectId.getValue().length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        if (targetFolderId == null || targetFolderId.length() == 0 || sourceFolderId == null || sourceFolderId.length() == 0) {
            throw new CmisInvalidArgumentException("Source and target folder must be set!");
        }
        String link = this.loadLink(repositoryId, targetFolderId, "down", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, targetFolderId, "down", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("sourceFolderId", sourceFolderId);
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createIdObject(objectId.getValue()), this.getCmisVersion(repositoryId));
        Response resp = this.post(url, "application/atom+xml;type=entry", new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        objectId.setValue(entry.getId());
    }

    @Override
    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        this.setOrAppendContent(repositoryId, objectId, overwriteFlag, changeToken, contentStream, true, false, extension);
    }

    @Override
    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null) {
            throw new CmisInvalidArgumentException("Object ID must be set!");
        }
        String link = this.loadLink(repositoryId, objectId.getValue(), "edit-media", null);
        if (link == null) {
            this.throwLinkException(repositoryId, objectId.getValue(), "edit-media", null);
        }
        UrlBuilder url = new UrlBuilder(link);
        if (changeToken != null) {
            url.addParameter("changeToken", changeToken.getValue());
        }
        this.delete(url);
        objectId.setValue(null);
        if (changeToken != null) {
            changeToken.setValue(null);
        }
    }

    @Override
    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        this.setOrAppendContent(repositoryId, objectId, null, changeToken, contentStream, isLastChunk, true, extension);
    }

    private static void checkCreateProperties(Properties properties) {
        if (properties == null || properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
        if (!properties.getProperties().containsKey("cmis:objectTypeId")) {
            throw new CmisInvalidArgumentException("Property cmis:objectTypeId must be set!");
        }
        if (properties.getProperties().containsKey("cmis:objectId")) {
            throw new CmisInvalidArgumentException("Property cmis:objectId must not be set!");
        }
    }

    private void handleAclModifications(String repositoryId, AtomEntry entry, Acl addAces, Acl removeAces) {
        Acl newACL;
        if (!this.isAclMergeRequired(addAces, removeAces)) {
            return;
        }
        Acl originalAces = this.getAclInternal(repositoryId, entry.getId(), Boolean.FALSE, null);
        if (originalAces != null && (newACL = this.mergeAcls(originalAces, addAces, removeAces)) != null) {
            this.updateAcl(repositoryId, entry.getId(), newACL, null);
        }
    }

    private void setOrAppendContent(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, boolean append, ExtensionsData extension) {
        Response resp;
        if (objectId == null || objectId.getValue() == null) {
            throw new CmisInvalidArgumentException("Object ID must be set!");
        }
        if (contentStream == null || contentStream.getStream() == null || contentStream.getMimeType() == null) {
            throw new CmisInvalidArgumentException("Content must be set!");
        }
        String link = this.loadLink(repositoryId, objectId.getValue(), "edit-media", null);
        if (link == null) {
            this.throwLinkException(repositoryId, objectId.getValue(), "edit-media", null);
        }
        UrlBuilder url = new UrlBuilder(link);
        if (changeToken != null) {
            url.addParameter("changeToken", changeToken.getValue());
        }
        if (append) {
            url.addParameter("append", Boolean.TRUE);
            url.addParameter("isLastChunk", isLastChunk);
        } else {
            url.addParameter("overwriteFlag", overwriteFlag);
        }
        final InputStream stream = contentStream.getStream();
        Map<String, String> headers = null;
        if (contentStream.getFileName() != null) {
            headers = Collections.singletonMap("Content-Disposition", MimeHelper.encodeContentDisposition("attachment", contentStream.getFileName()));
        }
        if ((resp = this.put(url, contentStream.getMimeType(), headers, new Output(){

            @Override
            public void write(OutputStream out) throws IOException {
                IOUtils.copy(stream, out);
            }
        })).getResponseCode() != 200 && resp.getResponseCode() != 201 && resp.getResponseCode() != 204) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        objectId.setValue(null);
        if (changeToken != null) {
            changeToken.setValue(null);
        }
    }
}

