/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.ClientTypeCacheImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;

public class NavigationServiceImpl
extends AbstractBrowserBindingService
implements NavigationService {
    public NavigationServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    @Override
    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId, "children");
        url.addParameter("filter", filter);
        url.addParameter("orderBy", orderBy);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", renditionFilter);
        url.addParameter("includePathSegment", includePathSegment);
        url.addParameter("maxItems", maxItems);
        url.addParameter("skipCount", skipCount);
        url.addParameter("succinct", this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObjectInFolderList(json, typeCache);
    }

    @Override
    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId, "descendants");
        url.addParameter("depth", depth);
        url.addParameter("filter", filter);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", renditionFilter);
        url.addParameter("includePathSegment", includePathSegment);
        url.addParameter("succinct", this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertDescendants(json, typeCache);
    }

    @Override
    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId, "folderTree");
        url.addParameter("depth", depth);
        url.addParameter("filter", filter);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", renditionFilter);
        url.addParameter("includePathSegment", includePathSegment);
        url.addParameter("succinct", this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertDescendants(json, typeCache);
    }

    @Override
    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "parents");
        url.addParameter("filter", filter);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", renditionFilter);
        url.addParameter("includeRelativePathSegment", includeRelativePathSegment);
        url.addParameter("succinct", this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObjectParents(json, typeCache);
    }

    @Override
    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, folderId, "parent");
        url.addParameter("filter", filter);
        url.addParameter("succinct", this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObject(json, typeCache);
    }

    @Override
    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        UrlBuilder url = folderId != null ? this.getObjectUrl(repositoryId, folderId, "checkedout") : this.getRepositoryUrl(repositoryId, "checkedout");
        url.addParameter("filter", filter);
        url.addParameter("orderBy", orderBy);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", renditionFilter);
        url.addParameter("maxItems", maxItems);
        url.addParameter("skipCount", skipCount);
        url.addParameter("succinct", this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObjectList(json, typeCache, false);
    }
}

