/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.math.BigInteger;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.ClientTypeCacheImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;

public class RelationshipServiceImpl
extends AbstractBrowserBindingService
implements RelationshipService {
    public RelationshipServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    @Override
    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "relationships");
        url.addParameter("includeSubRelationshipTypes", includeSubRelationshipTypes);
        url.addParameter("relationshipDirection", (Object)relationshipDirection);
        url.addParameter("typeId", typeId);
        url.addParameter("filter", filter);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("maxItems", maxItems);
        url.addParameter("skipCount", skipCount);
        url.addParameter("succinct", this.getSuccinctParameter());
        url.addParameter("dateTimeFormat", this.getDateTimeFormatParameter());
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObjectList(json, typeCache, false);
    }
}

