/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.http.AbstractApacheClientHttpInvoker;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.http.Header;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class ApacheClientHttpInvoker
extends AbstractApacheClientHttpInvoker {
    private static final String IGNORE_COOKIES = "ignoreCookies";

    @Override
    protected DefaultHttpClient createHttpClient(UrlBuilder url, BindingSession session) {
        HttpParams params = this.createDefaultHttpParams(session);
        params.setParameter("http.protocol.cookie-policy", (Object)IGNORE_COOKIES);
        String maxConnStr = System.getProperty("http.maxConnections", "5");
        int maxConn = 5;
        try {
            maxConn = Integer.parseInt(maxConnStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        params.setIntParameter("http.conn-manager.max-total", maxConn * 4);
        params.setParameter("http.conn-manager.max-per-route", (Object)new ConnPerRouteBean(maxConn));
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)this.getSSLSocketFactory(url, session), 443));
        ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager(params, registry);
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(registry, null);
        DefaultHttpClient httpclient = new DefaultHttpClient((ClientConnectionManager)connManager, params);
        httpclient.setRoutePlanner((HttpRoutePlanner)routePlanner);
        httpclient.getCookieSpecs().register(IGNORE_COOKIES, (CookieSpecFactory)new IgnoreSpecFactory());
        return httpclient;
    }

    private LayeredSocketFactory getSSLSocketFactory(UrlBuilder url, BindingSession session) {
        AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(session);
        final SSLSocketFactory sf = authProvider.getSSLSocketFactory();
        if (sf == null) {
            return org.apache.http.conn.ssl.SSLSocketFactory.getSocketFactory();
        }
        Object hv = authProvider.getHostnameVerifier() == null ? new BrowserCompatHostnameVerifier() : authProvider.getHostnameVerifier();
        return new LayeredSocketFactory((HostnameVerifier)hv){
            final /* synthetic */ HostnameVerifier val$hv;
            {
                this.val$hv = hostnameVerifier;
            }

            public boolean isSecure(Socket sock) {
                return true;
            }

            public Socket createSocket() throws IOException {
                return sf.createSocket();
            }

            public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
                SSLSocket sslSocket = (SSLSocket)sf.createSocket(socket, host, port, autoClose);
                ApacheClientHttpInvoker.this.verify(this.val$hv, host, sslSocket);
                return sslSocket;
            }

            public Socket connectSocket(Socket sock, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
                SSLSocket sslSocket = (SSLSocket)(sock != null ? sock : this.createSocket());
                if (localAddress != null || localPort > 0) {
                    if (localPort < 0) {
                        localPort = 0;
                    }
                    InetSocketAddress isa = new InetSocketAddress(localAddress, localPort);
                    sslSocket.bind(isa);
                }
                InetSocketAddress remoteAddress = new InetSocketAddress(host, port);
                int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
                int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
                try {
                    sslSocket.setSoTimeout(soTimeout);
                    sslSocket.connect(remoteAddress, connTimeout);
                }
                catch (SocketTimeoutException ex) {
                    ApacheClientHttpInvoker.this.closeSocket(sock);
                    throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out!");
                }
                ApacheClientHttpInvoker.this.verify(this.val$hv, host, sslSocket);
                return sslSocket;
            }
        };
    }

    private static class IgnoreSpecFactory
    implements CookieSpecFactory {
        private IgnoreSpecFactory() {
        }

        public CookieSpec newInstance(HttpParams params) {
            return new CookieSpecBase(){

                public int getVersion() {
                    return 0;
                }

                public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
                    return Collections.emptyList();
                }

                public List<Header> formatCookies(List<Cookie> cookies) {
                    return Collections.emptyList();
                }

                public Header getVersionHeader() {
                    return null;
                }
            };
        }
    }
}

