/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.http;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.chemistry.opencmis.client.bindings.impl.ClientVersion;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpInvoker
implements HttpInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpInvoker.class);
    private static final int BUFFER_SIZE = 0x200000;

    @Override
    public Response invokeGET(UrlBuilder url, BindingSession session) {
        return this.invoke(url, "GET", null, null, null, session, null, null);
    }

    @Override
    public Response invokeGET(UrlBuilder url, BindingSession session, BigInteger offset, BigInteger length) {
        return this.invoke(url, "GET", null, null, null, session, offset, length);
    }

    @Override
    public Response invokePOST(UrlBuilder url, String contentType, Output writer, BindingSession session) {
        return this.invoke(url, "POST", contentType, null, writer, session, null, null);
    }

    @Override
    public Response invokePUT(UrlBuilder url, String contentType, Map<String, String> headers, Output writer, BindingSession session) {
        return this.invoke(url, "PUT", contentType, headers, writer, session, null, null);
    }

    @Override
    public Response invokeDELETE(UrlBuilder url, BindingSession session) {
        return this.invoke(url, "DELETE", null, null, null, session, null, null);
    }

    private Response invoke(UrlBuilder url, String method, String contentType, Map<String, String> headers, Output writer, BindingSession session, BigInteger offset, BigInteger length) {
        int respCode = -1;
        try {
            Object compression;
            AuthenticationProvider authProvider;
            int readTimeout;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session {}: {} {}", new Object[]{session.getSessionId(), method, url});
            }
            HttpURLConnection conn = (HttpURLConnection)new URL(url.toString()).openConnection();
            conn.setRequestMethod(method);
            conn.setDoInput(true);
            conn.setDoOutput(writer != null);
            conn.setAllowUserInteraction(false);
            conn.setUseCaches(false);
            conn.setRequestProperty("User-Agent", (String)session.get("org.apache.chemistry.opencmis.binding.useragent", ClientVersion.OPENCMIS_USER_AGENT));
            int connectTimeout = session.get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
            if (connectTimeout >= 0) {
                conn.setConnectTimeout(connectTimeout);
            }
            if ((readTimeout = session.get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
                conn.setReadTimeout(readTimeout);
            }
            if (contentType != null) {
                conn.setRequestProperty("Content-Type", contentType);
            }
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    conn.addRequestProperty(header.getKey(), header.getValue());
                }
            }
            if ((authProvider = CmisBindingsHelper.getAuthenticationProvider(session)) != null) {
                Map<String, List<String>> httpHeaders = authProvider.getHTTPHeaders(url.toString());
                if (httpHeaders != null) {
                    for (Map.Entry<String, List<String>> header : httpHeaders.entrySet()) {
                        if (header.getKey() == null || !CollectionsHelper.isNotEmpty((Collection)header.getValue())) continue;
                        String key = header.getKey();
                        if (key.equalsIgnoreCase("user-agent")) {
                            conn.setRequestProperty("User-Agent", header.getValue().get(0));
                            continue;
                        }
                        for (String value : header.getValue()) {
                            if (value == null) continue;
                            conn.addRequestProperty(key, value);
                        }
                    }
                }
                if (conn instanceof HttpsURLConnection) {
                    HostnameVerifier hv;
                    SSLSocketFactory sf = authProvider.getSSLSocketFactory();
                    if (sf != null) {
                        ((HttpsURLConnection)conn).setSSLSocketFactory(sf);
                    }
                    if ((hv = authProvider.getHostnameVerifier()) != null) {
                        ((HttpsURLConnection)conn).setHostnameVerifier(hv);
                    }
                }
            }
            if (offset != null || length != null) {
                StringBuilder sb = new StringBuilder("bytes=");
                if (offset == null || offset.signum() == -1) {
                    offset = BigInteger.ZERO;
                }
                sb.append(offset.toString());
                sb.append('-');
                if (length != null && length.signum() == 1) {
                    sb.append(offset.add(length.subtract(BigInteger.ONE)).toString());
                }
                conn.setRequestProperty("Range", sb.toString());
            }
            if ((compression = session.get("org.apache.chemistry.opencmis.binding.compression")) != null && Boolean.parseBoolean(compression.toString())) {
                conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
            }
            if (session.get("org.apache.chemistry.opencmis.binding.acceptLanguage") instanceof String) {
                conn.setRequestProperty("Accept-Language", session.get("org.apache.chemistry.opencmis.binding.acceptLanguage").toString());
            }
            if (writer != null) {
                OutputStream connOut = null;
                Object clientCompression = session.get("org.apache.chemistry.opencmis.binding.clientcompression");
                if (clientCompression != null && Boolean.parseBoolean(clientCompression.toString())) {
                    conn.setRequestProperty("Content-Encoding", "gzip");
                    connOut = new GZIPOutputStream(conn.getOutputStream(), 4096);
                } else {
                    connOut = conn.getOutputStream();
                }
                BufferedOutputStream out = new BufferedOutputStream(connOut, 0x200000);
                writer.write(out);
                ((OutputStream)out).close();
            }
            conn.connect();
            respCode = conn.getResponseCode();
            InputStream inputStream = null;
            if (respCode == 200 || respCode == 201 || respCode == 203 || respCode == 206) {
                inputStream = conn.getInputStream();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Session {}: {} {} > Headers: {}", new Object[]{session.getSessionId(), method, url, conn.getHeaderFields().toString()});
            }
            if (authProvider != null) {
                authProvider.putResponseHeaders(url.toString(), respCode, conn.getHeaderFields());
            }
            return new Response(respCode, conn.getResponseMessage(), conn.getHeaderFields(), inputStream, conn.getErrorStream());
        }
        catch (Exception e) {
            throw new CmisConnectionException(url.toString(), respCode, (Throwable)e);
        }
    }
}

