/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.runtime.AbstractCmisObject;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.spi.Holder;

public abstract class AbstractFilableCmisObject
extends AbstractCmisObject
implements FileableCmisObject {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Folder> getParents() {
        return this.getParents(this.getSession().getDefaultContext());
    }

    @Override
    public List<Folder> getParents(OperationContext context) {
        String objectId = this.getObjectId();
        List<ObjectParentData> bindingParents = this.getBinding().getNavigationService().getObjectParents(this.getRepositoryId(), objectId, this.getPropertyQueryName("cmis:objectId"), false, IncludeRelationships.NONE, null, false, null);
        ArrayList<Folder> parents = new ArrayList<Folder>();
        for (ObjectParentData p : bindingParents) {
            if (p == null || p.getObject() == null || p.getObject().getProperties() == null) {
                throw new CmisRuntimeException("Repository sent invalid data!");
            }
            PropertyData<?> idProperty = p.getObject().getProperties().getProperties().get("cmis:objectId");
            if (!(idProperty instanceof PropertyId) && !(idProperty instanceof PropertyString)) {
                throw new CmisRuntimeException("Repository sent invalid data! No object id!");
            }
            CmisObject parentFolder = this.getSession().getObject((String)idProperty.getFirstValue(), context);
            if (!(parentFolder instanceof Folder)) {
                throw new CmisRuntimeException("Repository sent invalid data! Object is not a folder!");
            }
            parents.add((Folder)parentFolder);
        }
        return parents;
    }

    @Override
    public List<String> getPaths() {
        String objectId = this.getObjectId();
        ObjectType folderType = this.getSession().getTypeDefinition(BaseTypeId.CMIS_FOLDER.value());
        PropertyDefinition<?> idPropDef = folderType.getPropertyDefinitions().get("cmis:objectId");
        PropertyDefinition<?> pathPropDef = folderType.getPropertyDefinitions().get("cmis:path");
        String filter = idPropDef != null && pathPropDef != null ? idPropDef.getQueryName() + "," + pathPropDef.getQueryName() : "*";
        List<ObjectParentData> bindingParents = this.getBinding().getNavigationService().getObjectParents(this.getRepositoryId(), objectId, filter, false, IncludeRelationships.NONE, null, true, null);
        ArrayList<String> paths = new ArrayList<String>();
        for (ObjectParentData p : bindingParents) {
            if (p == null || p.getObject() == null || p.getObject().getProperties() == null) {
                throw new CmisRuntimeException("Repository sent invalid data!");
            }
            PropertyData<?> pathProperty = p.getObject().getProperties().getProperties().get("cmis:path");
            if (!(pathProperty instanceof PropertyString)) {
                throw new CmisRuntimeException("Repository sent invalid data! No path property!");
            }
            if (p.getRelativePathSegment() == null) {
                throw new CmisRuntimeException("Repository sent invalid data! No relative path segement!");
            }
            String folderPath = (String)pathProperty.getFirstValue();
            if (folderPath == null) {
                throw new CmisRuntimeException("Repository sent invalid data! No path property value!");
            }
            paths.add(folderPath + (folderPath.endsWith("/") ? "" : "/") + p.getRelativePathSegment());
        }
        return paths;
    }

    @Override
    public FileableCmisObject move(ObjectId sourceFolderId, ObjectId targetFolderId) {
        return this.move(sourceFolderId, targetFolderId, this.getSession().getDefaultContext());
    }

    @Override
    public FileableCmisObject move(ObjectId sourceFolderId, ObjectId targetFolderId, OperationContext context) {
        String objectId = this.getObjectId();
        Holder<String> objectIdHolder = new Holder<String>(objectId);
        if (sourceFolderId == null || sourceFolderId.getId() == null) {
            throw new IllegalArgumentException("Source folder id must be set!");
        }
        if (targetFolderId == null || targetFolderId.getId() == null) {
            throw new IllegalArgumentException("Target folder id must be set!");
        }
        this.getBinding().getObjectService().moveObject(this.getRepositoryId(), objectIdHolder, targetFolderId.getId(), sourceFolderId.getId(), null);
        this.getSession().removeObjectFromCache(objectId);
        if (objectIdHolder.getValue() == null) {
            return null;
        }
        CmisObject movedObject = this.getSession().getObject(objectIdHolder.getValue(), context);
        if (!(movedObject instanceof FileableCmisObject)) {
            throw new CmisRuntimeException("Moved object is invalid!");
        }
        return (FileableCmisObject)movedObject;
    }

    @Override
    public void addToFolder(ObjectId folderId, boolean allVersions) {
        String objectId = this.getObjectId();
        if (folderId == null || folderId.getId() == null) {
            throw new IllegalArgumentException("Folder Id must be set!");
        }
        this.getBinding().getMultiFilingService().addObjectToFolder(this.getRepositoryId(), objectId, folderId.getId(), allVersions, null);
        this.getSession().removeObjectFromCache(objectId);
    }

    @Override
    public void removeFromFolder(ObjectId folderId) {
        String objectId = this.getObjectId();
        this.getBinding().getMultiFilingService().removeObjectFromFolder(this.getRepositoryId(), objectId, folderId != null ? folderId.getId() : null, null);
        this.getSession().removeObjectFromCache(objectId);
    }
}

