/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.CreatablePropertyTypes;
import org.apache.chemistry.opencmis.commons.data.ExtensionFeature;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.NewTypeSettableAttributes;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.PolicyIdList;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.PropertyDecimal;
import org.apache.chemistry.opencmis.commons.data.PropertyHtml;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyInteger;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.PropertyUri;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyBooleanDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDateTimeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyHtmlDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIdDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyUriDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeMutability;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityOrderBy;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.DateTimeResolution;
import org.apache.chemistry.opencmis.commons.enums.DecimalPrecision;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.XMLWalker;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AclCapabilitiesDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateObjectIdAndChangeTokenImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChangeEventInfoDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChoiceImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CreatablePropertyTypesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ExtensionFeatureImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ItemTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.NewTypeSettableAttributesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionDefinitionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionMappingDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyIdListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.QueryTypeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RenditionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.SecondaryTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeMutabilityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class XMLConverter {
    private static final Logger LOG = LoggerFactory.getLogger(XMLConverter.class);
    private static final XMLWalker<RepositoryInfoImpl> REPOSITORY_INFO_PARSER = new XMLWalker<RepositoryInfoImpl>(){

        @Override
        protected RepositoryInfoImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new RepositoryInfoImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, RepositoryInfoImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "repositoryId")) {
                    target.setId(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "repositoryName")) {
                    target.setName(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "repositoryDescription")) {
                    target.setDescription(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "vendorName")) {
                    target.setVendorName(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "productName")) {
                    target.setProductName(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "productVersion")) {
                    target.setProductVersion(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "rootFolderId")) {
                    target.setRootFolder(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "latestChangeLogToken")) {
                    target.setLatestChangeLogToken(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "capabilities")) {
                    target.setCapabilities((RepositoryCapabilities)CAPABILITIES_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "aclCapability")) {
                    target.setAclCapabilities((AclCapabilities)ACL_CAPABILITIES_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "cmisVersionSupported")) {
                    target.setCmisVersionSupported(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "thinClientURI")) {
                    target.setThinClientUri(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "changesIncomplete")) {
                    target.setChangesIncomplete(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "changesOnType")) {
                    target.setChangesOnType(this.addToList(target.getChangesOnType(), this.readEnum(parser, BaseTypeId.class)));
                    return true;
                }
                if (this.isTag(name, "principalAnonymous")) {
                    target.setPrincipalAnonymous(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "principalAnyone")) {
                    target.setPrincipalAnyone(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "extendedFeatures")) {
                    target.setExtensionFeature(this.addToList(target.getExtensionFeatures(), (ExtensionFeature)EXTENDED_FEATURES_PARSER.walk(parser)));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<RepositoryCapabilitiesImpl> CAPABILITIES_PARSER = new XMLWalker<RepositoryCapabilitiesImpl>(){

        @Override
        protected RepositoryCapabilitiesImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new RepositoryCapabilitiesImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, RepositoryCapabilitiesImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "capabilityACL")) {
                    target.setCapabilityAcl(this.readEnum(parser, CapabilityAcl.class));
                    return true;
                }
                if (this.isTag(name, "capabilityAllVersionsSearchable")) {
                    target.setAllVersionsSearchable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "capabilityChanges")) {
                    target.setCapabilityChanges(this.readEnum(parser, CapabilityChanges.class));
                    return true;
                }
                if (this.isTag(name, "capabilityContentStreamUpdatability")) {
                    target.setCapabilityContentStreamUpdates(this.readEnum(parser, CapabilityContentStreamUpdates.class));
                    return true;
                }
                if (this.isTag(name, "capabilityGetDescendants")) {
                    target.setSupportsGetDescendants(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "capabilityGetFolderTree")) {
                    target.setSupportsGetFolderTree(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "capabilityOrderBy")) {
                    target.setCapabilityOrderBy(this.readEnum(parser, CapabilityOrderBy.class));
                    return true;
                }
                if (this.isTag(name, "capabilityMultifiling")) {
                    target.setSupportsMultifiling(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "capabilityPWCSearchable")) {
                    target.setIsPwcSearchable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "capabilityPWCUpdatable")) {
                    target.setIsPwcUpdatable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "capabilityQuery")) {
                    target.setCapabilityQuery(this.readEnum(parser, CapabilityQuery.class));
                    return true;
                }
                if (this.isTag(name, "capabilityRenditions")) {
                    target.setCapabilityRendition(this.readEnum(parser, CapabilityRenditions.class));
                    return true;
                }
                if (this.isTag(name, "capabilityUnfiling")) {
                    target.setSupportsUnfiling(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "capabilityVersionSpecificFiling")) {
                    target.setSupportsVersionSpecificFiling(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "capabilityJoin")) {
                    target.setCapabilityJoin(this.readEnum(parser, CapabilityJoin.class));
                    return true;
                }
                if (this.isTag(name, "capabilityCreatablePropertyTypes")) {
                    target.setCreatablePropertyTypes((CreatablePropertyTypes)CREATABLE_PROPERTY_TYPES_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "capabilityNewTypeSettableAttributes")) {
                    target.setNewTypeSettableAttributes((NewTypeSettableAttributes)NEW_TYPES_SETTABLE_ATTRIBUTES_PARSER.walk(parser));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<CreatablePropertyTypesImpl> CREATABLE_PROPERTY_TYPES_PARSER = new XMLWalker<CreatablePropertyTypesImpl>(){

        @Override
        protected CreatablePropertyTypesImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new CreatablePropertyTypesImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, CreatablePropertyTypesImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name) && this.isTag(name, "canCreate")) {
                target.canCreate().add(this.readEnum(parser, PropertyType.class));
                return true;
            }
            return false;
        }
    };
    private static final XMLWalker<NewTypeSettableAttributesImpl> NEW_TYPES_SETTABLE_ATTRIBUTES_PARSER = new XMLWalker<NewTypeSettableAttributesImpl>(){

        @Override
        protected NewTypeSettableAttributesImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new NewTypeSettableAttributesImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, NewTypeSettableAttributesImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "id")) {
                    target.setCanSetId(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "localName")) {
                    target.setCanSetLocalName(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "localNamespace")) {
                    target.setCanSetLocalNamespace(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "displayName")) {
                    target.setCanSetDisplayName(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "queryName")) {
                    target.setCanSetQueryName(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "description")) {
                    target.setCanSetDescription(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "creatable")) {
                    target.setCanSetCreatable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "fileable")) {
                    target.setCanSetFileable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "queryable")) {
                    target.setCanSetQueryable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "fulltextIndexed")) {
                    target.setCanSetFulltextIndexed(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "includedInSupertypeQuery")) {
                    target.setCanSetIncludedInSupertypeQuery(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "controllablePolicy")) {
                    target.setCanSetControllablePolicy(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "controllableACL")) {
                    target.setCanSetControllableAcl(this.readBoolean(parser));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<AclCapabilitiesDataImpl> ACL_CAPABILITIES_PARSER = new XMLWalker<AclCapabilitiesDataImpl>(){

        @Override
        protected AclCapabilitiesDataImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new AclCapabilitiesDataImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, AclCapabilitiesDataImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "supportedPermissions")) {
                    target.setSupportedPermissions(this.readEnum(parser, SupportedPermissions.class));
                    return true;
                }
                if (this.isTag(name, "propagation")) {
                    target.setAclPropagation(this.readEnum(parser, AclPropagation.class));
                    return true;
                }
                if (this.isTag(name, "permissions")) {
                    target.setPermissionDefinitionData(this.addToList(target.getPermissions(), (PermissionDefinition)PERMISSION_DEFINITION_PARSER.walk(parser)));
                    return true;
                }
                if (this.isTag(name, "mapping")) {
                    PermissionMapping pm = (PermissionMapping)PERMISSION_MAPPING_PARSER.walk(parser);
                    Map<String, PermissionMapping> mapping = target.getPermissionMapping();
                    mapping.put(pm.getKey(), pm);
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<PermissionDefinitionDataImpl> PERMISSION_DEFINITION_PARSER = new XMLWalker<PermissionDefinitionDataImpl>(){

        @Override
        protected PermissionDefinitionDataImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new PermissionDefinitionDataImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, PermissionDefinitionDataImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "permission")) {
                    target.setId(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "description")) {
                    target.setDescription(this.readText(parser));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<PermissionMappingDataImpl> PERMISSION_MAPPING_PARSER = new XMLWalker<PermissionMappingDataImpl>(){

        @Override
        protected PermissionMappingDataImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new PermissionMappingDataImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, PermissionMappingDataImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "key")) {
                    target.setKey(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "permission")) {
                    target.setPermissions(this.addToList(target.getPermissions(), this.readText(parser)));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<ExtensionFeatureImpl> EXTENDED_FEATURES_PARSER = new XMLWalker<ExtensionFeatureImpl>(){

        @Override
        protected ExtensionFeatureImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new ExtensionFeatureImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, ExtensionFeatureImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "id")) {
                    target.setId(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "url")) {
                    target.setUrl(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "commonName")) {
                    target.setCommonName(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "versionLabel")) {
                    target.setVersionLabel(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "description")) {
                    target.setDescription(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "featureData")) {
                    String[] data = (String[])FEATURE_DATA_PARSER.walk(parser);
                    Map<String, String> featureData = target.getFeatureData();
                    featureData.put(data[0], data[1]);
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<String[]> FEATURE_DATA_PARSER = new XMLWalker<String[]>(){

        @Override
        protected String[] prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new String[2];
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, String[] target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "key")) {
                    target[0] = this.readText(parser);
                    return true;
                }
                if (this.isTag(name, "value")) {
                    target[1] = this.readText(parser);
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<AbstractTypeDefinition> TYPE_DEF_PARSER = new XMLWalker<AbstractTypeDefinition>(){

        @Override
        protected AbstractTypeDefinition prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            AbstractTypeDefinition result = null;
            String typeAttr = parser.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (typeAttr != null) {
                if (typeAttr.endsWith("cmisTypeDocumentDefinitionType")) {
                    result = new DocumentTypeDefinitionImpl();
                } else if (typeAttr.endsWith("cmisTypeFolderDefinitionType")) {
                    result = new FolderTypeDefinitionImpl();
                } else if (typeAttr.endsWith("cmisTypeRelationshipDefinitionType")) {
                    result = new RelationshipTypeDefinitionImpl();
                    ((RelationshipTypeDefinitionImpl)result).setAllowedSourceTypes(new ArrayList<String>());
                    ((RelationshipTypeDefinitionImpl)result).setAllowedTargetTypes(new ArrayList<String>());
                } else if (typeAttr.endsWith("cmisTypePolicyDefinitionType")) {
                    result = new PolicyTypeDefinitionImpl();
                } else if (typeAttr.endsWith("cmisTypeItemDefinitionType")) {
                    result = new ItemTypeDefinitionImpl();
                } else if (typeAttr.endsWith("cmisTypeSecondaryDefinitionType")) {
                    result = new SecondaryTypeDefinitionImpl();
                }
            }
            if (result == null) {
                throw new CmisInvalidArgumentException("Cannot read type definition!");
            }
            return result;
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, AbstractTypeDefinition target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "id")) {
                    target.setId(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "localName")) {
                    target.setLocalName(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "localNamespace")) {
                    target.setLocalNamespace(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "displayName")) {
                    target.setDisplayName(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "queryName")) {
                    target.setQueryName(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "description")) {
                    target.setDescription(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "baseId")) {
                    BaseTypeId baseType = this.readEnum(parser, BaseTypeId.class);
                    if (baseType == null) {
                        throw new CmisInvalidArgumentException("Invalid base type!");
                    }
                    target.setBaseTypeId(baseType);
                    return true;
                }
                if (this.isTag(name, "parentId")) {
                    target.setParentTypeId(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "creatable")) {
                    target.setIsCreatable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "fileable")) {
                    target.setIsFileable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "queryable")) {
                    target.setIsQueryable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "fulltextIndexed")) {
                    target.setIsFulltextIndexed(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "includedInSupertypeQuery")) {
                    target.setIsIncludedInSupertypeQuery(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "controllablePolicy")) {
                    target.setIsControllablePolicy(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "controllableACL")) {
                    target.setIsControllableAcl(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "typeMutability")) {
                    target.setTypeMutability((TypeMutability)TYPE_MUTABILITY_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "propertyStringDefinition") || this.isTag(name, "propertyIdDefinition") || this.isTag(name, "propertyBooleanDefinition") || this.isTag(name, "propertyIntegerDefinition") || this.isTag(name, "propertyDateTimeDefinition") || this.isTag(name, "propertyDecimalDefinition") || this.isTag(name, "propertyHtmlDefinition") || this.isTag(name, "propertyUriDefinition")) {
                    target.addPropertyDefinition((PropertyDefinition)PROPERTY_TYPE_PARSER.walk(parser));
                    return true;
                }
                if (target instanceof DocumentTypeDefinitionImpl) {
                    if (this.isTag(name, "versionable")) {
                        ((DocumentTypeDefinitionImpl)target).setIsVersionable(this.readBoolean(parser));
                        return true;
                    }
                    if (this.isTag(name, "contentStreamAllowed")) {
                        ((DocumentTypeDefinitionImpl)target).setContentStreamAllowed(this.readEnum(parser, ContentStreamAllowed.class));
                        return true;
                    }
                }
                if (target instanceof RelationshipTypeDefinitionImpl) {
                    if (this.isTag(name, "allowedSourceTypes")) {
                        RelationshipTypeDefinitionImpl relTarget = (RelationshipTypeDefinitionImpl)target;
                        relTarget.setAllowedSourceTypes(this.addToList(relTarget.getAllowedSourceTypeIds(), this.readText(parser)));
                        return true;
                    }
                    if (this.isTag(name, "allowedTargetTypes")) {
                        RelationshipTypeDefinitionImpl relTarget = (RelationshipTypeDefinitionImpl)target;
                        relTarget.setAllowedTargetTypes(this.addToList(relTarget.getAllowedTargetTypeIds(), this.readText(parser)));
                        return true;
                    }
                }
            }
            return false;
        }
    };
    private static final XMLWalker<TypeMutabilityImpl> TYPE_MUTABILITY_PARSER = new XMLWalker<TypeMutabilityImpl>(){

        @Override
        protected TypeMutabilityImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new TypeMutabilityImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, TypeMutabilityImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "create")) {
                    target.setCanCreate(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "update")) {
                    target.setCanUpdate(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "delete")) {
                    target.setCanDelete(this.readBoolean(parser));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<AbstractPropertyDefinition<?>> PROPERTY_TYPE_PARSER = new XMLWalker<AbstractPropertyDefinition<?>>(){

        @Override
        protected AbstractPropertyDefinition<?> prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            AbstractPropertyDefinition result = null;
            if (this.isTag(name, "propertyStringDefinition")) {
                result = new PropertyStringDefinitionImpl();
            } else if (this.isTag(name, "propertyIdDefinition")) {
                result = new PropertyIdDefinitionImpl();
            } else if (this.isTag(name, "propertyBooleanDefinition")) {
                result = new PropertyBooleanDefinitionImpl();
            } else if (this.isTag(name, "propertyIntegerDefinition")) {
                result = new PropertyIntegerDefinitionImpl();
            } else if (this.isTag(name, "propertyDateTimeDefinition")) {
                result = new PropertyDateTimeDefinitionImpl();
            } else if (this.isTag(name, "propertyDecimalDefinition")) {
                result = new PropertyDecimalDefinitionImpl();
            } else if (this.isTag(name, "propertyHtmlDefinition")) {
                result = new PropertyHtmlDefinitionImpl();
            } else if (this.isTag(name, "propertyUriDefinition")) {
                result = new PropertyUriDefinitionImpl();
            }
            if (result == null) {
                throw new CmisInvalidArgumentException("Cannot read property type definition!");
            }
            return result;
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, AbstractPropertyDefinition<?> target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "id")) {
                    target.setId(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "localName")) {
                    target.setLocalName(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "localNamespace")) {
                    target.setLocalNamespace(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "displayName")) {
                    target.setDisplayName(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "queryName")) {
                    target.setQueryName(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "description")) {
                    target.setDescription(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "propertyType")) {
                    PropertyType propType = this.readEnum(parser, PropertyType.class);
                    if (propType == null) {
                        throw new CmisInvalidArgumentException("Invalid property type!");
                    }
                    target.setPropertyType(propType);
                    return true;
                }
                if (this.isTag(name, "cardinality")) {
                    Cardinality cardinality = this.readEnum(parser, Cardinality.class);
                    if (cardinality == null) {
                        throw new CmisInvalidArgumentException("Invalid cardinality!");
                    }
                    target.setCardinality(cardinality);
                    return true;
                }
                if (this.isTag(name, "updatability")) {
                    Updatability updatability = this.readEnum(parser, Updatability.class);
                    if (updatability == null) {
                        throw new CmisInvalidArgumentException("Invalid updatability!");
                    }
                    target.setUpdatability(updatability);
                    return true;
                }
                if (this.isTag(name, "inherited")) {
                    target.setIsInherited(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "required")) {
                    target.setIsRequired(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "queryable")) {
                    target.setIsQueryable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "orderable")) {
                    target.setIsOrderable(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "openChoice")) {
                    target.setIsOpenChoice(this.readBoolean(parser));
                    return true;
                }
                if (target instanceof PropertyStringDefinitionImpl) {
                    if (this.isTag(name, "defaultValue")) {
                        PropertyString prop = (PropertyString)PROPERTY_STRING_PARSER.walk(parser);
                        ((PropertyStringDefinitionImpl)target).setDefaultValue(prop.getValues());
                        return true;
                    }
                    if (this.isTag(name, "choice")) {
                        CHOICE_STRING_PARSER.addToChoiceList(parser, (PropertyStringDefinitionImpl)target);
                        return true;
                    }
                    if (this.isTag(name, "maxLength")) {
                        ((PropertyStringDefinitionImpl)target).setMaxLength(this.readInteger(parser));
                        return true;
                    }
                } else if (target instanceof PropertyIdDefinitionImpl) {
                    if (this.isTag(name, "defaultValue")) {
                        PropertyId prop = (PropertyId)PROPERTY_ID_PARSER.walk(parser);
                        ((PropertyIdDefinitionImpl)target).setDefaultValue(prop.getValues());
                        return true;
                    }
                    if (this.isTag(name, "choice")) {
                        CHOICE_STRING_PARSER.addToChoiceList(parser, (PropertyIdDefinitionImpl)target);
                        return true;
                    }
                } else if (target instanceof PropertyBooleanDefinitionImpl) {
                    if (this.isTag(name, "defaultValue")) {
                        PropertyBoolean prop = (PropertyBoolean)PROPERTY_BOOLEAN_PARSER.walk(parser);
                        ((PropertyBooleanDefinitionImpl)target).setDefaultValue(prop.getValues());
                        return true;
                    }
                    if (this.isTag(name, "choice")) {
                        CHOICE_BOOLEAN_PARSER.addToChoiceList(parser, (PropertyBooleanDefinitionImpl)target);
                        return true;
                    }
                } else if (target instanceof PropertyIntegerDefinitionImpl) {
                    if (this.isTag(name, "defaultValue")) {
                        PropertyInteger prop = (PropertyInteger)PROPERTY_INTEGER_PARSER.walk(parser);
                        ((PropertyIntegerDefinitionImpl)target).setDefaultValue(prop.getValues());
                        return true;
                    }
                    if (this.isTag(name, "choice")) {
                        CHOICE_INTEGER_PARSER.addToChoiceList(parser, (PropertyIntegerDefinitionImpl)target);
                        return true;
                    }
                    if (this.isTag(name, "maxValue")) {
                        ((PropertyIntegerDefinitionImpl)target).setMaxValue(this.readInteger(parser));
                        return true;
                    }
                    if (this.isTag(name, "minValue")) {
                        ((PropertyIntegerDefinitionImpl)target).setMinValue(this.readInteger(parser));
                        return true;
                    }
                } else if (target instanceof PropertyDateTimeDefinitionImpl) {
                    if (this.isTag(name, "defaultValue")) {
                        PropertyDateTime prop = (PropertyDateTime)PROPERTY_DATETIME_PARSER.walk(parser);
                        ((PropertyDateTimeDefinitionImpl)target).setDefaultValue(prop.getValues());
                        return true;
                    }
                    if (this.isTag(name, "choice")) {
                        CHOICE_DATETIME_PARSER.addToChoiceList(parser, (PropertyDateTimeDefinitionImpl)target);
                        return true;
                    }
                    if (this.isTag(name, "resolution")) {
                        ((PropertyDateTimeDefinitionImpl)target).setDateTimeResolution(this.readEnum(parser, DateTimeResolution.class));
                        return true;
                    }
                } else if (target instanceof PropertyDecimalDefinitionImpl) {
                    if (this.isTag(name, "defaultValue")) {
                        PropertyDecimal prop = (PropertyDecimal)PROPERTY_DECIMAL_PARSER.walk(parser);
                        ((PropertyDecimalDefinitionImpl)target).setDefaultValue(prop.getValues());
                        return true;
                    }
                    if (this.isTag(name, "choice")) {
                        CHOICE_DECIMAL_PARSER.addToChoiceList(parser, (PropertyDecimalDefinitionImpl)target);
                        return true;
                    }
                    if (this.isTag(name, "maxValue")) {
                        ((PropertyDecimalDefinitionImpl)target).setMaxValue(this.readDecimal(parser));
                        return true;
                    }
                    if (this.isTag(name, "minValue")) {
                        ((PropertyDecimalDefinitionImpl)target).setMinValue(this.readDecimal(parser));
                        return true;
                    }
                    if (this.isTag(name, "precision")) {
                        try {
                            ((PropertyDecimalDefinitionImpl)target).setPrecision(DecimalPrecision.fromValue(this.readInteger(parser)));
                        }
                        catch (IllegalArgumentException prop) {
                            // empty catch block
                        }
                        return true;
                    }
                } else if (target instanceof PropertyHtmlDefinitionImpl) {
                    if (this.isTag(name, "defaultValue")) {
                        PropertyHtml prop = (PropertyHtml)PROPERTY_HTML_PARSER.walk(parser);
                        ((PropertyHtmlDefinitionImpl)target).setDefaultValue(prop.getValues());
                        return true;
                    }
                    if (this.isTag(name, "choice")) {
                        CHOICE_STRING_PARSER.addToChoiceList(parser, (PropertyHtmlDefinitionImpl)target);
                        return true;
                    }
                } else if (target instanceof PropertyUriDefinitionImpl) {
                    if (this.isTag(name, "defaultValue")) {
                        PropertyUri prop = (PropertyUri)PROPERTY_URI_PARSER.walk(parser);
                        ((PropertyUriDefinitionImpl)target).setDefaultValue(prop.getValues());
                        return true;
                    }
                    if (this.isTag(name, "choice")) {
                        CHOICE_STRING_PARSER.addToChoiceList(parser, (PropertyUriDefinitionImpl)target);
                        return true;
                    }
                }
            }
            return false;
        }
    };
    private static final ChoiceAtomPubXMLWalker<String> CHOICE_STRING_PARSER = new ChoiceAtomPubXMLWalker<String>(){

        @Override
        protected ChoiceImpl<String> createTarget(XmlPullParser parser, QName name) {
            return new ChoiceImpl<String>();
        }

        @Override
        protected void addValue(XmlPullParser parser, ChoiceImpl<String> target) throws XmlPullParserException {
            target.setValue((String)((Object)this.addToList(target.getValue(), this.readText(parser))));
        }

        @Override
        protected void addChoice(XmlPullParser parser, ChoiceImpl<String> target) throws XmlPullParserException {
            target.setChoice(this.addToList(target.getChoice(), (Choice)CHOICE_STRING_PARSER.walk(parser)));
        }
    };
    private static final ChoiceAtomPubXMLWalker<Boolean> CHOICE_BOOLEAN_PARSER = new ChoiceAtomPubXMLWalker<Boolean>(){

        @Override
        protected ChoiceImpl<Boolean> createTarget(XmlPullParser parser, QName name) {
            return new ChoiceImpl<Boolean>();
        }

        @Override
        protected void addValue(XmlPullParser parser, ChoiceImpl<Boolean> target) throws XmlPullParserException {
            target.setValue((Boolean)((Object)this.addToList(target.getValue(), this.readBoolean(parser))));
        }

        @Override
        protected void addChoice(XmlPullParser parser, ChoiceImpl<Boolean> target) throws XmlPullParserException {
            target.setChoice(this.addToList(target.getChoice(), (Choice)CHOICE_BOOLEAN_PARSER.walk(parser)));
        }
    };
    private static final ChoiceAtomPubXMLWalker<BigInteger> CHOICE_INTEGER_PARSER = new ChoiceAtomPubXMLWalker<BigInteger>(){

        @Override
        protected ChoiceImpl<BigInteger> createTarget(XmlPullParser parser, QName name) {
            return new ChoiceImpl<BigInteger>();
        }

        @Override
        protected void addValue(XmlPullParser parser, ChoiceImpl<BigInteger> target) throws XmlPullParserException {
            target.setValue((BigInteger)((Object)this.addToList(target.getValue(), this.readInteger(parser))));
        }

        @Override
        protected void addChoice(XmlPullParser parser, ChoiceImpl<BigInteger> target) throws XmlPullParserException {
            target.setChoice(this.addToList(target.getChoice(), (Choice)CHOICE_INTEGER_PARSER.walk(parser)));
        }
    };
    private static final ChoiceAtomPubXMLWalker<GregorianCalendar> CHOICE_DATETIME_PARSER = new ChoiceAtomPubXMLWalker<GregorianCalendar>(){

        @Override
        protected ChoiceImpl<GregorianCalendar> createTarget(XmlPullParser parser, QName name) {
            return new ChoiceImpl<GregorianCalendar>();
        }

        @Override
        protected void addValue(XmlPullParser parser, ChoiceImpl<GregorianCalendar> target) throws XmlPullParserException {
            target.setValue((GregorianCalendar)((Object)this.addToList(target.getValue(), this.readDateTime(parser))));
        }

        @Override
        protected void addChoice(XmlPullParser parser, ChoiceImpl<GregorianCalendar> target) throws XmlPullParserException {
            target.setChoice(this.addToList(target.getChoice(), (Choice)CHOICE_DATETIME_PARSER.walk(parser)));
        }
    };
    private static final ChoiceAtomPubXMLWalker<BigDecimal> CHOICE_DECIMAL_PARSER = new ChoiceAtomPubXMLWalker<BigDecimal>(){

        @Override
        protected ChoiceImpl<BigDecimal> createTarget(XmlPullParser parser, QName name) {
            return new ChoiceImpl<BigDecimal>();
        }

        @Override
        protected void addValue(XmlPullParser parser, ChoiceImpl<BigDecimal> target) throws XmlPullParserException {
            target.setValue((BigDecimal)((Object)this.addToList(target.getValue(), this.readDecimal(parser))));
        }

        @Override
        protected void addChoice(XmlPullParser parser, ChoiceImpl<BigDecimal> target) throws XmlPullParserException {
            target.setChoice(this.addToList(target.getChoice(), (Choice)CHOICE_DECIMAL_PARSER.walk(parser)));
        }
    };
    private static final XMLWalker<ObjectDataImpl> OBJECT_PARSER = new XMLWalker<ObjectDataImpl>(){

        @Override
        protected ObjectDataImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new ObjectDataImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, ObjectDataImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "properties")) {
                    target.setProperties((Properties)PROPERTIES_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "allowableActions")) {
                    target.setAllowableActions((AllowableActions)ALLOWABLE_ACTIONS_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "relationship")) {
                    target.setRelationships(this.addToList(target.getRelationships(), (ObjectData)OBJECT_PARSER.walk(parser)));
                    return true;
                }
                if (this.isTag(name, "changeEventInfo")) {
                    target.setChangeEventInfo((ChangeEventInfo)CHANGE_EVENT_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "acl")) {
                    target.setAcl((Acl)ACL_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "exactACL")) {
                    target.setIsExactAcl(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "policyIds")) {
                    target.setPolicyIds((PolicyIdList)POLICY_IDS_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "rendition")) {
                    target.setRenditions(this.addToList(target.getRenditions(), (RenditionData)RENDITION_PARSER.walk(parser)));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<PropertiesImpl> PROPERTIES_PARSER = new XMLWalker<PropertiesImpl>(){

        @Override
        protected PropertiesImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new PropertiesImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, PropertiesImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "propertyString")) {
                    target.addProperty((PropertyData)PROPERTY_STRING_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "propertyId")) {
                    target.addProperty((PropertyData)PROPERTY_ID_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "propertyBoolean")) {
                    target.addProperty((PropertyData)PROPERTY_BOOLEAN_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "propertyInteger")) {
                    target.addProperty((PropertyData)PROPERTY_INTEGER_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "propertyDateTime")) {
                    target.addProperty((PropertyData)PROPERTY_DATETIME_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "propertyDecimal")) {
                    target.addProperty((PropertyData)PROPERTY_DECIMAL_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "propertyHtml")) {
                    target.addProperty((PropertyData)PROPERTY_HTML_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "propertyUri")) {
                    target.addProperty((PropertyData)PROPERTY_URI_PARSER.walk(parser));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<AllowableActionsImpl> ALLOWABLE_ACTIONS_PARSER = new XMLWalker<AllowableActionsImpl>(){

        @Override
        protected AllowableActionsImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new AllowableActionsImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, AllowableActionsImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                try {
                    Action action = Action.fromValue(name.getLocalPart());
                    Set<Action> actions = target.getAllowableActions();
                    if (Boolean.TRUE.equals(this.readBoolean(parser))) {
                        actions.add(action);
                    }
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return false;
        }
    };
    private static final XMLWalker<ChangeEventInfoDataImpl> CHANGE_EVENT_PARSER = new XMLWalker<ChangeEventInfoDataImpl>(){

        @Override
        protected ChangeEventInfoDataImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new ChangeEventInfoDataImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, ChangeEventInfoDataImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "changeType")) {
                    target.setChangeType(this.readEnum(parser, ChangeType.class));
                    return true;
                }
                if (this.isTag(name, "changeTime")) {
                    target.setChangeTime(this.readDateTime(parser));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<AccessControlListImpl> ACL_PARSER = new XMLWalker<AccessControlListImpl>(){

        @Override
        protected AccessControlListImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new AccessControlListImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, AccessControlListImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name) && this.isTag(name, "permission")) {
                target.setAces(this.addToList(target.getAces(), (Ace)ACE_PARSER.walk(parser)));
                return true;
            }
            return false;
        }
    };
    private static final XMLWalker<AccessControlEntryImpl> ACE_PARSER = new XMLWalker<AccessControlEntryImpl>(){

        @Override
        protected AccessControlEntryImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new AccessControlEntryImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, AccessControlEntryImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "principal")) {
                    target.setPrincipal((Principal)PRINCIPAL_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "permission")) {
                    target.setPermissions(this.addToList(target.getPermissions(), this.readText(parser)));
                    return true;
                }
                if (this.isTag(name, "direct")) {
                    target.setDirect(this.readBoolean(parser));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<AccessControlPrincipalDataImpl> PRINCIPAL_PARSER = new XMLWalker<AccessControlPrincipalDataImpl>(){

        @Override
        protected AccessControlPrincipalDataImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new AccessControlPrincipalDataImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, AccessControlPrincipalDataImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name) && this.isTag(name, "principalId")) {
                target.setId(this.readText(parser));
                return true;
            }
            return false;
        }
    };
    private static final XMLWalker<PolicyIdListImpl> POLICY_IDS_PARSER = new XMLWalker<PolicyIdListImpl>(){

        @Override
        protected PolicyIdListImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new PolicyIdListImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, PolicyIdListImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name) && this.isTag(name, "id")) {
                target.setPolicyIds(this.addToList(target.getPolicyIds(), this.readText(parser)));
                return true;
            }
            return false;
        }
    };
    private static final XMLWalker<RenditionDataImpl> RENDITION_PARSER = new XMLWalker<RenditionDataImpl>(){

        @Override
        protected RenditionDataImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new RenditionDataImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, RenditionDataImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "streamId")) {
                    target.setStreamId(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "mimetype")) {
                    target.setMimeType(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "length")) {
                    target.setBigLength(this.readInteger(parser));
                    return true;
                }
                if (this.isTag(name, "kind")) {
                    target.setKind(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "title")) {
                    target.setTitle(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "height")) {
                    target.setBigHeight(this.readInteger(parser));
                    return true;
                }
                if (this.isTag(name, "width")) {
                    target.setBigWidth(this.readInteger(parser));
                    return true;
                }
                if (this.isTag(name, "renditionDocumentId")) {
                    target.setRenditionDocumentId(this.readText(parser));
                    return true;
                }
            }
            return false;
        }
    };
    private static final PropertyAtomPubXMLWalker<PropertyStringImpl> PROPERTY_STRING_PARSER = new PropertyStringAtomPubXMLWalker<PropertyStringImpl>(){

        @Override
        protected PropertyStringImpl createTarget(XmlPullParser parser, QName name) {
            return new PropertyStringImpl();
        }
    };
    private static final PropertyAtomPubXMLWalker<PropertyIdImpl> PROPERTY_ID_PARSER = new PropertyStringAtomPubXMLWalker<PropertyIdImpl>(){

        @Override
        protected PropertyIdImpl createTarget(XmlPullParser parser, QName name) {
            return new PropertyIdImpl();
        }
    };
    private static final PropertyAtomPubXMLWalker<PropertyHtmlImpl> PROPERTY_HTML_PARSER = new PropertyStringAtomPubXMLWalker<PropertyHtmlImpl>(){

        @Override
        protected PropertyHtmlImpl createTarget(XmlPullParser parser, QName name) {
            return new PropertyHtmlImpl();
        }
    };
    private static final PropertyAtomPubXMLWalker<PropertyUriImpl> PROPERTY_URI_PARSER = new PropertyStringAtomPubXMLWalker<PropertyUriImpl>(){

        @Override
        protected PropertyUriImpl createTarget(XmlPullParser parser, QName name) {
            return new PropertyUriImpl();
        }
    };
    private static final PropertyAtomPubXMLWalker<PropertyBooleanImpl> PROPERTY_BOOLEAN_PARSER = new PropertyAtomPubXMLWalker<PropertyBooleanImpl>(){

        @Override
        protected PropertyBooleanImpl createTarget(XmlPullParser parser, QName name) {
            return new PropertyBooleanImpl();
        }

        @Override
        protected void addValue(XmlPullParser parser, PropertyBooleanImpl target) throws XmlPullParserException {
            target.setValues(this.addToList(target.getValues(), this.readBoolean(parser)));
        }
    };
    private static final PropertyAtomPubXMLWalker<PropertyIntegerImpl> PROPERTY_INTEGER_PARSER = new PropertyAtomPubXMLWalker<PropertyIntegerImpl>(){

        @Override
        protected PropertyIntegerImpl createTarget(XmlPullParser parser, QName name) {
            return new PropertyIntegerImpl();
        }

        @Override
        protected void addValue(XmlPullParser parser, PropertyIntegerImpl target) throws XmlPullParserException {
            target.setValues(this.addToList(target.getValues(), this.readInteger(parser)));
        }
    };
    private static final PropertyAtomPubXMLWalker<PropertyDecimalImpl> PROPERTY_DECIMAL_PARSER = new PropertyAtomPubXMLWalker<PropertyDecimalImpl>(){

        @Override
        protected PropertyDecimalImpl createTarget(XmlPullParser parser, QName name) {
            return new PropertyDecimalImpl();
        }

        @Override
        protected void addValue(XmlPullParser parser, PropertyDecimalImpl target) throws XmlPullParserException {
            target.setValues(this.addToList(target.getValues(), this.readDecimal(parser)));
        }
    };
    private static final PropertyAtomPubXMLWalker<PropertyDateTimeImpl> PROPERTY_DATETIME_PARSER = new PropertyAtomPubXMLWalker<PropertyDateTimeImpl>(){

        @Override
        protected PropertyDateTimeImpl createTarget(XmlPullParser parser, QName name) {
            return new PropertyDateTimeImpl();
        }

        @Override
        protected void addValue(XmlPullParser parser, PropertyDateTimeImpl target) throws XmlPullParserException {
            target.setValues(this.addToList(target.getValues(), this.readDateTime(parser)));
        }
    };
    private static final XMLWalker<QueryTypeImpl> QUERY_PARSER = new XMLWalker<QueryTypeImpl>(){

        @Override
        protected QueryTypeImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new QueryTypeImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, QueryTypeImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "statement")) {
                    target.setStatement(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "searchAllVersions")) {
                    target.setSearchAllVersions(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "includeAllowableActions")) {
                    target.setIncludeAllowableActions(this.readBoolean(parser));
                    return true;
                }
                if (this.isTag(name, "includeRelationships")) {
                    target.setIncludeRelationships(this.readEnum(parser, IncludeRelationships.class));
                    return true;
                }
                if (this.isTag(name, "renditionFilter")) {
                    target.setRenditionFilter(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "maxItems")) {
                    target.setMaxItems(this.readInteger(parser));
                    return true;
                }
                if (this.isTag(name, "skipCount")) {
                    target.setSkipCount(this.readInteger(parser));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<BulkUpdateImpl> BULK_UPDATE_PARSER = new XMLWalker<BulkUpdateImpl>(){

        @Override
        protected BulkUpdateImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new BulkUpdateImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, BulkUpdateImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "objectIdAndChangeToken")) {
                    target.setObjectIdAndChangeToken(this.addToList(target.getObjectIdAndChangeToken(), (BulkUpdateObjectIdAndChangeToken)ID_AND_TOKEN_PARSER.walk(parser)));
                    return true;
                }
                if (this.isTag(name, "properties")) {
                    target.setProperties((Properties)PROPERTIES_PARSER.walk(parser));
                    return true;
                }
                if (this.isTag(name, "addSecondaryTypeIds")) {
                    target.setAddSecondaryTypeIds(this.addToList(target.getAddSecondaryTypeIds(), this.readText(parser)));
                    return true;
                }
                if (this.isTag(name, "removeSecondaryTypeIds")) {
                    target.setRemoveSecondaryTypeIds(this.addToList(target.getRemoveSecondaryTypeIds(), this.readText(parser)));
                    return true;
                }
            }
            return false;
        }
    };
    private static final XMLWalker<BulkUpdateObjectIdAndChangeTokenImpl> ID_AND_TOKEN_PARSER = new XMLWalker<BulkUpdateObjectIdAndChangeTokenImpl>(){

        @Override
        protected BulkUpdateObjectIdAndChangeTokenImpl prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            return new BulkUpdateObjectIdAndChangeTokenImpl();
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, BulkUpdateObjectIdAndChangeTokenImpl target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "id")) {
                    target.setId(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "newId")) {
                    target.setNewId(this.readText(parser));
                    return true;
                }
                if (this.isTag(name, "changeToken")) {
                    target.setChangeToken(this.readText(parser));
                    return true;
                }
            }
            return false;
        }
    };

    private XMLConverter() {
    }

    public static void writeRepositoryInfo(XmlSerializer writer, CmisVersion cmisVersion, String namespace, RepositoryInfo source) throws IOException {
        if (source == null) {
            return;
        }
        writer.startTag(namespace, "repositoryInfo");
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "repositoryId", source.getId());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "repositoryName", source.getName());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "repositoryDescription", source.getDescription());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "vendorName", source.getVendorName());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "productName", source.getProductName());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "productVersion", source.getProductVersion());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "rootFolderId", source.getRootFolderId());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "latestChangeLogToken", source.getLatestChangeLogToken());
        XMLConverter.writeRepositoryCapabilities(writer, cmisVersion, source.getCapabilities());
        XMLConverter.writeAclCapabilities(writer, cmisVersion, source.getAclCapabilities());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "cmisVersionSupported", source.getCmisVersionSupported());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "thinClientURI", source.getThinClientUri());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "changesIncomplete", source.getChangesIncomplete());
        if (source.getChangesOnType() != null) {
            for (BaseTypeId baseType : source.getChangesOnType()) {
                if (cmisVersion == CmisVersion.CMIS_1_0 && baseType == BaseTypeId.CMIS_ITEM) {
                    LOG.warn("Receiver only understands CMIS 1.0 but the Changes On Type list in the Repository info contains the base type Item. The Item base type has been removed from the list.");
                    continue;
                }
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "changesOnType", baseType);
            }
        }
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "principalAnonymous", source.getPrincipalIdAnonymous());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "principalAnyone", source.getPrincipalIdAnyone());
        if (cmisVersion != CmisVersion.CMIS_1_0 && source.getExtensionFeatures() != null) {
            for (ExtensionFeature feature : source.getExtensionFeatures()) {
                XMLConverter.writeExtendedFeatures(writer, cmisVersion, feature);
            }
        }
        XMLConverter.writeExtensions(writer, source);
        writer.endTag(namespace, "repositoryInfo");
    }

    public static void writeRepositoryCapabilities(XmlSerializer writer, CmisVersion cmisVersion, RepositoryCapabilities source) throws IOException {
        if (source == null) {
            return;
        }
        writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilities");
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityACL", source.getAclCapability());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityAllVersionsSearchable", source.isAllVersionsSearchableSupported());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityChanges", source.getChangesCapability());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityContentStreamUpdatability", source.getContentStreamUpdatesCapability());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityGetDescendants", source.isGetDescendantsSupported());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityGetFolderTree", source.isGetFolderTreeSupported());
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityOrderBy", source.getOrderByCapability());
        }
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityMultifiling", source.isMultifilingSupported());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityPWCSearchable", source.isPwcSearchableSupported());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityPWCUpdatable", source.isPwcUpdatableSupported());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityQuery", source.getQueryCapability());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityRenditions", source.getRenditionsCapability());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityUnfiling", source.isUnfilingSupported());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityVersionSpecificFiling", source.isVersionSpecificFilingSupported());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityJoin", source.getJoinCapability());
        if (cmisVersion != CmisVersion.CMIS_1_0) {
            if (source.getCreatablePropertyTypes() != null) {
                CreatablePropertyTypes creatablePropertyTypes = source.getCreatablePropertyTypes();
                writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityCreatablePropertyTypes");
                if (creatablePropertyTypes.canCreate() != null) {
                    for (PropertyType pt : creatablePropertyTypes.canCreate()) {
                        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "canCreate", pt);
                    }
                }
                XMLConverter.writeExtensions(writer, creatablePropertyTypes);
                writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityCreatablePropertyTypes");
            }
            if (source.getNewTypeSettableAttributes() != null) {
                NewTypeSettableAttributes newTypeSettableAttributes = source.getNewTypeSettableAttributes();
                writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityNewTypeSettableAttributes");
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "id", newTypeSettableAttributes.canSetId());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "localName", newTypeSettableAttributes.canSetLocalName());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "localNamespace", newTypeSettableAttributes.canSetLocalNamespace());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "displayName", newTypeSettableAttributes.canSetDisplayName());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "queryName", newTypeSettableAttributes.canSetQueryName());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "description", newTypeSettableAttributes.canSetDescription());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "creatable", newTypeSettableAttributes.canSetCreatable());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "fileable", newTypeSettableAttributes.canSetFileable());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "queryable", newTypeSettableAttributes.canSetQueryable());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "fulltextIndexed", newTypeSettableAttributes.canSetFulltextIndexed());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "includedInSupertypeQuery", newTypeSettableAttributes.canSetIncludedInSupertypeQuery());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "controllablePolicy", newTypeSettableAttributes.canSetControllablePolicy());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "controllableACL", newTypeSettableAttributes.canSetControllableAcl());
                XMLConverter.writeExtensions(writer, newTypeSettableAttributes);
                writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilityNewTypeSettableAttributes");
            }
        }
        XMLConverter.writeExtensions(writer, source);
        writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "capabilities");
    }

    public static void writeAclCapabilities(XmlSerializer writer, CmisVersion cmisVersion, AclCapabilities source) throws IOException {
        if (source == null) {
            return;
        }
        writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "aclCapability");
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "supportedPermissions", source.getSupportedPermissions());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "propagation", source.getAclPropagation());
        if (source.getPermissions() != null) {
            for (PermissionDefinition pd : source.getPermissions()) {
                writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "permissions");
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "permission", pd.getId());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "description", pd.getDescription());
                XMLConverter.writeExtensions(writer, pd);
                writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "permissions");
            }
        }
        if (source.getPermissionMapping() != null) {
            for (PermissionMapping pm : source.getPermissionMapping().values()) {
                writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "mapping");
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "key", pm.getKey());
                if (pm.getPermissions() != null) {
                    for (String perm : pm.getPermissions()) {
                        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "permission", perm);
                    }
                }
                XMLConverter.writeExtensions(writer, pm);
                writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "mapping");
            }
        }
        XMLConverter.writeExtensions(writer, source);
        writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "aclCapability");
    }

    public static void writeExtendedFeatures(XmlSerializer writer, CmisVersion cmisVersion, ExtensionFeature source) throws IOException {
        if (source == null) {
            return;
        }
        writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "extendedFeatures");
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "id", source.getId());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "url", source.getUrl());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "commonName", source.getCommonName());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "versionLabel", source.getVersionLabel());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "description", source.getDescription());
        if (source.getFeatureData() != null) {
            for (Map.Entry<String, String> data : source.getFeatureData().entrySet()) {
                writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "featureData");
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "key", data.getKey());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", data.getValue());
                writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "featureData");
            }
        }
        XMLConverter.writeExtensions(writer, source);
        writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "extendedFeatures");
    }

    public static void writeTypeDefinition(XmlSerializer writer, CmisVersion cmisVersion, String namespace, TypeDefinition source) throws IOException {
        if (source == null) {
            return;
        }
        if (cmisVersion == CmisVersion.CMIS_1_0) {
            if (source.getBaseTypeId() == BaseTypeId.CMIS_ITEM) {
                LOG.warn("Receiver only understands CMIS 1.0. It may not able to handle an Item type definition.");
            } else if (source.getBaseTypeId() == BaseTypeId.CMIS_SECONDARY) {
                LOG.warn("Receiver only understands CMIS 1.0. It may not able to handle a Secondary type definition.");
            }
        }
        writer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.startTag(namespace, "type");
        writer.attribute("", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (source.getBaseTypeId() == BaseTypeId.CMIS_DOCUMENT) {
            writer.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", "cmis:cmisTypeDocumentDefinitionType");
        } else if (source.getBaseTypeId() == BaseTypeId.CMIS_FOLDER) {
            writer.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", "cmis:cmisTypeFolderDefinitionType");
        } else if (source.getBaseTypeId() == BaseTypeId.CMIS_RELATIONSHIP) {
            writer.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", "cmis:cmisTypeRelationshipDefinitionType");
        } else if (source.getBaseTypeId() == BaseTypeId.CMIS_POLICY) {
            writer.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", "cmis:cmisTypePolicyDefinitionType");
        } else if (source.getBaseTypeId() == BaseTypeId.CMIS_ITEM) {
            writer.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", "cmis:cmisTypeItemDefinitionType");
        } else if (source.getBaseTypeId() == BaseTypeId.CMIS_SECONDARY) {
            writer.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", "cmis:cmisTypeSecondaryDefinitionType");
        } else {
            throw new CmisRuntimeException("Type definition has no base type id!");
        }
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "id", source.getId());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "localName", source.getLocalName());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "localNamespace", source.getLocalNamespace());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "displayName", source.getDisplayName());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "queryName", source.getQueryName());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "description", source.getDescription());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "baseId", source.getBaseTypeId());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "parentId", source.getParentTypeId());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "creatable", source.isCreatable());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "fileable", source.isFileable());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "queryable", source.isQueryable());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "fulltextIndexed", source.isFulltextIndexed());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "includedInSupertypeQuery", source.isIncludedInSupertypeQuery());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "controllablePolicy", source.isControllablePolicy());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "controllableACL", source.isControllableAcl());
        if (cmisVersion != CmisVersion.CMIS_1_0 && source.getTypeMutability() != null) {
            TypeMutability tm = source.getTypeMutability();
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "typeMutability");
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "create", tm.canCreate());
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "update", tm.canUpdate());
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "delete", tm.canDelete());
            XMLConverter.writeExtensions(writer, tm);
            writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "typeMutability");
        }
        if (source.getPropertyDefinitions() != null) {
            for (PropertyDefinition propertyDefinition : source.getPropertyDefinitions().values()) {
                XMLConverter.writePropertyDefinition(writer, cmisVersion, propertyDefinition);
            }
        }
        if (source instanceof DocumentTypeDefinition) {
            DocumentTypeDefinition docDef = (DocumentTypeDefinition)source;
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "versionable", docDef.isVersionable());
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "contentStreamAllowed", docDef.getContentStreamAllowed());
        }
        if (source instanceof RelationshipTypeDefinition) {
            RelationshipTypeDefinition relDef = (RelationshipTypeDefinition)source;
            if (relDef.getAllowedSourceTypeIds() != null) {
                for (String id : relDef.getAllowedSourceTypeIds()) {
                    if (id == null) continue;
                    XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "allowedSourceTypes", id);
                }
            }
            if (relDef.getAllowedTargetTypeIds() != null) {
                for (String id : relDef.getAllowedTargetTypeIds()) {
                    if (id == null) continue;
                    XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "allowedTargetTypes", id);
                }
            }
        }
        XMLConverter.writeExtensions(writer, source);
        writer.endTag(namespace, "type");
    }

    public static void writePropertyDefinition(XmlSerializer writer, CmisVersion cmisVersion, PropertyDefinition<?> source) throws IOException {
        PropertyDefinition<String> def;
        if (source == null) {
            return;
        }
        if (source.getPropertyType() == null) {
            throw new CmisRuntimeException("Property type for property definition '" + source.getId() + "' is not set!");
        }
        String tagName = "";
        switch (source.getPropertyType()) {
            case STRING: {
                tagName = "propertyStringDefinition";
                break;
            }
            case ID: {
                tagName = "propertyIdDefinition";
                break;
            }
            case INTEGER: {
                tagName = "propertyIntegerDefinition";
                break;
            }
            case BOOLEAN: {
                tagName = "propertyBooleanDefinition";
                break;
            }
            case DATETIME: {
                tagName = "propertyDateTimeDefinition";
                break;
            }
            case DECIMAL: {
                tagName = "propertyDecimalDefinition";
                break;
            }
            case HTML: {
                tagName = "propertyHtmlDefinition";
                break;
            }
            case URI: {
                tagName = "propertyUriDefinition";
                break;
            }
            default: {
                throw new CmisRuntimeException("Property defintion has no property type!");
            }
        }
        writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", tagName);
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "id", source.getId());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "localName", source.getLocalName());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "localNamespace", source.getLocalNamespace());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "displayName", source.getDisplayName());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "queryName", source.getQueryName());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "description", source.getDescription());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "propertyType", source.getPropertyType());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "cardinality", source.getCardinality());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "updatability", source.getUpdatability());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "inherited", source.isInherited());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "required", source.isRequired());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "queryable", source.isQueryable());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "orderable", source.isOrderable());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "openChoice", source.isOpenChoice());
        if (source instanceof PropertyStringDefinition) {
            def = (PropertyStringDefinition)source;
            if (def.getDefaultValue() != null) {
                XMLConverter.writeProperty(writer, new PropertyStringImpl((String)null, def.getDefaultValue()), true);
            }
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "maxLength", def.getMaxLength());
        } else if (source instanceof PropertyIdDefinition) {
            def = (PropertyIdDefinition)source;
            if (def.getDefaultValue() != null) {
                XMLConverter.writeProperty(writer, new PropertyIdImpl((String)null, def.getDefaultValue()), true);
            }
        } else if (source instanceof PropertyIntegerDefinition) {
            def = (PropertyIntegerDefinition)source;
            if (def.getDefaultValue() != null) {
                XMLConverter.writeProperty(writer, new PropertyIntegerImpl((String)null, def.getDefaultValue()), true);
            }
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "maxValue", def.getMaxValue());
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "minValue", def.getMinValue());
        } else if (source instanceof PropertyBooleanDefinition) {
            def = (PropertyBooleanDefinition)source;
            if (def.getDefaultValue() != null) {
                XMLConverter.writeProperty(writer, new PropertyBooleanImpl((String)null, def.getDefaultValue()), true);
            }
        } else if (source instanceof PropertyDateTimeDefinition) {
            def = (PropertyDateTimeDefinition)source;
            if (def.getDefaultValue() != null) {
                XMLConverter.writeProperty(writer, new PropertyDateTimeImpl((String)null, def.getDefaultValue()), true);
            }
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "resolution", def.getDateTimeResolution());
        } else if (source instanceof PropertyDecimalDefinition) {
            def = (PropertyDecimalDefinition)source;
            if (def.getDefaultValue() != null) {
                XMLConverter.writeProperty(writer, new PropertyDecimalImpl((String)null, def.getDefaultValue()), true);
            }
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "maxValue", def.getMaxValue());
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "minValue", def.getMinValue());
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "precision", def.getPrecision());
        } else if (source instanceof PropertyHtmlDefinition) {
            def = (PropertyHtmlDefinition)source;
            if (def.getDefaultValue() != null) {
                XMLConverter.writeProperty(writer, new PropertyHtmlImpl((String)null, def.getDefaultValue()), true);
            }
        } else if (source instanceof PropertyUriDefinition && (def = (PropertyUriDefinition)source).getDefaultValue() != null) {
            XMLConverter.writeProperty(writer, new PropertyUriImpl((String)null, def.getDefaultValue()), true);
        }
        if (source.getChoices() != null) {
            for (Choice<?> c : source.getChoices()) {
                if (c == null) continue;
                XMLConverter.writeChoice(writer, source.getPropertyType(), c);
            }
        }
        XMLConverter.writeExtensions(writer, source);
        writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", tagName);
    }

    public static void writeChoice(XmlSerializer writer, PropertyType propType, Choice<?> source) throws IOException {
        if (source == null) {
            return;
        }
        writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "choice");
        if (source.getDisplayName() != null) {
            writer.attribute("", "displayName", source.getDisplayName());
        }
        if (source.getValue() != null) {
            switch (propType) {
                case STRING: 
                case ID: 
                case HTML: 
                case URI: {
                    for (Object value : source.getValue()) {
                        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", (String)value);
                    }
                    break;
                }
                case INTEGER: {
                    for (Object value : source.getValue()) {
                        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", (BigInteger)value);
                    }
                    break;
                }
                case BOOLEAN: {
                    for (Object value : source.getValue()) {
                        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", (Boolean)value);
                    }
                    break;
                }
                case DATETIME: {
                    for (Object value : source.getValue()) {
                        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", (GregorianCalendar)value);
                    }
                    break;
                }
                case DECIMAL: {
                    for (Object value : source.getValue()) {
                        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", (BigDecimal)value);
                    }
                    break;
                }
            }
        }
        if (source.getChoice() != null) {
            for (Choice<?> c : source.getChoice()) {
                if (c == null) continue;
                XMLConverter.writeChoice(writer, propType, c);
            }
        }
        writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "choice");
    }

    public static void writeObject(XmlSerializer writer, CmisVersion cmisVersion, String namespace, ObjectData source) throws IOException {
        XMLConverter.writeObject(writer, cmisVersion, false, "object", namespace, source);
    }

    public static void writeObject(XmlSerializer writer, CmisVersion cmisVersion, boolean root, String name, String namespace, ObjectData source) throws IOException {
        if (source == null) {
            return;
        }
        if (cmisVersion == CmisVersion.CMIS_1_0 && source.getBaseTypeId() == BaseTypeId.CMIS_ITEM) {
            LOG.warn("Receiver only understands CMIS 1.0. It may not be able to handle an Item object.");
        }
        if (root) {
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", name);
            writer.attribute("", "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
            namespace = "http://docs.oasis-open.org/ns/cmis/core/200908/";
        } else {
            writer.startTag(namespace, name);
        }
        if (source.getProperties() != null) {
            Properties properties = source.getProperties();
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "properties");
            if (properties.getPropertyList() != null) {
                for (PropertyData<?> property : properties.getPropertyList()) {
                    XMLConverter.writeProperty(writer, property, false);
                }
            }
            XMLConverter.writeExtensions(writer, properties);
            writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "properties");
        }
        if (source.getAllowableActions() != null) {
            XMLConverter.writeAllowableActions(writer, cmisVersion, false, source.getAllowableActions());
        }
        if (source.getRelationships() != null) {
            for (ObjectData objectData : source.getRelationships()) {
                if (objectData == null) continue;
                XMLConverter.writeObject(writer, cmisVersion, false, "relationship", "http://docs.oasis-open.org/ns/cmis/core/200908/", objectData);
            }
        }
        if (source.getChangeEventInfo() != null) {
            ChangeEventInfo info = source.getChangeEventInfo();
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "changeEventInfo");
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "changeType", info.getChangeType());
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "changeTime", info.getChangeTime());
            XMLConverter.writeExtensions(writer, info);
            writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "changeEventInfo");
        }
        if (source.getAcl() != null) {
            XMLConverter.writeAcl(writer, cmisVersion, false, source.getAcl());
        }
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "exactACL", source.isExactAcl());
        if (source.getPolicyIds() != null) {
            PolicyIdList pids = source.getPolicyIds();
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "policyIds");
            if (pids.getPolicyIds() != null) {
                for (String id : pids.getPolicyIds()) {
                    if (id == null) continue;
                    XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "id", id);
                }
            }
            XMLConverter.writeExtensions(writer, pids);
            writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "policyIds");
        }
        if (source.getRenditions() != null) {
            for (RenditionData renditionData : source.getRenditions()) {
                if (renditionData == null) continue;
                writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "rendition");
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "streamId", renditionData.getStreamId());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "mimetype", renditionData.getMimeType());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "length", renditionData.getBigLength());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "kind", renditionData.getKind());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "title", renditionData.getTitle());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "height", renditionData.getBigHeight());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "width", renditionData.getBigWidth());
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "renditionDocumentId", renditionData.getRenditionDocumentId());
                XMLConverter.writeExtensions(writer, renditionData);
                writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "rendition");
            }
        }
        XMLConverter.writeExtensions(writer, source);
        writer.endTag(namespace, name);
    }

    public static void writeProperty(XmlSerializer writer, PropertyData<?> source, boolean isDefaultValue) throws IOException {
        List values;
        if (source == null) {
            return;
        }
        String tagName = "defaultValue";
        if (isDefaultValue) {
            tagName = "defaultValue";
        } else if (source instanceof PropertyString) {
            tagName = "propertyString";
        } else if (source instanceof PropertyId) {
            tagName = "propertyId";
        } else if (source instanceof PropertyInteger) {
            tagName = "propertyInteger";
        } else if (source instanceof PropertyBoolean) {
            tagName = "propertyBoolean";
        } else if (source instanceof PropertyDateTime) {
            tagName = "propertyDateTime";
        } else if (source instanceof PropertyDecimal) {
            tagName = "propertyDecimal";
        } else if (source instanceof PropertyHtml) {
            tagName = "propertyHtml";
        } else if (source instanceof PropertyUri) {
            tagName = "propertyUri";
        } else {
            throw new CmisRuntimeException("Invalid property!");
        }
        writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", tagName);
        if (source.getId() != null) {
            writer.attribute(null, "propertyDefinitionId", source.getId());
        }
        if (source.getDisplayName() != null) {
            writer.attribute(null, "displayName", source.getDisplayName());
        }
        if (source.getLocalName() != null) {
            writer.attribute(null, "localName", source.getLocalName());
        }
        if (source.getQueryName() != null) {
            writer.attribute(null, "queryName", source.getQueryName());
        }
        if (source instanceof PropertyString || source instanceof PropertyId || source instanceof PropertyHtml || source instanceof PropertyUri) {
            List<?> values2 = source.getValues();
            if (values2 != null) {
                for (String value : values2) {
                    XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", value);
                }
            }
        } else if (source instanceof PropertyInteger) {
            List values3 = ((PropertyInteger)source).getValues();
            if (values3 != null) {
                for (BigInteger value : values3) {
                    XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", value);
                }
            }
        } else if (source instanceof PropertyBoolean) {
            List values4 = ((PropertyBoolean)source).getValues();
            if (values4 != null) {
                for (Boolean value : values4) {
                    XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", value);
                }
            }
        } else if (source instanceof PropertyDateTime) {
            List values5 = ((PropertyDateTime)source).getValues();
            if (values5 != null) {
                for (GregorianCalendar value : values5) {
                    XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", value);
                }
            }
        } else if (source instanceof PropertyDecimal && (values = ((PropertyDecimal)source).getValues()) != null) {
            for (BigDecimal value : values) {
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "value", value);
            }
        }
        XMLConverter.writeExtensions(writer, source);
        writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", tagName);
    }

    public static void writeAllowableActions(XmlSerializer writer, CmisVersion cmisVersion, boolean root, AllowableActions source) throws IOException {
        if (source == null) {
            return;
        }
        if (root) {
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "allowableActions");
            writer.attribute("", "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        } else {
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "allowableActions");
        }
        if (source.getAllowableActions() != null) {
            for (Action action : Action.values()) {
                if (!source.getAllowableActions().contains((Object)action)) continue;
                if (action == Action.CAN_CREATE_ITEM && cmisVersion == CmisVersion.CMIS_1_0) {
                    LOG.warn("Receiver only understands CMIS 1.0 but the Allowable Actions contain the canCreateItem action. The canCreateItem action has been removed from the Allowable Actions.");
                    continue;
                }
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", action.value(), Boolean.TRUE);
            }
        }
        XMLConverter.writeExtensions(writer, source);
        writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "allowableActions");
    }

    public static void writeAcl(XmlSerializer writer, CmisVersion cmisVersion, boolean root, Acl source) throws IOException {
        if (source == null) {
            return;
        }
        if (root) {
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "acl");
            writer.attribute("", "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        } else {
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "acl");
        }
        if (source.getAces() != null) {
            for (Ace ace : source.getAces()) {
                if (ace == null) continue;
                writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "permission");
                if (ace.getPrincipal() != null) {
                    Principal principal = ace.getPrincipal();
                    writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "principal");
                    XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "principalId", principal.getId());
                    XMLConverter.writeExtensions(writer, principal);
                    writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "principal");
                }
                if (ace.getPermissions() != null) {
                    for (String perm : ace.getPermissions()) {
                        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "permission", perm);
                    }
                }
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "direct", ace.isDirect());
                XMLConverter.writeExtensions(writer, ace);
                writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "permission");
            }
        }
        XMLConverter.writeExtensions(writer, source);
        writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "acl");
    }

    public static void writeQuery(XmlSerializer writer, CmisVersion cmisVersion, QueryTypeImpl source) throws IOException {
        if (source == null) {
            return;
        }
        writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "query");
        writer.attribute(null, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "statement", source.getStatement());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "searchAllVersions", source.getSearchAllVersions());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "includeAllowableActions", source.getIncludeAllowableActions());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "includeRelationships", source.getIncludeRelationships());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "renditionFilter", source.getRenditionFilter());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "maxItems", source.getMaxItems());
        XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "skipCount", source.getSkipCount());
        XMLConverter.writeExtensions(writer, source);
        writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "query");
    }

    public static void writeBulkUpdate(XmlSerializer writer, String namespace, BulkUpdateImpl bulkUpdate) throws IOException {
        if (bulkUpdate == null || bulkUpdate.getObjectIdAndChangeToken() == null) {
            return;
        }
        writer.startTag(namespace, "bulkUpdate");
        for (BulkUpdateObjectIdAndChangeToken bulkUpdateObjectIdAndChangeToken : bulkUpdate.getObjectIdAndChangeToken()) {
            if (bulkUpdateObjectIdAndChangeToken == null) continue;
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "objectIdAndChangeToken");
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "id", bulkUpdateObjectIdAndChangeToken.getId());
            XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "changeToken", bulkUpdateObjectIdAndChangeToken.getChangeToken());
            XMLConverter.writeExtensions(writer, bulkUpdateObjectIdAndChangeToken);
            writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "objectIdAndChangeToken");
        }
        if (bulkUpdate.getProperties() != null) {
            Properties properties = bulkUpdate.getProperties();
            writer.startTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "properties");
            if (properties.getPropertyList() != null) {
                for (PropertyData<?> propertyData : properties.getPropertyList()) {
                    XMLConverter.writeProperty(writer, propertyData, false);
                }
            }
            XMLConverter.writeExtensions(writer, properties);
            writer.endTag("http://docs.oasis-open.org/ns/cmis/core/200908/", "properties");
        }
        if (bulkUpdate.getAddSecondaryTypeIds() != null) {
            for (String string : bulkUpdate.getAddSecondaryTypeIds()) {
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "addSecondaryTypeIds", string);
            }
        }
        if (bulkUpdate.getRemoveSecondaryTypeIds() != null) {
            for (String string : bulkUpdate.getRemoveSecondaryTypeIds()) {
                XMLUtils.write(writer, "cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/", "removeSecondaryTypeIds", string);
            }
        }
        writer.endTag(namespace, "bulkUpdate");
    }

    public static void writeExtensions(XmlSerializer writer, ExtensionsData source) throws IOException {
        if (source == null) {
            return;
        }
        LinkedList<String> ns = new LinkedList<String>();
        if (source.getExtensions() != null) {
            for (CmisExtensionElement element : source.getExtensions()) {
                if (element == null) continue;
                XMLConverter.writeExtensionElement(writer, element, ns);
            }
        }
    }

    private static void writeExtensionElement(XmlSerializer writer, CmisExtensionElement source, LinkedList<String> ns) throws IOException {
        if (source == null || source.getName() == null) {
            return;
        }
        String namespace = null;
        if (source.getNamespace() != null) {
            namespace = source.getNamespace();
            writer.startTag(source.getNamespace(), source.getName());
        } else {
            writer.startTag(null, source.getName());
        }
        if (source.getAttributes() != null) {
            for (Map.Entry<String, String> attr : source.getAttributes().entrySet()) {
                writer.attribute(null, attr.getKey(), attr.getValue());
            }
        }
        if (source.getValue() != null) {
            writer.text(source.getValue());
        } else if (source.getChildren() != null) {
            for (CmisExtensionElement child : source.getChildren()) {
                XMLConverter.writeExtensionElement(writer, child, ns);
            }
        }
        writer.endTag(namespace, source.getName());
    }

    public static RepositoryInfo convertRepositoryInfo(XmlPullParser parser) throws XmlPullParserException {
        return REPOSITORY_INFO_PARSER.walk(parser);
    }

    public static TypeDefinition convertTypeDefinition(XmlPullParser parser) throws XmlPullParserException {
        return TYPE_DEF_PARSER.walk(parser);
    }

    public static ObjectData convertObject(XmlPullParser parser) throws XmlPullParserException {
        return OBJECT_PARSER.walk(parser);
    }

    public static QueryTypeImpl convertQuery(XmlPullParser parser) throws XmlPullParserException {
        return QUERY_PARSER.walk(parser);
    }

    public static AllowableActions convertAllowableActions(XmlPullParser parser) throws XmlPullParserException {
        return ALLOWABLE_ACTIONS_PARSER.walk(parser);
    }

    public static Acl convertAcl(XmlPullParser parser) throws XmlPullParserException {
        return ACL_PARSER.walk(parser);
    }

    public static BulkUpdateImpl convertBulkUpdate(XmlPullParser parser) throws XmlPullParserException {
        return BULK_UPDATE_PARSER.walk(parser);
    }

    private static abstract class PropertyStringAtomPubXMLWalker<T extends AbstractPropertyData<String>>
    extends PropertyAtomPubXMLWalker<T> {
        private PropertyStringAtomPubXMLWalker() {
        }

        @Override
        protected void addValue(XmlPullParser parser, T target) throws XmlPullParserException {
            ((AbstractPropertyData)((Object)target)).setValues(this.addToList(((AbstractPropertyData)((Object)target)).getValues(), this.readText(parser)));
        }
    }

    private static abstract class PropertyAtomPubXMLWalker<T extends AbstractPropertyData<?>>
    extends XMLWalker<T> {
        private PropertyAtomPubXMLWalker() {
        }

        protected abstract T createTarget(XmlPullParser var1, QName var2);

        @Override
        protected T prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            T result = this.createTarget(parser, name);
            if (parser.getAttributeCount() > 0) {
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    String attr = parser.getAttributeName(i);
                    if ("propertyDefinitionId".equals(attr)) {
                        ((AbstractPropertyData)result).setId(parser.getAttributeValue(i));
                        continue;
                    }
                    if ("localName".equals(attr)) {
                        ((AbstractPropertyData)result).setLocalName(parser.getAttributeValue(i));
                        continue;
                    }
                    if ("displayName".equals(attr)) {
                        ((AbstractPropertyData)result).setDisplayName(parser.getAttributeValue(i));
                        continue;
                    }
                    if (!"queryName".equals(attr)) continue;
                    ((AbstractPropertyData)result).setQueryName(parser.getAttributeValue(i));
                }
            }
            return result;
        }

        protected abstract void addValue(XmlPullParser var1, T var2) throws XmlPullParserException;

        @Override
        protected boolean read(XmlPullParser parser, QName name, T target) throws XmlPullParserException {
            if (this.isCmisNamespace(name) && this.isTag(name, "value")) {
                this.addValue(parser, target);
                return true;
            }
            return false;
        }
    }

    private static abstract class ChoiceAtomPubXMLWalker<T>
    extends XMLWalker<ChoiceImpl<T>> {
        private ChoiceAtomPubXMLWalker() {
        }

        public void addToChoiceList(XmlPullParser parser, AbstractPropertyDefinition<T> propDef) throws XmlPullParserException {
            propDef.setChoices(this.addToList(propDef.getChoices(), (Choice)this.walk(parser)));
        }

        protected abstract ChoiceImpl<T> createTarget(XmlPullParser var1, QName var2);

        @Override
        protected ChoiceImpl<T> prepareTarget(XmlPullParser parser, QName name) throws XmlPullParserException {
            ChoiceImpl<T> result = this.createTarget(parser, name);
            if (parser.getAttributeCount() > 0) {
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    String attr = parser.getAttributeName(i);
                    if (!"displayName".equals(attr)) continue;
                    result.setDisplayName(parser.getAttributeValue(i));
                }
            }
            return result;
        }

        @Override
        protected boolean read(XmlPullParser parser, QName name, ChoiceImpl<T> target) throws XmlPullParserException {
            if (this.isCmisNamespace(name)) {
                if (this.isTag(name, "value")) {
                    this.addValue(parser, target);
                    return true;
                }
                if (this.isTag(name, "choice")) {
                    this.addChoice(parser, target);
                    return true;
                }
            }
            return false;
        }

        protected abstract void addValue(XmlPullParser var1, ChoiceImpl<T> var2) throws XmlPullParserException;

        protected abstract void addChoice(XmlPullParser var1, ChoiceImpl<T> var2) throws XmlPullParserException;
    }
}

